/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Values that you can use to select a particular Amazon EC2 instance type.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcceleratorSelection implements SdkPojo, Serializable,
        ToCopyableBuilder<AcceleratorSelection.Builder, AcceleratorSelection> {
    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(AcceleratorSelection::nameAsString)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> RUNTIME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runtime")
            .getter(getter(AcceleratorSelection::runtime)).setter(setter(Builder::runtime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runtime").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(NAME_FIELD, RUNTIME_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String name;

    private final String runtime;

    private AcceleratorSelection(BuilderImpl builder) {
        this.name = builder.name;
        this.runtime = builder.runtime;
    }

    /**
     * <p>
     * The name of the GPU accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AcceleratorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the GPU accelerator.
     * @see AcceleratorName
     */
    public final AcceleratorName name() {
        return AcceleratorName.fromValue(name);
    }

    /**
     * <p>
     * The name of the GPU accelerator.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #name} will return
     * {@link AcceleratorName#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #nameAsString}.
     * </p>
     * 
     * @return The name of the GPU accelerator.
     * @see AcceleratorName
     */
    public final String nameAsString() {
        return name;
    }

    /**
     * <p>
     * The driver version that the GPU accelerator uses.
     * </p>
     * 
     * @return The driver version that the GPU accelerator uses.
     */
    public final String runtime() {
        return runtime;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(nameAsString());
        hashCode = 31 * hashCode + Objects.hashCode(runtime());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcceleratorSelection)) {
            return false;
        }
        AcceleratorSelection other = (AcceleratorSelection) obj;
        return Objects.equals(nameAsString(), other.nameAsString()) && Objects.equals(runtime(), other.runtime());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcceleratorSelection").add("Name", nameAsString()).add("Runtime", runtime()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "name":
            return Optional.ofNullable(clazz.cast(nameAsString()));
        case "runtime":
            return Optional.ofNullable(clazz.cast(runtime()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("name", NAME_FIELD);
        map.put("runtime", RUNTIME_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcceleratorSelection, T> g) {
        return obj -> g.apply((AcceleratorSelection) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcceleratorSelection> {
        /**
         * <p>
         * The name of the GPU accelerator.
         * </p>
         * 
         * @param name
         *        The name of the GPU accelerator.
         * @see AcceleratorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceleratorName
         */
        Builder name(String name);

        /**
         * <p>
         * The name of the GPU accelerator.
         * </p>
         * 
         * @param name
         *        The name of the GPU accelerator.
         * @see AcceleratorName
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AcceleratorName
         */
        Builder name(AcceleratorName name);

        /**
         * <p>
         * The driver version that the GPU accelerator uses.
         * </p>
         * 
         * @param runtime
         *        The driver version that the GPU accelerator uses.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder runtime(String runtime);
    }

    static final class BuilderImpl implements Builder {
        private String name;

        private String runtime;

        private BuilderImpl() {
        }

        private BuilderImpl(AcceleratorSelection model) {
            name(model.name);
            runtime(model.runtime);
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        @Override
        public final Builder name(AcceleratorName name) {
            this.name(name == null ? null : name.toString());
            return this;
        }

        public final String getRuntime() {
            return runtime;
        }

        public final void setRuntime(String runtime) {
            this.runtime = runtime;
        }

        @Override
        public final Builder runtime(String runtime) {
            this.runtime = runtime;
            return this;
        }

        @Override
        public AcceleratorSelection build() {
            return new AcceleratorSelection(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
