/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssumeQueueRoleForReadResponse extends DeadlineResponse implements
        ToCopyableBuilder<AssumeQueueRoleForReadResponse.Builder, AssumeQueueRoleForReadResponse> {
    private static final SdkField<AwsCredentials> CREDENTIALS_FIELD = SdkField.<AwsCredentials> builder(MarshallingType.SDK_POJO)
            .memberName("credentials").getter(getter(AssumeQueueRoleForReadResponse::credentials))
            .setter(setter(Builder::credentials)).constructor(AwsCredentials::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("credentials").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREDENTIALS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final AwsCredentials credentials;

    private AssumeQueueRoleForReadResponse(BuilderImpl builder) {
        super(builder);
        this.credentials = builder.credentials;
    }

    /**
     * <p>
     * The credentials for the queue role.
     * </p>
     * 
     * @return The credentials for the queue role.
     */
    public final AwsCredentials credentials() {
        return credentials;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(credentials());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssumeQueueRoleForReadResponse)) {
            return false;
        }
        AssumeQueueRoleForReadResponse other = (AssumeQueueRoleForReadResponse) obj;
        return Objects.equals(credentials(), other.credentials());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssumeQueueRoleForReadResponse")
                .add("Credentials", credentials() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "credentials":
            return Optional.ofNullable(clazz.cast(credentials()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("credentials", CREDENTIALS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssumeQueueRoleForReadResponse, T> g) {
        return obj -> g.apply((AssumeQueueRoleForReadResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, AssumeQueueRoleForReadResponse> {
        /**
         * <p>
         * The credentials for the queue role.
         * </p>
         * 
         * @param credentials
         *        The credentials for the queue role.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder credentials(AwsCredentials credentials);

        /**
         * <p>
         * The credentials for the queue role.
         * </p>
         * This is a convenience method that creates an instance of the {@link AwsCredentials.Builder} avoiding the need
         * to create one manually via {@link AwsCredentials#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AwsCredentials.Builder#build()} is called immediately and its
         * result is passed to {@link #credentials(AwsCredentials)}.
         * 
         * @param credentials
         *        a consumer that will call methods on {@link AwsCredentials.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #credentials(AwsCredentials)
         */
        default Builder credentials(Consumer<AwsCredentials.Builder> credentials) {
            return credentials(AwsCredentials.builder().applyMutation(credentials).build());
        }
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private AwsCredentials credentials;

        private BuilderImpl() {
        }

        private BuilderImpl(AssumeQueueRoleForReadResponse model) {
            super(model);
            credentials(model.credentials);
        }

        public final AwsCredentials.Builder getCredentials() {
            return credentials != null ? credentials.toBuilder() : null;
        }

        public final void setCredentials(AwsCredentials.BuilderImpl credentials) {
            this.credentials = credentials != null ? credentials.build() : null;
        }

        @Override
        public final Builder credentials(AwsCredentials credentials) {
            this.credentials = credentials;
            return this;
        }

        @Override
        public AssumeQueueRoleForReadResponse build() {
            return new AssumeQueueRoleForReadResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
