/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyJobTemplateRequest extends DeadlineRequest implements
        ToCopyableBuilder<CopyJobTemplateRequest.Builder, CopyJobTemplateRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CopyJobTemplateRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(CopyJobTemplateRequest::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(CopyJobTemplateRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<S3Location> TARGET_S3_LOCATION_FIELD = SdkField.<S3Location> builder(MarshallingType.SDK_POJO)
            .memberName("targetS3Location").getter(getter(CopyJobTemplateRequest::targetS3Location))
            .setter(setter(Builder::targetS3Location)).constructor(S3Location::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetS3Location").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, JOB_ID_FIELD,
            QUEUE_ID_FIELD, TARGET_S3_LOCATION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final String jobId;

    private final String queueId;

    private final S3Location targetS3Location;

    private CopyJobTemplateRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.targetS3Location = builder.targetS3Location;
    }

    /**
     * <p>
     * The farm ID to copy.
     * </p>
     * 
     * @return The farm ID to copy.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The job ID to copy.
     * </p>
     * 
     * @return The job ID to copy.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The queue ID to copy.
     * </p>
     * 
     * @return The queue ID to copy.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The Amazon S3 bucket name and key where you would like to add a copy of the job template.
     * </p>
     * 
     * @return The Amazon S3 bucket name and key where you would like to add a copy of the job template.
     */
    public final S3Location targetS3Location() {
        return targetS3Location;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(targetS3Location());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJobTemplateRequest)) {
            return false;
        }
        CopyJobTemplateRequest other = (CopyJobTemplateRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(targetS3Location(), other.targetS3Location());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyJobTemplateRequest").add("FarmId", farmId()).add("JobId", jobId()).add("QueueId", queueId())
                .add("TargetS3Location", targetS3Location()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "targetS3Location":
            return Optional.ofNullable(clazz.cast(targetS3Location()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("targetS3Location", TARGET_S3_LOCATION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyJobTemplateRequest, T> g) {
        return obj -> g.apply((CopyJobTemplateRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CopyJobTemplateRequest> {
        /**
         * <p>
         * The farm ID to copy.
         * </p>
         * 
         * @param farmId
         *        The farm ID to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The job ID to copy.
         * </p>
         * 
         * @param jobId
         *        The job ID to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The queue ID to copy.
         * </p>
         * 
         * @param queueId
         *        The queue ID to copy.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The Amazon S3 bucket name and key where you would like to add a copy of the job template.
         * </p>
         * 
         * @param targetS3Location
         *        The Amazon S3 bucket name and key where you would like to add a copy of the job template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder targetS3Location(S3Location targetS3Location);

        /**
         * <p>
         * The Amazon S3 bucket name and key where you would like to add a copy of the job template.
         * </p>
         * This is a convenience method that creates an instance of the {@link S3Location.Builder} avoiding the need to
         * create one manually via {@link S3Location#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link S3Location.Builder#build()} is called immediately and its result
         * is passed to {@link #targetS3Location(S3Location)}.
         * 
         * @param targetS3Location
         *        a consumer that will call methods on {@link S3Location.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #targetS3Location(S3Location)
         */
        default Builder targetS3Location(Consumer<S3Location.Builder> targetS3Location) {
            return targetS3Location(S3Location.builder().applyMutation(targetS3Location).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private String jobId;

        private String queueId;

        private S3Location targetS3Location;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJobTemplateRequest model) {
            super(model);
            farmId(model.farmId);
            jobId(model.jobId);
            queueId(model.queueId);
            targetS3Location(model.targetS3Location);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final S3Location.Builder getTargetS3Location() {
            return targetS3Location != null ? targetS3Location.toBuilder() : null;
        }

        public final void setTargetS3Location(S3Location.BuilderImpl targetS3Location) {
            this.targetS3Location = targetS3Location != null ? targetS3Location.build() : null;
        }

        @Override
        public final Builder targetS3Location(S3Location targetS3Location) {
            this.targetS3Location = targetS3Location;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CopyJobTemplateRequest build() {
            return new CopyJobTemplateRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
