/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CopyJobTemplateResponse extends DeadlineResponse implements
        ToCopyableBuilder<CopyJobTemplateResponse.Builder, CopyJobTemplateResponse> {
    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(CopyJobTemplateResponse::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TEMPLATE_TYPE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String templateType;

    private CopyJobTemplateResponse(BuilderImpl builder) {
        super(builder);
        this.templateType = builder.templateType;
    }

    /**
     * <p>
     * The format of the job template, either <code>JSON</code> or <code>YAML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link JobTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The format of the job template, either <code>JSON</code> or <code>YAML</code>.
     * @see JobTemplateType
     */
    public final JobTemplateType templateType() {
        return JobTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The format of the job template, either <code>JSON</code> or <code>YAML</code>.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link JobTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The format of the job template, either <code>JSON</code> or <code>YAML</code>.
     * @see JobTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CopyJobTemplateResponse)) {
            return false;
        }
        CopyJobTemplateResponse other = (CopyJobTemplateResponse) obj;
        return Objects.equals(templateTypeAsString(), other.templateTypeAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CopyJobTemplateResponse").add("TemplateType", templateTypeAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CopyJobTemplateResponse, T> g) {
        return obj -> g.apply((CopyJobTemplateResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, CopyJobTemplateResponse> {
        /**
         * <p>
         * The format of the job template, either <code>JSON</code> or <code>YAML</code>.
         * </p>
         * 
         * @param templateType
         *        The format of the job template, either <code>JSON</code> or <code>YAML</code>.
         * @see JobTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The format of the job template, either <code>JSON</code> or <code>YAML</code>.
         * </p>
         * 
         * @param templateType
         *        The format of the job template, either <code>JSON</code> or <code>YAML</code>.
         * @see JobTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobTemplateType
         */
        Builder templateType(JobTemplateType templateType);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String templateType;

        private BuilderImpl() {
        }

        private BuilderImpl(CopyJobTemplateResponse model) {
            super(model);
            templateType(model.templateType);
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(JobTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        @Override
        public CopyJobTemplateResponse build() {
            return new CopyJobTemplateResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
