/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a customer managed fleet configuration.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerManagedFleetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerManagedFleetConfiguration.Builder, CustomerManagedFleetConfiguration> {
    private static final SdkField<String> MODE_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("mode")
            .getter(getter(CustomerManagedFleetConfiguration::modeAsString)).setter(setter(Builder::mode))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("mode").build()).build();

    private static final SdkField<CustomerManagedWorkerCapabilities> WORKER_CAPABILITIES_FIELD = SdkField
            .<CustomerManagedWorkerCapabilities> builder(MarshallingType.SDK_POJO).memberName("workerCapabilities")
            .getter(getter(CustomerManagedFleetConfiguration::workerCapabilities)).setter(setter(Builder::workerCapabilities))
            .constructor(CustomerManagedWorkerCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerCapabilities").build())
            .build();

    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(CustomerManagedFleetConfiguration::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MODE_FIELD,
            WORKER_CAPABILITIES_FIELD, STORAGE_PROFILE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String mode;

    private final CustomerManagedWorkerCapabilities workerCapabilities;

    private final String storageProfileId;

    private CustomerManagedFleetConfiguration(BuilderImpl builder) {
        this.mode = builder.mode;
        this.workerCapabilities = builder.workerCapabilities;
        this.storageProfileId = builder.storageProfileId;
    }

    /**
     * <p>
     * The Auto Scaling mode for the customer managed fleet configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The Auto Scaling mode for the customer managed fleet configuration.
     * @see AutoScalingMode
     */
    public final AutoScalingMode mode() {
        return AutoScalingMode.fromValue(mode);
    }

    /**
     * <p>
     * The Auto Scaling mode for the customer managed fleet configuration.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #mode} will return
     * {@link AutoScalingMode#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #modeAsString}.
     * </p>
     * 
     * @return The Auto Scaling mode for the customer managed fleet configuration.
     * @see AutoScalingMode
     */
    public final String modeAsString() {
        return mode;
    }

    /**
     * <p>
     * The worker capabilities for a customer managed fleet configuration.
     * </p>
     * 
     * @return The worker capabilities for a customer managed fleet configuration.
     */
    public final CustomerManagedWorkerCapabilities workerCapabilities() {
        return workerCapabilities;
    }

    /**
     * <p>
     * The storage profile ID.
     * </p>
     * 
     * @return The storage profile ID.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(modeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(workerCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedFleetConfiguration)) {
            return false;
        }
        CustomerManagedFleetConfiguration other = (CustomerManagedFleetConfiguration) obj;
        return Objects.equals(modeAsString(), other.modeAsString())
                && Objects.equals(workerCapabilities(), other.workerCapabilities())
                && Objects.equals(storageProfileId(), other.storageProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerManagedFleetConfiguration").add("Mode", modeAsString())
                .add("WorkerCapabilities", workerCapabilities()).add("StorageProfileId", storageProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "mode":
            return Optional.ofNullable(clazz.cast(modeAsString()));
        case "workerCapabilities":
            return Optional.ofNullable(clazz.cast(workerCapabilities()));
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("mode", MODE_FIELD);
        map.put("workerCapabilities", WORKER_CAPABILITIES_FIELD);
        map.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedFleetConfiguration, T> g) {
        return obj -> g.apply((CustomerManagedFleetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerManagedFleetConfiguration> {
        /**
         * <p>
         * The Auto Scaling mode for the customer managed fleet configuration.
         * </p>
         * 
         * @param mode
         *        The Auto Scaling mode for the customer managed fleet configuration.
         * @see AutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingMode
         */
        Builder mode(String mode);

        /**
         * <p>
         * The Auto Scaling mode for the customer managed fleet configuration.
         * </p>
         * 
         * @param mode
         *        The Auto Scaling mode for the customer managed fleet configuration.
         * @see AutoScalingMode
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see AutoScalingMode
         */
        Builder mode(AutoScalingMode mode);

        /**
         * <p>
         * The worker capabilities for a customer managed fleet configuration.
         * </p>
         * 
         * @param workerCapabilities
         *        The worker capabilities for a customer managed fleet configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerCapabilities(CustomerManagedWorkerCapabilities workerCapabilities);

        /**
         * <p>
         * The worker capabilities for a customer managed fleet configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomerManagedWorkerCapabilities.Builder} avoiding the need to create one manually via
         * {@link CustomerManagedWorkerCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedWorkerCapabilities.Builder#build()} is called
         * immediately and its result is passed to {@link #workerCapabilities(CustomerManagedWorkerCapabilities)}.
         * 
         * @param workerCapabilities
         *        a consumer that will call methods on {@link CustomerManagedWorkerCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerCapabilities(CustomerManagedWorkerCapabilities)
         */
        default Builder workerCapabilities(Consumer<CustomerManagedWorkerCapabilities.Builder> workerCapabilities) {
            return workerCapabilities(CustomerManagedWorkerCapabilities.builder().applyMutation(workerCapabilities).build());
        }

        /**
         * <p>
         * The storage profile ID.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);
    }

    static final class BuilderImpl implements Builder {
        private String mode;

        private CustomerManagedWorkerCapabilities workerCapabilities;

        private String storageProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedFleetConfiguration model) {
            mode(model.mode);
            workerCapabilities(model.workerCapabilities);
            storageProfileId(model.storageProfileId);
        }

        public final String getMode() {
            return mode;
        }

        public final void setMode(String mode) {
            this.mode = mode;
        }

        @Override
        public final Builder mode(String mode) {
            this.mode = mode;
            return this;
        }

        @Override
        public final Builder mode(AutoScalingMode mode) {
            this.mode(mode == null ? null : mode.toString());
            return this;
        }

        public final CustomerManagedWorkerCapabilities.Builder getWorkerCapabilities() {
            return workerCapabilities != null ? workerCapabilities.toBuilder() : null;
        }

        public final void setWorkerCapabilities(CustomerManagedWorkerCapabilities.BuilderImpl workerCapabilities) {
            this.workerCapabilities = workerCapabilities != null ? workerCapabilities.build() : null;
        }

        @Override
        public final Builder workerCapabilities(CustomerManagedWorkerCapabilities workerCapabilities) {
            this.workerCapabilities = workerCapabilities;
            return this;
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        @Override
        public CustomerManagedFleetConfiguration build() {
            return new CustomerManagedFleetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
