/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The worker capabilities for a customer managed workflow.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class CustomerManagedWorkerCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<CustomerManagedWorkerCapabilities.Builder, CustomerManagedWorkerCapabilities> {
    private static final SdkField<VCpuCountRange> V_CPU_COUNT_FIELD = SdkField.<VCpuCountRange> builder(MarshallingType.SDK_POJO)
            .memberName("vCpuCount").getter(getter(CustomerManagedWorkerCapabilities::vCpuCount))
            .setter(setter(Builder::vCpuCount)).constructor(VCpuCountRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpuCount").build()).build();

    private static final SdkField<MemoryMiBRange> MEMORY_MIB_FIELD = SdkField.<MemoryMiBRange> builder(MarshallingType.SDK_POJO)
            .memberName("memoryMiB").getter(getter(CustomerManagedWorkerCapabilities::memoryMiB))
            .setter(setter(Builder::memoryMiB)).constructor(MemoryMiBRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryMiB").build()).build();

    private static final SdkField<List<String>> ACCELERATOR_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("acceleratorTypes")
            .getter(getter(CustomerManagedWorkerCapabilities::acceleratorTypesAsStrings))
            .setter(setter(Builder::acceleratorTypesWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<AcceleratorCountRange> ACCELERATOR_COUNT_FIELD = SdkField
            .<AcceleratorCountRange> builder(MarshallingType.SDK_POJO).memberName("acceleratorCount")
            .getter(getter(CustomerManagedWorkerCapabilities::acceleratorCount)).setter(setter(Builder::acceleratorCount))
            .constructor(AcceleratorCountRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorCount").build()).build();

    private static final SdkField<AcceleratorTotalMemoryMiBRange> ACCELERATOR_TOTAL_MEMORY_MIB_FIELD = SdkField
            .<AcceleratorTotalMemoryMiBRange> builder(MarshallingType.SDK_POJO).memberName("acceleratorTotalMemoryMiB")
            .getter(getter(CustomerManagedWorkerCapabilities::acceleratorTotalMemoryMiB))
            .setter(setter(Builder::acceleratorTotalMemoryMiB)).constructor(AcceleratorTotalMemoryMiBRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorTotalMemoryMiB").build())
            .build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(CustomerManagedWorkerCapabilities::osFamilyAsString))
            .setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final SdkField<String> CPU_ARCHITECTURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpuArchitectureType").getter(getter(CustomerManagedWorkerCapabilities::cpuArchitectureTypeAsString))
            .setter(setter(Builder::cpuArchitectureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitectureType").build())
            .build();

    private static final SdkField<List<FleetAmountCapability>> CUSTOM_AMOUNTS_FIELD = SdkField
            .<List<FleetAmountCapability>> builder(MarshallingType.LIST)
            .memberName("customAmounts")
            .getter(getter(CustomerManagedWorkerCapabilities::customAmounts))
            .setter(setter(Builder::customAmounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAmounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAmountCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAmountCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FleetAttributeCapability>> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<List<FleetAttributeCapability>> builder(MarshallingType.LIST)
            .memberName("customAttributes")
            .getter(getter(CustomerManagedWorkerCapabilities::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAttributeCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAttributeCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_COUNT_FIELD,
            MEMORY_MIB_FIELD, ACCELERATOR_TYPES_FIELD, ACCELERATOR_COUNT_FIELD, ACCELERATOR_TOTAL_MEMORY_MIB_FIELD,
            OS_FAMILY_FIELD, CPU_ARCHITECTURE_TYPE_FIELD, CUSTOM_AMOUNTS_FIELD, CUSTOM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VCpuCountRange vCpuCount;

    private final MemoryMiBRange memoryMiB;

    private final List<String> acceleratorTypes;

    private final AcceleratorCountRange acceleratorCount;

    private final AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB;

    private final String osFamily;

    private final String cpuArchitectureType;

    private final List<FleetAmountCapability> customAmounts;

    private final List<FleetAttributeCapability> customAttributes;

    private CustomerManagedWorkerCapabilities(BuilderImpl builder) {
        this.vCpuCount = builder.vCpuCount;
        this.memoryMiB = builder.memoryMiB;
        this.acceleratorTypes = builder.acceleratorTypes;
        this.acceleratorCount = builder.acceleratorCount;
        this.acceleratorTotalMemoryMiB = builder.acceleratorTotalMemoryMiB;
        this.osFamily = builder.osFamily;
        this.cpuArchitectureType = builder.cpuArchitectureType;
        this.customAmounts = builder.customAmounts;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * The vCPU count for the customer manged worker capabilities.
     * </p>
     * 
     * @return The vCPU count for the customer manged worker capabilities.
     */
    public final VCpuCountRange vCpuCount() {
        return vCpuCount;
    }

    /**
     * <p>
     * The memory (MiB).
     * </p>
     * 
     * @return The memory (MiB).
     */
    public final MemoryMiBRange memoryMiB() {
        return memoryMiB;
    }

    /**
     * <p>
     * The accelerator types for the customer managed worker capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return The accelerator types for the customer managed worker capabilities.
     */
    public final List<AcceleratorType> acceleratorTypes() {
        return AcceleratorTypesCopier.copyStringToEnum(acceleratorTypes);
    }

    /**
     * For responses, this returns true if the service returned a value for the AcceleratorTypes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAcceleratorTypes() {
        return acceleratorTypes != null && !(acceleratorTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The accelerator types for the customer managed worker capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAcceleratorTypes} method.
     * </p>
     * 
     * @return The accelerator types for the customer managed worker capabilities.
     */
    public final List<String> acceleratorTypesAsStrings() {
        return acceleratorTypes;
    }

    /**
     * <p>
     * The range of the accelerator.
     * </p>
     * 
     * @return The range of the accelerator.
     */
    public final AcceleratorCountRange acceleratorCount() {
        return acceleratorCount;
    }

    /**
     * <p>
     * The total memory (MiB) for the customer managed worker capabilities.
     * </p>
     * 
     * @return The total memory (MiB) for the customer managed worker capabilities.
     */
    public final AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB() {
        return acceleratorTotalMemoryMiB;
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link CustomerManagedFleetOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see CustomerManagedFleetOperatingSystemFamily
     */
    public final CustomerManagedFleetOperatingSystemFamily osFamily() {
        return CustomerManagedFleetOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link CustomerManagedFleetOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see CustomerManagedFleetOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    /**
     * <p>
     * The CPU architecture type for the customer managed worker capabilities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cpuArchitectureType} will return {@link CpuArchitectureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cpuArchitectureTypeAsString}.
     * </p>
     * 
     * @return The CPU architecture type for the customer managed worker capabilities.
     * @see CpuArchitectureType
     */
    public final CpuArchitectureType cpuArchitectureType() {
        return CpuArchitectureType.fromValue(cpuArchitectureType);
    }

    /**
     * <p>
     * The CPU architecture type for the customer managed worker capabilities.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cpuArchitectureType} will return {@link CpuArchitectureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cpuArchitectureTypeAsString}.
     * </p>
     * 
     * @return The CPU architecture type for the customer managed worker capabilities.
     * @see CpuArchitectureType
     */
    public final String cpuArchitectureTypeAsString() {
        return cpuArchitectureType;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAmounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAmounts() {
        return customAmounts != null && !(customAmounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom requirement ranges for customer managed worker capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAmounts} method.
     * </p>
     * 
     * @return Custom requirement ranges for customer managed worker capabilities.
     */
    public final List<FleetAmountCapability> customAmounts() {
        return customAmounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAttributes() {
        return customAttributes != null && !(customAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Custom attributes for the customer manged worker capabilities.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAttributes} method.
     * </p>
     * 
     * @return Custom attributes for the customer manged worker capabilities.
     */
    public final List<FleetAttributeCapability> customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorCount());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorTotalMemoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuArchitectureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAmounts() ? customAmounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAttributes() ? customAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CustomerManagedWorkerCapabilities)) {
            return false;
        }
        CustomerManagedWorkerCapabilities other = (CustomerManagedWorkerCapabilities) obj;
        return Objects.equals(vCpuCount(), other.vCpuCount()) && Objects.equals(memoryMiB(), other.memoryMiB())
                && hasAcceleratorTypes() == other.hasAcceleratorTypes()
                && Objects.equals(acceleratorTypesAsStrings(), other.acceleratorTypesAsStrings())
                && Objects.equals(acceleratorCount(), other.acceleratorCount())
                && Objects.equals(acceleratorTotalMemoryMiB(), other.acceleratorTotalMemoryMiB())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString())
                && Objects.equals(cpuArchitectureTypeAsString(), other.cpuArchitectureTypeAsString())
                && hasCustomAmounts() == other.hasCustomAmounts() && Objects.equals(customAmounts(), other.customAmounts())
                && hasCustomAttributes() == other.hasCustomAttributes()
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CustomerManagedWorkerCapabilities").add("VCpuCount", vCpuCount()).add("MemoryMiB", memoryMiB())
                .add("AcceleratorTypes", hasAcceleratorTypes() ? acceleratorTypesAsStrings() : null)
                .add("AcceleratorCount", acceleratorCount()).add("AcceleratorTotalMemoryMiB", acceleratorTotalMemoryMiB())
                .add("OsFamily", osFamilyAsString()).add("CpuArchitectureType", cpuArchitectureTypeAsString())
                .add("CustomAmounts", hasCustomAmounts() ? customAmounts() : null)
                .add("CustomAttributes", hasCustomAttributes() ? customAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCpuCount":
            return Optional.ofNullable(clazz.cast(vCpuCount()));
        case "memoryMiB":
            return Optional.ofNullable(clazz.cast(memoryMiB()));
        case "acceleratorTypes":
            return Optional.ofNullable(clazz.cast(acceleratorTypesAsStrings()));
        case "acceleratorCount":
            return Optional.ofNullable(clazz.cast(acceleratorCount()));
        case "acceleratorTotalMemoryMiB":
            return Optional.ofNullable(clazz.cast(acceleratorTotalMemoryMiB()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        case "cpuArchitectureType":
            return Optional.ofNullable(clazz.cast(cpuArchitectureTypeAsString()));
        case "customAmounts":
            return Optional.ofNullable(clazz.cast(customAmounts()));
        case "customAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vCpuCount", V_CPU_COUNT_FIELD);
        map.put("memoryMiB", MEMORY_MIB_FIELD);
        map.put("acceleratorTypes", ACCELERATOR_TYPES_FIELD);
        map.put("acceleratorCount", ACCELERATOR_COUNT_FIELD);
        map.put("acceleratorTotalMemoryMiB", ACCELERATOR_TOTAL_MEMORY_MIB_FIELD);
        map.put("osFamily", OS_FAMILY_FIELD);
        map.put("cpuArchitectureType", CPU_ARCHITECTURE_TYPE_FIELD);
        map.put("customAmounts", CUSTOM_AMOUNTS_FIELD);
        map.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CustomerManagedWorkerCapabilities, T> g) {
        return obj -> g.apply((CustomerManagedWorkerCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, CustomerManagedWorkerCapabilities> {
        /**
         * <p>
         * The vCPU count for the customer manged worker capabilities.
         * </p>
         * 
         * @param vCpuCount
         *        The vCPU count for the customer manged worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpuCount(VCpuCountRange vCpuCount);

        /**
         * <p>
         * The vCPU count for the customer manged worker capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link VCpuCountRange.Builder} avoiding the need
         * to create one manually via {@link VCpuCountRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VCpuCountRange.Builder#build()} is called immediately and its
         * result is passed to {@link #vCpuCount(VCpuCountRange)}.
         * 
         * @param vCpuCount
         *        a consumer that will call methods on {@link VCpuCountRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vCpuCount(VCpuCountRange)
         */
        default Builder vCpuCount(Consumer<VCpuCountRange.Builder> vCpuCount) {
            return vCpuCount(VCpuCountRange.builder().applyMutation(vCpuCount).build());
        }

        /**
         * <p>
         * The memory (MiB).
         * </p>
         * 
         * @param memoryMiB
         *        The memory (MiB).
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryMiB(MemoryMiBRange memoryMiB);

        /**
         * <p>
         * The memory (MiB).
         * </p>
         * This is a convenience method that creates an instance of the {@link MemoryMiBRange.Builder} avoiding the need
         * to create one manually via {@link MemoryMiBRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemoryMiBRange.Builder#build()} is called immediately and its
         * result is passed to {@link #memoryMiB(MemoryMiBRange)}.
         * 
         * @param memoryMiB
         *        a consumer that will call methods on {@link MemoryMiBRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryMiB(MemoryMiBRange)
         */
        default Builder memoryMiB(Consumer<MemoryMiBRange.Builder> memoryMiB) {
            return memoryMiB(MemoryMiBRange.builder().applyMutation(memoryMiB).build());
        }

        /**
         * <p>
         * The accelerator types for the customer managed worker capabilities.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types for the customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes);

        /**
         * <p>
         * The accelerator types for the customer managed worker capabilities.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types for the customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypesWithStrings(String... acceleratorTypes);

        /**
         * <p>
         * The accelerator types for the customer managed worker capabilities.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types for the customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes);

        /**
         * <p>
         * The accelerator types for the customer managed worker capabilities.
         * </p>
         * 
         * @param acceleratorTypes
         *        The accelerator types for the customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTypes(AcceleratorType... acceleratorTypes);

        /**
         * <p>
         * The range of the accelerator.
         * </p>
         * 
         * @param acceleratorCount
         *        The range of the accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorCount(AcceleratorCountRange acceleratorCount);

        /**
         * <p>
         * The range of the accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceleratorCountRange.Builder} avoiding
         * the need to create one manually via {@link AcceleratorCountRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceleratorCountRange.Builder#build()} is called immediately and
         * its result is passed to {@link #acceleratorCount(AcceleratorCountRange)}.
         * 
         * @param acceleratorCount
         *        a consumer that will call methods on {@link AcceleratorCountRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorCount(AcceleratorCountRange)
         */
        default Builder acceleratorCount(Consumer<AcceleratorCountRange.Builder> acceleratorCount) {
            return acceleratorCount(AcceleratorCountRange.builder().applyMutation(acceleratorCount).build());
        }

        /**
         * <p>
         * The total memory (MiB) for the customer managed worker capabilities.
         * </p>
         * 
         * @param acceleratorTotalMemoryMiB
         *        The total memory (MiB) for the customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB);

        /**
         * <p>
         * The total memory (MiB) for the customer managed worker capabilities.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceleratorTotalMemoryMiBRange.Builder}
         * avoiding the need to create one manually via {@link AcceleratorTotalMemoryMiBRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceleratorTotalMemoryMiBRange.Builder#build()} is called
         * immediately and its result is passed to {@link #acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange)}.
         * 
         * @param acceleratorTotalMemoryMiB
         *        a consumer that will call methods on {@link AcceleratorTotalMemoryMiBRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange)
         */
        default Builder acceleratorTotalMemoryMiB(Consumer<AcceleratorTotalMemoryMiBRange.Builder> acceleratorTotalMemoryMiB) {
            return acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange.builder().applyMutation(acceleratorTotalMemoryMiB)
                    .build());
        }

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see CustomerManagedFleetOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerManagedFleetOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see CustomerManagedFleetOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CustomerManagedFleetOperatingSystemFamily
         */
        Builder osFamily(CustomerManagedFleetOperatingSystemFamily osFamily);

        /**
         * <p>
         * The CPU architecture type for the customer managed worker capabilities.
         * </p>
         * 
         * @param cpuArchitectureType
         *        The CPU architecture type for the customer managed worker capabilities.
         * @see CpuArchitectureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuArchitectureType
         */
        Builder cpuArchitectureType(String cpuArchitectureType);

        /**
         * <p>
         * The CPU architecture type for the customer managed worker capabilities.
         * </p>
         * 
         * @param cpuArchitectureType
         *        The CPU architecture type for the customer managed worker capabilities.
         * @see CpuArchitectureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuArchitectureType
         */
        Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType);

        /**
         * <p>
         * Custom requirement ranges for customer managed worker capabilities.
         * </p>
         * 
         * @param customAmounts
         *        Custom requirement ranges for customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmounts(Collection<FleetAmountCapability> customAmounts);

        /**
         * <p>
         * Custom requirement ranges for customer managed worker capabilities.
         * </p>
         * 
         * @param customAmounts
         *        Custom requirement ranges for customer managed worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmounts(FleetAmountCapability... customAmounts);

        /**
         * <p>
         * Custom requirement ranges for customer managed worker capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #customAmounts(List<FleetAmountCapability>)}.
         * 
         * @param customAmounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAmounts(java.util.Collection<FleetAmountCapability>)
         */
        Builder customAmounts(Consumer<FleetAmountCapability.Builder>... customAmounts);

        /**
         * <p>
         * Custom attributes for the customer manged worker capabilities.
         * </p>
         * 
         * @param customAttributes
         *        Custom attributes for the customer manged worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Collection<FleetAttributeCapability> customAttributes);

        /**
         * <p>
         * Custom attributes for the customer manged worker capabilities.
         * </p>
         * 
         * @param customAttributes
         *        Custom attributes for the customer manged worker capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(FleetAttributeCapability... customAttributes);

        /**
         * <p>
         * Custom attributes for the customer manged worker capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #customAttributes(List<FleetAttributeCapability>)}.
         * 
         * @param customAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAttributes(java.util.Collection<FleetAttributeCapability>)
         */
        Builder customAttributes(Consumer<FleetAttributeCapability.Builder>... customAttributes);
    }

    static final class BuilderImpl implements Builder {
        private VCpuCountRange vCpuCount;

        private MemoryMiBRange memoryMiB;

        private List<String> acceleratorTypes = DefaultSdkAutoConstructList.getInstance();

        private AcceleratorCountRange acceleratorCount;

        private AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB;

        private String osFamily;

        private String cpuArchitectureType;

        private List<FleetAmountCapability> customAmounts = DefaultSdkAutoConstructList.getInstance();

        private List<FleetAttributeCapability> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(CustomerManagedWorkerCapabilities model) {
            vCpuCount(model.vCpuCount);
            memoryMiB(model.memoryMiB);
            acceleratorTypesWithStrings(model.acceleratorTypes);
            acceleratorCount(model.acceleratorCount);
            acceleratorTotalMemoryMiB(model.acceleratorTotalMemoryMiB);
            osFamily(model.osFamily);
            cpuArchitectureType(model.cpuArchitectureType);
            customAmounts(model.customAmounts);
            customAttributes(model.customAttributes);
        }

        public final VCpuCountRange.Builder getVCpuCount() {
            return vCpuCount != null ? vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(VCpuCountRange.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(VCpuCountRange vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public final MemoryMiBRange.Builder getMemoryMiB() {
            return memoryMiB != null ? memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(MemoryMiBRange.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(MemoryMiBRange memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final Collection<String> getAcceleratorTypes() {
            if (acceleratorTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return acceleratorTypes;
        }

        public final void setAcceleratorTypes(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copy(acceleratorTypes);
        }

        @Override
        public final Builder acceleratorTypesWithStrings(Collection<String> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copy(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypesWithStrings(String... acceleratorTypes) {
            acceleratorTypesWithStrings(Arrays.asList(acceleratorTypes));
            return this;
        }

        @Override
        public final Builder acceleratorTypes(Collection<AcceleratorType> acceleratorTypes) {
            this.acceleratorTypes = AcceleratorTypesCopier.copyEnumToString(acceleratorTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder acceleratorTypes(AcceleratorType... acceleratorTypes) {
            acceleratorTypes(Arrays.asList(acceleratorTypes));
            return this;
        }

        public final AcceleratorCountRange.Builder getAcceleratorCount() {
            return acceleratorCount != null ? acceleratorCount.toBuilder() : null;
        }

        public final void setAcceleratorCount(AcceleratorCountRange.BuilderImpl acceleratorCount) {
            this.acceleratorCount = acceleratorCount != null ? acceleratorCount.build() : null;
        }

        @Override
        public final Builder acceleratorCount(AcceleratorCountRange acceleratorCount) {
            this.acceleratorCount = acceleratorCount;
            return this;
        }

        public final AcceleratorTotalMemoryMiBRange.Builder getAcceleratorTotalMemoryMiB() {
            return acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.toBuilder() : null;
        }

        public final void setAcceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange.BuilderImpl acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB != null ? acceleratorTotalMemoryMiB.build() : null;
        }

        @Override
        public final Builder acceleratorTotalMemoryMiB(AcceleratorTotalMemoryMiBRange acceleratorTotalMemoryMiB) {
            this.acceleratorTotalMemoryMiB = acceleratorTotalMemoryMiB;
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(CustomerManagedFleetOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final String getCpuArchitectureType() {
            return cpuArchitectureType;
        }

        public final void setCpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
        }

        @Override
        public final Builder cpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
            return this;
        }

        @Override
        public final Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
            this.cpuArchitectureType(cpuArchitectureType == null ? null : cpuArchitectureType.toString());
            return this;
        }

        public final List<FleetAmountCapability.Builder> getCustomAmounts() {
            List<FleetAmountCapability.Builder> result = CustomFleetAmountCapabilitiesCopier.copyToBuilder(this.customAmounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAmounts(Collection<FleetAmountCapability.BuilderImpl> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copyFromBuilder(customAmounts);
        }

        @Override
        public final Builder customAmounts(Collection<FleetAmountCapability> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copy(customAmounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(FleetAmountCapability... customAmounts) {
            customAmounts(Arrays.asList(customAmounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(Consumer<FleetAmountCapability.Builder>... customAmounts) {
            customAmounts(Stream.of(customAmounts).map(c -> FleetAmountCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getCustomAttributes() {
            List<FleetAttributeCapability.Builder> result = CustomFleetAttributeCapabilitiesCopier
                    .copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<FleetAttributeCapability.BuilderImpl> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<FleetAttributeCapability> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(FleetAttributeCapability... customAttributes) {
            customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<FleetAttributeCapability.Builder>... customAttributes) {
            customAttributes(Stream.of(customAttributes).map(c -> FleetAttributeCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public CustomerManagedWorkerCapabilities build() {
            return new CustomerManagedWorkerCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
