/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class DeleteMonitorRequest extends DeadlineRequest implements
        ToCopyableBuilder<DeleteMonitorRequest.Builder, DeleteMonitorRequest> {
    private static final SdkField<String> MONITOR_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("monitorId").getter(getter(DeleteMonitorRequest::monitorId)).setter(setter(Builder::monitorId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("monitorId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MONITOR_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String monitorId;

    private DeleteMonitorRequest(BuilderImpl builder) {
        super(builder);
        this.monitorId = builder.monitorId;
    }

    /**
     * <p>
     * The unique identifier of the monitor to delete. This ID is returned by the <code>CreateMonitor</code> operation,
     * and is included in the response to the <code>GetMonitor</code> operation.
     * </p>
     * 
     * @return The unique identifier of the monitor to delete. This ID is returned by the <code>CreateMonitor</code>
     *         operation, and is included in the response to the <code>GetMonitor</code> operation.
     */
    public final String monitorId() {
        return monitorId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(monitorId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DeleteMonitorRequest)) {
            return false;
        }
        DeleteMonitorRequest other = (DeleteMonitorRequest) obj;
        return Objects.equals(monitorId(), other.monitorId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DeleteMonitorRequest").add("MonitorId", monitorId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "monitorId":
            return Optional.ofNullable(clazz.cast(monitorId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("monitorId", MONITOR_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DeleteMonitorRequest, T> g) {
        return obj -> g.apply((DeleteMonitorRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, DeleteMonitorRequest> {
        /**
         * <p>
         * The unique identifier of the monitor to delete. This ID is returned by the <code>CreateMonitor</code>
         * operation, and is included in the response to the <code>GetMonitor</code> operation.
         * </p>
         * 
         * @param monitorId
         *        The unique identifier of the monitor to delete. This ID is returned by the <code>CreateMonitor</code>
         *        operation, and is included in the response to the <code>GetMonitor</code> operation.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder monitorId(String monitorId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String monitorId;

        private BuilderImpl() {
        }

        private BuilderImpl(DeleteMonitorRequest model) {
            super(model);
            monitorId(model.monitorId);
        }

        public final String getMonitorId() {
            return monitorId;
        }

        public final void setMonitorId(String monitorId) {
            this.monitorId = monitorId;
        }

        @Override
        public final Builder monitorId(String monitorId) {
            this.monitorId = monitorId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public DeleteMonitorRequest build() {
            return new DeleteMonitorRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
