/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The number of dependencies for the consumer.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class DependencyCounts implements SdkPojo, Serializable,
        ToCopyableBuilder<DependencyCounts.Builder, DependencyCounts> {
    private static final SdkField<Integer> DEPENDENCIES_RESOLVED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dependenciesResolved").getter(getter(DependencyCounts::dependenciesResolved))
            .setter(setter(Builder::dependenciesResolved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependenciesResolved").build())
            .build();

    private static final SdkField<Integer> DEPENDENCIES_UNRESOLVED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("dependenciesUnresolved").getter(getter(DependencyCounts::dependenciesUnresolved))
            .setter(setter(Builder::dependenciesUnresolved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependenciesUnresolved").build())
            .build();

    private static final SdkField<Integer> CONSUMERS_RESOLVED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("consumersResolved").getter(getter(DependencyCounts::consumersResolved))
            .setter(setter(Builder::consumersResolved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumersResolved").build()).build();

    private static final SdkField<Integer> CONSUMERS_UNRESOLVED_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("consumersUnresolved").getter(getter(DependencyCounts::consumersUnresolved))
            .setter(setter(Builder::consumersUnresolved))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("consumersUnresolved").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(DEPENDENCIES_RESOLVED_FIELD,
            DEPENDENCIES_UNRESOLVED_FIELD, CONSUMERS_RESOLVED_FIELD, CONSUMERS_UNRESOLVED_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Integer dependenciesResolved;

    private final Integer dependenciesUnresolved;

    private final Integer consumersResolved;

    private final Integer consumersUnresolved;

    private DependencyCounts(BuilderImpl builder) {
        this.dependenciesResolved = builder.dependenciesResolved;
        this.dependenciesUnresolved = builder.dependenciesUnresolved;
        this.consumersResolved = builder.consumersResolved;
        this.consumersUnresolved = builder.consumersUnresolved;
    }

    /**
     * <p>
     * The number of resolved dependencies.
     * </p>
     * 
     * @return The number of resolved dependencies.
     */
    public final Integer dependenciesResolved() {
        return dependenciesResolved;
    }

    /**
     * <p>
     * The number of unresolved dependencies.
     * </p>
     * 
     * @return The number of unresolved dependencies.
     */
    public final Integer dependenciesUnresolved() {
        return dependenciesUnresolved;
    }

    /**
     * <p>
     * The number of consumers resolved.
     * </p>
     * 
     * @return The number of consumers resolved.
     */
    public final Integer consumersResolved() {
        return consumersResolved;
    }

    /**
     * <p>
     * The number of unresolved consumers.
     * </p>
     * 
     * @return The number of unresolved consumers.
     */
    public final Integer consumersUnresolved() {
        return consumersUnresolved;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(dependenciesResolved());
        hashCode = 31 * hashCode + Objects.hashCode(dependenciesUnresolved());
        hashCode = 31 * hashCode + Objects.hashCode(consumersResolved());
        hashCode = 31 * hashCode + Objects.hashCode(consumersUnresolved());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DependencyCounts)) {
            return false;
        }
        DependencyCounts other = (DependencyCounts) obj;
        return Objects.equals(dependenciesResolved(), other.dependenciesResolved())
                && Objects.equals(dependenciesUnresolved(), other.dependenciesUnresolved())
                && Objects.equals(consumersResolved(), other.consumersResolved())
                && Objects.equals(consumersUnresolved(), other.consumersUnresolved());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("DependencyCounts").add("DependenciesResolved", dependenciesResolved())
                .add("DependenciesUnresolved", dependenciesUnresolved()).add("ConsumersResolved", consumersResolved())
                .add("ConsumersUnresolved", consumersUnresolved()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "dependenciesResolved":
            return Optional.ofNullable(clazz.cast(dependenciesResolved()));
        case "dependenciesUnresolved":
            return Optional.ofNullable(clazz.cast(dependenciesUnresolved()));
        case "consumersResolved":
            return Optional.ofNullable(clazz.cast(consumersResolved()));
        case "consumersUnresolved":
            return Optional.ofNullable(clazz.cast(consumersUnresolved()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("dependenciesResolved", DEPENDENCIES_RESOLVED_FIELD);
        map.put("dependenciesUnresolved", DEPENDENCIES_UNRESOLVED_FIELD);
        map.put("consumersResolved", CONSUMERS_RESOLVED_FIELD);
        map.put("consumersUnresolved", CONSUMERS_UNRESOLVED_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DependencyCounts, T> g) {
        return obj -> g.apply((DependencyCounts) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, DependencyCounts> {
        /**
         * <p>
         * The number of resolved dependencies.
         * </p>
         * 
         * @param dependenciesResolved
         *        The number of resolved dependencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependenciesResolved(Integer dependenciesResolved);

        /**
         * <p>
         * The number of unresolved dependencies.
         * </p>
         * 
         * @param dependenciesUnresolved
         *        The number of unresolved dependencies.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependenciesUnresolved(Integer dependenciesUnresolved);

        /**
         * <p>
         * The number of consumers resolved.
         * </p>
         * 
         * @param consumersResolved
         *        The number of consumers resolved.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumersResolved(Integer consumersResolved);

        /**
         * <p>
         * The number of unresolved consumers.
         * </p>
         * 
         * @param consumersUnresolved
         *        The number of unresolved consumers.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder consumersUnresolved(Integer consumersUnresolved);
    }

    static final class BuilderImpl implements Builder {
        private Integer dependenciesResolved;

        private Integer dependenciesUnresolved;

        private Integer consumersResolved;

        private Integer consumersUnresolved;

        private BuilderImpl() {
        }

        private BuilderImpl(DependencyCounts model) {
            dependenciesResolved(model.dependenciesResolved);
            dependenciesUnresolved(model.dependenciesUnresolved);
            consumersResolved(model.consumersResolved);
            consumersUnresolved(model.consumersUnresolved);
        }

        public final Integer getDependenciesResolved() {
            return dependenciesResolved;
        }

        public final void setDependenciesResolved(Integer dependenciesResolved) {
            this.dependenciesResolved = dependenciesResolved;
        }

        @Override
        public final Builder dependenciesResolved(Integer dependenciesResolved) {
            this.dependenciesResolved = dependenciesResolved;
            return this;
        }

        public final Integer getDependenciesUnresolved() {
            return dependenciesUnresolved;
        }

        public final void setDependenciesUnresolved(Integer dependenciesUnresolved) {
            this.dependenciesUnresolved = dependenciesUnresolved;
        }

        @Override
        public final Builder dependenciesUnresolved(Integer dependenciesUnresolved) {
            this.dependenciesUnresolved = dependenciesUnresolved;
            return this;
        }

        public final Integer getConsumersResolved() {
            return consumersResolved;
        }

        public final void setConsumersResolved(Integer consumersResolved) {
            this.consumersResolved = consumersResolved;
        }

        @Override
        public final Builder consumersResolved(Integer consumersResolved) {
            this.consumersResolved = consumersResolved;
            return this;
        }

        public final Integer getConsumersUnresolved() {
            return consumersUnresolved;
        }

        public final void setConsumersUnresolved(Integer consumersUnresolved) {
            this.consumersUnresolved = consumersUnresolved;
        }

        @Override
        public final Builder consumersUnresolved(Integer consumersUnresolved) {
            this.consumersUnresolved = consumersUnresolved;
            return this;
        }

        @Override
        public DependencyCounts build() {
            return new DependencyCounts(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
