/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The amounts and attributes of fleets.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetCapabilities.Builder, FleetCapabilities> {
    private static final SdkField<List<FleetAmountCapability>> AMOUNTS_FIELD = SdkField
            .<List<FleetAmountCapability>> builder(MarshallingType.LIST)
            .memberName("amounts")
            .getter(getter(FleetCapabilities::amounts))
            .setter(setter(Builder::amounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAmountCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAmountCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FleetAttributeCapability>> ATTRIBUTES_FIELD = SdkField
            .<List<FleetAttributeCapability>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(FleetCapabilities::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAttributeCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAttributeCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(AMOUNTS_FIELD,
            ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<FleetAmountCapability> amounts;

    private final List<FleetAttributeCapability> attributes;

    private FleetCapabilities(BuilderImpl builder) {
        this.amounts = builder.amounts;
        this.attributes = builder.attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmounts() {
        return amounts != null && !(amounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Amount capabilities of the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmounts} method.
     * </p>
     * 
     * @return Amount capabilities of the fleet.
     */
    public final List<FleetAmountCapability> amounts() {
        return amounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Attribute capabilities of the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return Attribute capabilities of the fleet.
     */
    public final List<FleetAttributeCapability> attributes() {
        return attributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAmounts() ? amounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetCapabilities)) {
            return false;
        }
        FleetCapabilities other = (FleetCapabilities) obj;
        return hasAmounts() == other.hasAmounts() && Objects.equals(amounts(), other.amounts())
                && hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetCapabilities").add("Amounts", hasAmounts() ? amounts() : null)
                .add("Attributes", hasAttributes() ? attributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "amounts":
            return Optional.ofNullable(clazz.cast(amounts()));
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("amounts", AMOUNTS_FIELD);
        map.put("attributes", ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetCapabilities, T> g) {
        return obj -> g.apply((FleetCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetCapabilities> {
        /**
         * <p>
         * Amount capabilities of the fleet.
         * </p>
         * 
         * @param amounts
         *        Amount capabilities of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(Collection<FleetAmountCapability> amounts);

        /**
         * <p>
         * Amount capabilities of the fleet.
         * </p>
         * 
         * @param amounts
         *        Amount capabilities of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(FleetAmountCapability... amounts);

        /**
         * <p>
         * Amount capabilities of the fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #amounts(List<FleetAmountCapability>)}.
         * 
         * @param amounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amounts(java.util.Collection<FleetAmountCapability>)
         */
        Builder amounts(Consumer<FleetAmountCapability.Builder>... amounts);

        /**
         * <p>
         * Attribute capabilities of the fleet.
         * </p>
         * 
         * @param attributes
         *        Attribute capabilities of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<FleetAttributeCapability> attributes);

        /**
         * <p>
         * Attribute capabilities of the fleet.
         * </p>
         * 
         * @param attributes
         *        Attribute capabilities of the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(FleetAttributeCapability... attributes);

        /**
         * <p>
         * Attribute capabilities of the fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<FleetAttributeCapability>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<FleetAttributeCapability>)
         */
        Builder attributes(Consumer<FleetAttributeCapability.Builder>... attributes);
    }

    static final class BuilderImpl implements Builder {
        private List<FleetAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();

        private List<FleetAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(FleetCapabilities model) {
            amounts(model.amounts);
            attributes(model.attributes);
        }

        public final List<FleetAmountCapability.Builder> getAmounts() {
            List<FleetAmountCapability.Builder> result = FleetAmountCapabilitiesCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<FleetAmountCapability.BuilderImpl> amounts) {
            this.amounts = FleetAmountCapabilitiesCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<FleetAmountCapability> amounts) {
            this.amounts = FleetAmountCapabilitiesCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(FleetAmountCapability... amounts) {
            amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<FleetAmountCapability.Builder>... amounts) {
            amounts(Stream.of(amounts).map(c -> FleetAmountCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getAttributes() {
            List<FleetAttributeCapability.Builder> result = FleetAttributeCapabilitiesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<FleetAttributeCapability.BuilderImpl> attributes) {
            this.attributes = FleetAttributeCapabilitiesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<FleetAttributeCapability> attributes) {
            this.attributes = FleetAttributeCapabilitiesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(FleetAttributeCapability... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<FleetAttributeCapability.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> FleetAttributeCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public FleetCapabilities build() {
            return new FleetCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
