/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Fleet configuration details.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class FleetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<FleetConfiguration.Builder, FleetConfiguration> {
    private static final SdkField<CustomerManagedFleetConfiguration> CUSTOMER_MANAGED_FIELD = SdkField
            .<CustomerManagedFleetConfiguration> builder(MarshallingType.SDK_POJO).memberName("customerManaged")
            .getter(getter(FleetConfiguration::customerManaged)).setter(setter(Builder::customerManaged))
            .constructor(CustomerManagedFleetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customerManaged").build()).build();

    private static final SdkField<ServiceManagedEc2FleetConfiguration> SERVICE_MANAGED_EC2_FIELD = SdkField
            .<ServiceManagedEc2FleetConfiguration> builder(MarshallingType.SDK_POJO).memberName("serviceManagedEc2")
            .getter(getter(FleetConfiguration::serviceManagedEc2)).setter(setter(Builder::serviceManagedEc2))
            .constructor(ServiceManagedEc2FleetConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("serviceManagedEc2").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CUSTOMER_MANAGED_FIELD,
            SERVICE_MANAGED_EC2_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final CustomerManagedFleetConfiguration customerManaged;

    private final ServiceManagedEc2FleetConfiguration serviceManagedEc2;

    private final Type type;

    private FleetConfiguration(BuilderImpl builder) {
        this.customerManaged = builder.customerManaged;
        this.serviceManagedEc2 = builder.serviceManagedEc2;
        this.type = builder.type;
    }

    /**
     * <p>
     * The customer managed fleets within a fleet configuration.
     * </p>
     * 
     * @return The customer managed fleets within a fleet configuration.
     */
    public final CustomerManagedFleetConfiguration customerManaged() {
        return customerManaged;
    }

    /**
     * <p>
     * The service managed Amazon EC2 instances for a fleet configuration.
     * </p>
     * 
     * @return The service managed Amazon EC2 instances for a fleet configuration.
     */
    public final ServiceManagedEc2FleetConfiguration serviceManagedEc2() {
        return serviceManagedEc2;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(customerManaged());
        hashCode = 31 * hashCode + Objects.hashCode(serviceManagedEc2());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof FleetConfiguration)) {
            return false;
        }
        FleetConfiguration other = (FleetConfiguration) obj;
        return Objects.equals(customerManaged(), other.customerManaged())
                && Objects.equals(serviceManagedEc2(), other.serviceManagedEc2());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("FleetConfiguration").add("CustomerManaged", customerManaged())
                .add("ServiceManagedEc2", serviceManagedEc2()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "customerManaged":
            return Optional.ofNullable(clazz.cast(customerManaged()));
        case "serviceManagedEc2":
            return Optional.ofNullable(clazz.cast(serviceManagedEc2()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #customerManaged()} initialized to the given value.
     *
     * <p>
     * The customer managed fleets within a fleet configuration.
     * </p>
     * 
     * @param customerManaged
     *        The customer managed fleets within a fleet configuration.
     */
    public static FleetConfiguration fromCustomerManaged(CustomerManagedFleetConfiguration customerManaged) {
        return builder().customerManaged(customerManaged).build();
    }

    /**
     * Create an instance of this class with {@link #customerManaged()} initialized to the given value.
     *
     * <p>
     * The customer managed fleets within a fleet configuration.
     * </p>
     * 
     * @param customerManaged
     *        The customer managed fleets within a fleet configuration.
     */
    public static FleetConfiguration fromCustomerManaged(Consumer<CustomerManagedFleetConfiguration.Builder> customerManaged) {
        CustomerManagedFleetConfiguration.Builder builder = CustomerManagedFleetConfiguration.builder();
        customerManaged.accept(builder);
        return fromCustomerManaged(builder.build());
    }

    /**
     * Create an instance of this class with {@link #serviceManagedEc2()} initialized to the given value.
     *
     * <p>
     * The service managed Amazon EC2 instances for a fleet configuration.
     * </p>
     * 
     * @param serviceManagedEc2
     *        The service managed Amazon EC2 instances for a fleet configuration.
     */
    public static FleetConfiguration fromServiceManagedEc2(ServiceManagedEc2FleetConfiguration serviceManagedEc2) {
        return builder().serviceManagedEc2(serviceManagedEc2).build();
    }

    /**
     * Create an instance of this class with {@link #serviceManagedEc2()} initialized to the given value.
     *
     * <p>
     * The service managed Amazon EC2 instances for a fleet configuration.
     * </p>
     * 
     * @param serviceManagedEc2
     *        The service managed Amazon EC2 instances for a fleet configuration.
     */
    public static FleetConfiguration fromServiceManagedEc2(Consumer<ServiceManagedEc2FleetConfiguration.Builder> serviceManagedEc2) {
        ServiceManagedEc2FleetConfiguration.Builder builder = ServiceManagedEc2FleetConfiguration.builder();
        serviceManagedEc2.accept(builder);
        return fromServiceManagedEc2(builder.build());
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("customerManaged", CUSTOMER_MANAGED_FIELD);
        map.put("serviceManagedEc2", SERVICE_MANAGED_EC2_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<FleetConfiguration, T> g) {
        return obj -> g.apply((FleetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, FleetConfiguration> {
        /**
         * <p>
         * The customer managed fleets within a fleet configuration.
         * </p>
         * 
         * @param customerManaged
         *        The customer managed fleets within a fleet configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customerManaged(CustomerManagedFleetConfiguration customerManaged);

        /**
         * <p>
         * The customer managed fleets within a fleet configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link CustomerManagedFleetConfiguration.Builder} avoiding the need to create one manually via
         * {@link CustomerManagedFleetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link CustomerManagedFleetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #customerManaged(CustomerManagedFleetConfiguration)}.
         * 
         * @param customerManaged
         *        a consumer that will call methods on {@link CustomerManagedFleetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customerManaged(CustomerManagedFleetConfiguration)
         */
        default Builder customerManaged(Consumer<CustomerManagedFleetConfiguration.Builder> customerManaged) {
            return customerManaged(CustomerManagedFleetConfiguration.builder().applyMutation(customerManaged).build());
        }

        /**
         * <p>
         * The service managed Amazon EC2 instances for a fleet configuration.
         * </p>
         * 
         * @param serviceManagedEc2
         *        The service managed Amazon EC2 instances for a fleet configuration.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder serviceManagedEc2(ServiceManagedEc2FleetConfiguration serviceManagedEc2);

        /**
         * <p>
         * The service managed Amazon EC2 instances for a fleet configuration.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceManagedEc2FleetConfiguration.Builder} avoiding the need to create one manually via
         * {@link ServiceManagedEc2FleetConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedEc2FleetConfiguration.Builder#build()} is called
         * immediately and its result is passed to {@link #serviceManagedEc2(ServiceManagedEc2FleetConfiguration)}.
         * 
         * @param serviceManagedEc2
         *        a consumer that will call methods on {@link ServiceManagedEc2FleetConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #serviceManagedEc2(ServiceManagedEc2FleetConfiguration)
         */
        default Builder serviceManagedEc2(Consumer<ServiceManagedEc2FleetConfiguration.Builder> serviceManagedEc2) {
            return serviceManagedEc2(ServiceManagedEc2FleetConfiguration.builder().applyMutation(serviceManagedEc2).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private CustomerManagedFleetConfiguration customerManaged;

        private ServiceManagedEc2FleetConfiguration serviceManagedEc2;

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(FleetConfiguration model) {
            customerManaged(model.customerManaged);
            serviceManagedEc2(model.serviceManagedEc2);
        }

        public final CustomerManagedFleetConfiguration.Builder getCustomerManaged() {
            return customerManaged != null ? customerManaged.toBuilder() : null;
        }

        public final void setCustomerManaged(CustomerManagedFleetConfiguration.BuilderImpl customerManaged) {
            Object oldValue = this.customerManaged;
            this.customerManaged = customerManaged != null ? customerManaged.build() : null;
            handleUnionValueChange(Type.CUSTOMER_MANAGED, oldValue, this.customerManaged);
        }

        @Override
        public final Builder customerManaged(CustomerManagedFleetConfiguration customerManaged) {
            Object oldValue = this.customerManaged;
            this.customerManaged = customerManaged;
            handleUnionValueChange(Type.CUSTOMER_MANAGED, oldValue, this.customerManaged);
            return this;
        }

        public final ServiceManagedEc2FleetConfiguration.Builder getServiceManagedEc2() {
            return serviceManagedEc2 != null ? serviceManagedEc2.toBuilder() : null;
        }

        public final void setServiceManagedEc2(ServiceManagedEc2FleetConfiguration.BuilderImpl serviceManagedEc2) {
            Object oldValue = this.serviceManagedEc2;
            this.serviceManagedEc2 = serviceManagedEc2 != null ? serviceManagedEc2.build() : null;
            handleUnionValueChange(Type.SERVICE_MANAGED_EC2, oldValue, this.serviceManagedEc2);
        }

        @Override
        public final Builder serviceManagedEc2(ServiceManagedEc2FleetConfiguration serviceManagedEc2) {
            Object oldValue = this.serviceManagedEc2;
            this.serviceManagedEc2 = serviceManagedEc2;
            handleUnionValueChange(Type.SERVICE_MANAGED_EC2, oldValue, this.serviceManagedEc2);
            return this;
        }

        @Override
        public FleetConfiguration build() {
            return new FleetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see FleetConfiguration#type()
     */
    public enum Type {
        CUSTOMER_MANAGED,

        SERVICE_MANAGED_EC2,

        UNKNOWN_TO_SDK_VERSION
    }
}
