/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetLicenseEndpointRequest extends DeadlineRequest implements
        ToCopyableBuilder<GetLicenseEndpointRequest.Builder, GetLicenseEndpointRequest> {
    private static final SdkField<String> LICENSE_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseEndpointId").getter(getter(GetLicenseEndpointRequest::licenseEndpointId))
            .setter(setter(Builder::licenseEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("licenseEndpointId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ENDPOINT_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String licenseEndpointId;

    private GetLicenseEndpointRequest(BuilderImpl builder) {
        super(builder);
        this.licenseEndpointId = builder.licenseEndpointId;
    }

    /**
     * <p>
     * The license endpoint ID.
     * </p>
     * 
     * @return The license endpoint ID.
     */
    public final String licenseEndpointId() {
        return licenseEndpointId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(licenseEndpointId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetLicenseEndpointRequest)) {
            return false;
        }
        GetLicenseEndpointRequest other = (GetLicenseEndpointRequest) obj;
        return Objects.equals(licenseEndpointId(), other.licenseEndpointId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetLicenseEndpointRequest").add("LicenseEndpointId", licenseEndpointId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "licenseEndpointId":
            return Optional.ofNullable(clazz.cast(licenseEndpointId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("licenseEndpointId", LICENSE_ENDPOINT_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetLicenseEndpointRequest, T> g) {
        return obj -> g.apply((GetLicenseEndpointRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, GetLicenseEndpointRequest> {
        /**
         * <p>
         * The license endpoint ID.
         * </p>
         * 
         * @param licenseEndpointId
         *        The license endpoint ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseEndpointId(String licenseEndpointId);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String licenseEndpointId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetLicenseEndpointRequest model) {
            super(model);
            licenseEndpointId(model.licenseEndpointId);
        }

        public final String getLicenseEndpointId() {
            return licenseEndpointId;
        }

        public final void setLicenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
        }

        @Override
        public final Builder licenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetLicenseEndpointRequest build() {
            return new GetLicenseEndpointRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
