/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class GetSessionResponse extends DeadlineResponse implements
        ToCopyableBuilder<GetSessionResponse.Builder, GetSessionResponse> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(GetSessionResponse::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(GetSessionResponse::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerId").getter(getter(GetSessionResponse::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerId").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(GetSessionResponse::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<LogConfiguration> LOG_FIELD = SdkField.<LogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("log").getter(getter(GetSessionResponse::log)).setter(setter(Builder::log))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(GetSessionResponse::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(GetSessionResponse::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(GetSessionResponse::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(GetSessionResponse::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetLifecycleStatus").getter(getter(GetSessionResponse::targetLifecycleStatusAsString))
            .setter(setter(Builder::targetLifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build())
            .build();

    private static final SdkField<HostPropertiesResponse> HOST_PROPERTIES_FIELD = SdkField
            .<HostPropertiesResponse> builder(MarshallingType.SDK_POJO).memberName("hostProperties")
            .getter(getter(GetSessionResponse::hostProperties)).setter(setter(Builder::hostProperties))
            .constructor(HostPropertiesResponse::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()).build();

    private static final SdkField<LogConfiguration> WORKER_LOG_FIELD = SdkField
            .<LogConfiguration> builder(MarshallingType.SDK_POJO).memberName("workerLog")
            .getter(getter(GetSessionResponse::workerLog)).setter(setter(Builder::workerLog))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerLog").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSION_ID_FIELD,
            FLEET_ID_FIELD, WORKER_ID_FIELD, STARTED_AT_FIELD, LOG_FIELD, LIFECYCLE_STATUS_FIELD, ENDED_AT_FIELD,
            UPDATED_AT_FIELD, UPDATED_BY_FIELD, TARGET_LIFECYCLE_STATUS_FIELD, HOST_PROPERTIES_FIELD, WORKER_LOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String sessionId;

    private final String fleetId;

    private final String workerId;

    private final Instant startedAt;

    private final LogConfiguration log;

    private final String lifecycleStatus;

    private final Instant endedAt;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String targetLifecycleStatus;

    private final HostPropertiesResponse hostProperties;

    private final LogConfiguration workerLog;

    private GetSessionResponse(BuilderImpl builder) {
        super(builder);
        this.sessionId = builder.sessionId;
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.startedAt = builder.startedAt;
        this.log = builder.log;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.endedAt = builder.endedAt;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
        this.hostProperties = builder.hostProperties;
        this.workerLog = builder.workerLog;
    }

    /**
     * <p>
     * The session ID.
     * </p>
     * 
     * @return The session ID.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The fleet ID for the session.
     * </p>
     * 
     * @return The fleet ID for the session.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The worker ID for the session.
     * </p>
     * 
     * @return The worker ID for the session.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The session log.
     * </p>
     * 
     * @return The session log.
     */
    public final LogConfiguration log() {
        return log;
    }

    /**
     * <p>
     * The life cycle status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link SessionLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status of the session.
     * @see SessionLifecycleStatus
     */
    public final SessionLifecycleStatus lifecycleStatus() {
        return SessionLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status of the session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link SessionLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status of the session.
     * @see SessionLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The life cycle status with which the session started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status with which the session started.
     * @see SessionLifecycleTargetStatus
     */
    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(targetLifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status with which the session started.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status with which the session started.
     * @see SessionLifecycleTargetStatus
     */
    public final String targetLifecycleStatusAsString() {
        return targetLifecycleStatus;
    }

    /**
     * <p>
     * Provides the Amazon EC2 properties of the host.
     * </p>
     * 
     * @return Provides the Amazon EC2 properties of the host.
     */
    public final HostPropertiesResponse hostProperties() {
        return hostProperties;
    }

    /**
     * <p>
     * The worker log for the session.
     * </p>
     * 
     * @return The worker log for the session.
     */
    public final LogConfiguration workerLog() {
        return workerLog;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(log());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(targetLifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(workerLog());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionResponse)) {
            return false;
        }
        GetSessionResponse other = (GetSessionResponse) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(workerId(), other.workerId()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(log(), other.log())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString())
                && Objects.equals(hostProperties(), other.hostProperties()) && Objects.equals(workerLog(), other.workerLog());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("GetSessionResponse").add("SessionId", sessionId()).add("FleetId", fleetId())
                .add("WorkerId", workerId()).add("StartedAt", startedAt()).add("Log", log())
                .add("LifecycleStatus", lifecycleStatusAsString()).add("EndedAt", endedAt()).add("UpdatedAt", updatedAt())
                .add("UpdatedBy", updatedBy()).add("TargetLifecycleStatus", targetLifecycleStatusAsString())
                .add("HostProperties", hostProperties()).add("WorkerLog", workerLog()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "workerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "targetLifecycleStatus":
            return Optional.ofNullable(clazz.cast(targetLifecycleStatusAsString()));
        case "hostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        case "workerLog":
            return Optional.ofNullable(clazz.cast(workerLog()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("workerId", WORKER_ID_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("log", LOG_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("targetLifecycleStatus", TARGET_LIFECYCLE_STATUS_FIELD);
        map.put("hostProperties", HOST_PROPERTIES_FIELD);
        map.put("workerLog", WORKER_LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionResponse, T> g) {
        return obj -> g.apply((GetSessionResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, GetSessionResponse> {
        /**
         * <p>
         * The session ID.
         * </p>
         * 
         * @param sessionId
         *        The session ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The fleet ID for the session.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The worker ID for the session.
         * </p>
         * 
         * @param workerId
         *        The worker ID for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The session log.
         * </p>
         * 
         * @param log
         *        The session log.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(LogConfiguration log);

        /**
         * <p>
         * The session log.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #log(LogConfiguration)}.
         * 
         * @param log
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #log(LogConfiguration)
         */
        default Builder log(Consumer<LogConfiguration.Builder> log) {
            return log(LogConfiguration.builder().applyMutation(log).build());
        }

        /**
         * <p>
         * The life cycle status of the session.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status of the session.
         * @see SessionLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status of the session.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status of the session.
         * @see SessionLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleStatus
         */
        Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The life cycle status with which the session started.
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status with which the session started.
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(String targetLifecycleStatus);

        /**
         * <p>
         * The life cycle status with which the session started.
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status with which the session started.
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus);

        /**
         * <p>
         * Provides the Amazon EC2 properties of the host.
         * </p>
         * 
         * @param hostProperties
         *        Provides the Amazon EC2 properties of the host.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostPropertiesResponse hostProperties);

        /**
         * <p>
         * Provides the Amazon EC2 properties of the host.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPropertiesResponse.Builder} avoiding
         * the need to create one manually via {@link HostPropertiesResponse#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPropertiesResponse.Builder#build()} is called immediately and
         * its result is passed to {@link #hostProperties(HostPropertiesResponse)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostPropertiesResponse.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostPropertiesResponse)
         */
        default Builder hostProperties(Consumer<HostPropertiesResponse.Builder> hostProperties) {
            return hostProperties(HostPropertiesResponse.builder().applyMutation(hostProperties).build());
        }

        /**
         * <p>
         * The worker log for the session.
         * </p>
         * 
         * @param workerLog
         *        The worker log for the session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerLog(LogConfiguration workerLog);

        /**
         * <p>
         * The worker log for the session.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #workerLog(LogConfiguration)}.
         * 
         * @param workerLog
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #workerLog(LogConfiguration)
         */
        default Builder workerLog(Consumer<LogConfiguration.Builder> workerLog) {
            return workerLog(LogConfiguration.builder().applyMutation(workerLog).build());
        }
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private String sessionId;

        private String fleetId;

        private String workerId;

        private Instant startedAt;

        private LogConfiguration log;

        private String lifecycleStatus;

        private Instant endedAt;

        private Instant updatedAt;

        private String updatedBy;

        private String targetLifecycleStatus;

        private HostPropertiesResponse hostProperties;

        private LogConfiguration workerLog;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionResponse model) {
            super(model);
            sessionId(model.sessionId);
            fleetId(model.fleetId);
            workerId(model.workerId);
            startedAt(model.startedAt);
            log(model.log);
            lifecycleStatus(model.lifecycleStatus);
            endedAt(model.endedAt);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            targetLifecycleStatus(model.targetLifecycleStatus);
            hostProperties(model.hostProperties);
            workerLog(model.workerLog);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final LogConfiguration.Builder getLog() {
            return log != null ? log.toBuilder() : null;
        }

        public final void setLog(LogConfiguration.BuilderImpl log) {
            this.log = log != null ? log.build() : null;
        }

        @Override
        public final Builder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        public final HostPropertiesResponse.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesResponse.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesResponse hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final LogConfiguration.Builder getWorkerLog() {
            return workerLog != null ? workerLog.toBuilder() : null;
        }

        public final void setWorkerLog(LogConfiguration.BuilderImpl workerLog) {
            this.workerLog = workerLog != null ? workerLog.build() : null;
        }

        @Override
        public final Builder workerLog(LogConfiguration workerLog) {
            this.workerLog = workerLog;
            return this;
        }

        @Override
        public GetSessionResponse build() {
            return new GetSessionResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
