/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Identifies the user for a job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class JobRunAsUser implements SdkPojo, Serializable, ToCopyableBuilder<JobRunAsUser.Builder, JobRunAsUser> {
    private static final SdkField<PosixUser> POSIX_FIELD = SdkField.<PosixUser> builder(MarshallingType.SDK_POJO)
            .memberName("posix").getter(getter(JobRunAsUser::posix)).setter(setter(Builder::posix))
            .constructor(PosixUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("posix").build()).build();

    private static final SdkField<WindowsUser> WINDOWS_FIELD = SdkField.<WindowsUser> builder(MarshallingType.SDK_POJO)
            .memberName("windows").getter(getter(JobRunAsUser::windows)).setter(setter(Builder::windows))
            .constructor(WindowsUser::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("windows").build()).build();

    private static final SdkField<String> RUN_AS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("runAs")
            .getter(getter(JobRunAsUser::runAsAsString)).setter(setter(Builder::runAs))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("runAs").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(POSIX_FIELD, WINDOWS_FIELD,
            RUN_AS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final PosixUser posix;

    private final WindowsUser windows;

    private final String runAs;

    private JobRunAsUser(BuilderImpl builder) {
        this.posix = builder.posix;
        this.windows = builder.windows;
        this.runAs = builder.runAs;
    }

    /**
     * <p>
     * The user and group that the jobs in the queue run as.
     * </p>
     * 
     * @return The user and group that the jobs in the queue run as.
     */
    public final PosixUser posix() {
        return posix;
    }

    /**
     * <p>
     * Identifies a Microsoft Windows user.
     * </p>
     * 
     * @return Identifies a Microsoft Windows user.
     */
    public final WindowsUser windows() {
        return windows;
    }

    /**
     * <p>
     * Specifies whether the job should run using the queue's system user or if the job should run using the worker
     * agent system user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runAs} will return
     * {@link RunAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runAsAsString}.
     * </p>
     * 
     * @return Specifies whether the job should run using the queue's system user or if the job should run using the
     *         worker agent system user.
     * @see RunAs
     */
    public final RunAs runAs() {
        return RunAs.fromValue(runAs);
    }

    /**
     * <p>
     * Specifies whether the job should run using the queue's system user or if the job should run using the worker
     * agent system user.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #runAs} will return
     * {@link RunAs#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #runAsAsString}.
     * </p>
     * 
     * @return Specifies whether the job should run using the queue's system user or if the job should run using the
     *         worker agent system user.
     * @see RunAs
     */
    public final String runAsAsString() {
        return runAs;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(posix());
        hashCode = 31 * hashCode + Objects.hashCode(windows());
        hashCode = 31 * hashCode + Objects.hashCode(runAsAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof JobRunAsUser)) {
            return false;
        }
        JobRunAsUser other = (JobRunAsUser) obj;
        return Objects.equals(posix(), other.posix()) && Objects.equals(windows(), other.windows())
                && Objects.equals(runAsAsString(), other.runAsAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("JobRunAsUser").add("Posix", posix()).add("Windows", windows()).add("RunAs", runAsAsString())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "posix":
            return Optional.ofNullable(clazz.cast(posix()));
        case "windows":
            return Optional.ofNullable(clazz.cast(windows()));
        case "runAs":
            return Optional.ofNullable(clazz.cast(runAsAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("posix", POSIX_FIELD);
        map.put("windows", WINDOWS_FIELD);
        map.put("runAs", RUN_AS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<JobRunAsUser, T> g) {
        return obj -> g.apply((JobRunAsUser) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, JobRunAsUser> {
        /**
         * <p>
         * The user and group that the jobs in the queue run as.
         * </p>
         * 
         * @param posix
         *        The user and group that the jobs in the queue run as.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder posix(PosixUser posix);

        /**
         * <p>
         * The user and group that the jobs in the queue run as.
         * </p>
         * This is a convenience method that creates an instance of the {@link PosixUser.Builder} avoiding the need to
         * create one manually via {@link PosixUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link PosixUser.Builder#build()} is called immediately and its result
         * is passed to {@link #posix(PosixUser)}.
         * 
         * @param posix
         *        a consumer that will call methods on {@link PosixUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #posix(PosixUser)
         */
        default Builder posix(Consumer<PosixUser.Builder> posix) {
            return posix(PosixUser.builder().applyMutation(posix).build());
        }

        /**
         * <p>
         * Identifies a Microsoft Windows user.
         * </p>
         * 
         * @param windows
         *        Identifies a Microsoft Windows user.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder windows(WindowsUser windows);

        /**
         * <p>
         * Identifies a Microsoft Windows user.
         * </p>
         * This is a convenience method that creates an instance of the {@link WindowsUser.Builder} avoiding the need to
         * create one manually via {@link WindowsUser#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WindowsUser.Builder#build()} is called immediately and its result
         * is passed to {@link #windows(WindowsUser)}.
         * 
         * @param windows
         *        a consumer that will call methods on {@link WindowsUser.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #windows(WindowsUser)
         */
        default Builder windows(Consumer<WindowsUser.Builder> windows) {
            return windows(WindowsUser.builder().applyMutation(windows).build());
        }

        /**
         * <p>
         * Specifies whether the job should run using the queue's system user or if the job should run using the worker
         * agent system user.
         * </p>
         * 
         * @param runAs
         *        Specifies whether the job should run using the queue's system user or if the job should run using the
         *        worker agent system user.
         * @see RunAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunAs
         */
        Builder runAs(String runAs);

        /**
         * <p>
         * Specifies whether the job should run using the queue's system user or if the job should run using the worker
         * agent system user.
         * </p>
         * 
         * @param runAs
         *        Specifies whether the job should run using the queue's system user or if the job should run using the
         *        worker agent system user.
         * @see RunAs
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see RunAs
         */
        Builder runAs(RunAs runAs);
    }

    static final class BuilderImpl implements Builder {
        private PosixUser posix;

        private WindowsUser windows;

        private String runAs;

        private BuilderImpl() {
        }

        private BuilderImpl(JobRunAsUser model) {
            posix(model.posix);
            windows(model.windows);
            runAs(model.runAs);
        }

        public final PosixUser.Builder getPosix() {
            return posix != null ? posix.toBuilder() : null;
        }

        public final void setPosix(PosixUser.BuilderImpl posix) {
            this.posix = posix != null ? posix.build() : null;
        }

        @Override
        public final Builder posix(PosixUser posix) {
            this.posix = posix;
            return this;
        }

        public final WindowsUser.Builder getWindows() {
            return windows != null ? windows.toBuilder() : null;
        }

        public final void setWindows(WindowsUser.BuilderImpl windows) {
            this.windows = windows != null ? windows.build() : null;
        }

        @Override
        public final Builder windows(WindowsUser windows) {
            this.windows = windows;
            return this;
        }

        public final String getRunAs() {
            return runAs;
        }

        public final void setRunAs(String runAs) {
            this.runAs = runAs;
        }

        @Override
        public final Builder runAs(String runAs) {
            this.runAs = runAs;
            return this;
        }

        @Override
        public final Builder runAs(RunAs runAs) {
            this.runAs(runAs == null ? null : runAs.toString());
            return this;
        }

        @Override
        public JobRunAsUser build() {
            return new JobRunAsUser(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
