/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details for a license endpoint.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class LicenseEndpointSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<LicenseEndpointSummary.Builder, LicenseEndpointSummary> {
    private static final SdkField<String> LICENSE_ENDPOINT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("licenseEndpointId").getter(getter(LicenseEndpointSummary::licenseEndpointId))
            .setter(setter(Builder::licenseEndpointId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("licenseEndpointId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(LicenseEndpointSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<String> STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("statusMessage").getter(getter(LicenseEndpointSummary::statusMessage))
            .setter(setter(Builder::statusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statusMessage").build()).build();

    private static final SdkField<String> VPC_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("vpcId")
            .getter(getter(LicenseEndpointSummary::vpcId)).setter(setter(Builder::vpcId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LICENSE_ENDPOINT_ID_FIELD,
            STATUS_FIELD, STATUS_MESSAGE_FIELD, VPC_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String licenseEndpointId;

    private final String status;

    private final String statusMessage;

    private final String vpcId;

    private LicenseEndpointSummary(BuilderImpl builder) {
        this.licenseEndpointId = builder.licenseEndpointId;
        this.status = builder.status;
        this.statusMessage = builder.statusMessage;
        this.vpcId = builder.vpcId;
    }

    /**
     * <p>
     * The license endpoint ID.
     * </p>
     * 
     * @return The license endpoint ID.
     */
    public final String licenseEndpointId() {
        return licenseEndpointId;
    }

    /**
     * <p>
     * The status of the license endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the license endpoint.
     * @see LicenseEndpointStatus
     */
    public final LicenseEndpointStatus status() {
        return LicenseEndpointStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of the license endpoint.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link LicenseEndpointStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of the license endpoint.
     * @see LicenseEndpointStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The status message of the license endpoint.
     * </p>
     * 
     * @return The status message of the license endpoint.
     */
    public final String statusMessage() {
        return statusMessage;
    }

    /**
     * <p>
     * The VCP(virtual private cloud) ID associated with the license endpoint.
     * </p>
     * 
     * @return The VCP(virtual private cloud) ID associated with the license endpoint.
     */
    public final String vpcId() {
        return vpcId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(licenseEndpointId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(statusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(vpcId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof LicenseEndpointSummary)) {
            return false;
        }
        LicenseEndpointSummary other = (LicenseEndpointSummary) obj;
        return Objects.equals(licenseEndpointId(), other.licenseEndpointId())
                && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(statusMessage(), other.statusMessage()) && Objects.equals(vpcId(), other.vpcId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("LicenseEndpointSummary").add("LicenseEndpointId", licenseEndpointId())
                .add("Status", statusAsString()).add("StatusMessage", statusMessage()).add("VpcId", vpcId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "licenseEndpointId":
            return Optional.ofNullable(clazz.cast(licenseEndpointId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "statusMessage":
            return Optional.ofNullable(clazz.cast(statusMessage()));
        case "vpcId":
            return Optional.ofNullable(clazz.cast(vpcId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("licenseEndpointId", LICENSE_ENDPOINT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("statusMessage", STATUS_MESSAGE_FIELD);
        map.put("vpcId", VPC_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<LicenseEndpointSummary, T> g) {
        return obj -> g.apply((LicenseEndpointSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, LicenseEndpointSummary> {
        /**
         * <p>
         * The license endpoint ID.
         * </p>
         * 
         * @param licenseEndpointId
         *        The license endpoint ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder licenseEndpointId(String licenseEndpointId);

        /**
         * <p>
         * The status of the license endpoint.
         * </p>
         * 
         * @param status
         *        The status of the license endpoint.
         * @see LicenseEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEndpointStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of the license endpoint.
         * </p>
         * 
         * @param status
         *        The status of the license endpoint.
         * @see LicenseEndpointStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see LicenseEndpointStatus
         */
        Builder status(LicenseEndpointStatus status);

        /**
         * <p>
         * The status message of the license endpoint.
         * </p>
         * 
         * @param statusMessage
         *        The status message of the license endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statusMessage(String statusMessage);

        /**
         * <p>
         * The VCP(virtual private cloud) ID associated with the license endpoint.
         * </p>
         * 
         * @param vpcId
         *        The VCP(virtual private cloud) ID associated with the license endpoint.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcId(String vpcId);
    }

    static final class BuilderImpl implements Builder {
        private String licenseEndpointId;

        private String status;

        private String statusMessage;

        private String vpcId;

        private BuilderImpl() {
        }

        private BuilderImpl(LicenseEndpointSummary model) {
            licenseEndpointId(model.licenseEndpointId);
            status(model.status);
            statusMessage(model.statusMessage);
            vpcId(model.vpcId);
        }

        public final String getLicenseEndpointId() {
            return licenseEndpointId;
        }

        public final void setLicenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
        }

        @Override
        public final Builder licenseEndpointId(String licenseEndpointId) {
            this.licenseEndpointId = licenseEndpointId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(LicenseEndpointStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final String getStatusMessage() {
            return statusMessage;
        }

        public final void setStatusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
        }

        @Override
        public final Builder statusMessage(String statusMessage) {
            this.statusMessage = statusMessage;
            return this;
        }

        public final String getVpcId() {
            return vpcId;
        }

        public final void setVpcId(String vpcId) {
            this.vpcId = vpcId;
        }

        @Override
        public final Builder vpcId(String vpcId) {
            this.vpcId = vpcId;
            return this;
        }

        @Override
        public LicenseEndpointSummary build() {
            return new LicenseEndpointSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
