/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListFleetsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListFleetsResponse.Builder, ListFleetsResponse> {
    private static final SdkField<List<FleetSummary>> FLEETS_FIELD = SdkField
            .<List<FleetSummary>> builder(MarshallingType.LIST)
            .memberName("fleets")
            .getter(getter(ListFleetsResponse::fleets))
            .setter(setter(Builder::fleets))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleets").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListFleetsResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(FLEETS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<FleetSummary> fleets;

    private final String nextToken;

    private ListFleetsResponse(BuilderImpl builder) {
        super(builder);
        this.fleets = builder.fleets;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Fleets property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleets() {
        return fleets != null && !(fleets instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fleets on the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleets} method.
     * </p>
     * 
     * @return The fleets on the list.
     */
    public final List<FleetSummary> fleets() {
        return fleets;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasFleets() ? fleets() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListFleetsResponse)) {
            return false;
        }
        ListFleetsResponse other = (ListFleetsResponse) obj;
        return hasFleets() == other.hasFleets() && Objects.equals(fleets(), other.fleets())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListFleetsResponse").add("Fleets", hasFleets() ? fleets() : null).add("NextToken", nextToken())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "fleets":
            return Optional.ofNullable(clazz.cast(fleets()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("fleets", FLEETS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListFleetsResponse, T> g) {
        return obj -> g.apply((ListFleetsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListFleetsResponse> {
        /**
         * <p>
         * The fleets on the list.
         * </p>
         * 
         * @param fleets
         *        The fleets on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(Collection<FleetSummary> fleets);

        /**
         * <p>
         * The fleets on the list.
         * </p>
         * 
         * @param fleets
         *        The fleets on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleets(FleetSummary... fleets);

        /**
         * <p>
         * The fleets on the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetSummary.Builder} avoiding the need to create one
         * manually via {@link software.amazon.awssdk.services.deadline.model.FleetSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetSummary.Builder#build()} is called immediately and
         * its result is passed to {@link #fleets(List<FleetSummary>)}.
         * 
         * @param fleets
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #fleets(java.util.Collection<FleetSummary>)
         */
        Builder fleets(Consumer<FleetSummary.Builder>... fleets);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<FleetSummary> fleets = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListFleetsResponse model) {
            super(model);
            fleets(model.fleets);
            nextToken(model.nextToken);
        }

        public final List<FleetSummary.Builder> getFleets() {
            List<FleetSummary.Builder> result = FleetSummariesCopier.copyToBuilder(this.fleets);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setFleets(Collection<FleetSummary.BuilderImpl> fleets) {
            this.fleets = FleetSummariesCopier.copyFromBuilder(fleets);
        }

        @Override
        public final Builder fleets(Collection<FleetSummary> fleets) {
            this.fleets = FleetSummariesCopier.copy(fleets);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(FleetSummary... fleets) {
            fleets(Arrays.asList(fleets));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleets(Consumer<FleetSummary.Builder>... fleets) {
            fleets(Stream.of(fleets).map(c -> FleetSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListFleetsResponse build() {
            return new ListFleetsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
