/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListJobParameterDefinitionsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListJobParameterDefinitionsResponse.Builder, ListJobParameterDefinitionsResponse> {
    private static final SdkField<List<Document>> JOB_PARAMETER_DEFINITIONS_FIELD = SdkField
            .<List<Document>> builder(MarshallingType.LIST)
            .memberName("jobParameterDefinitions")
            .getter(getter(ListJobParameterDefinitionsResponse::jobParameterDefinitions))
            .setter(setter(Builder::jobParameterDefinitions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobParameterDefinitions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<Document> builder(MarshallingType.DOCUMENT)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListJobParameterDefinitionsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            JOB_PARAMETER_DEFINITIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<Document> jobParameterDefinitions;

    private final String nextToken;

    private ListJobParameterDefinitionsResponse(BuilderImpl builder) {
        super(builder);
        this.jobParameterDefinitions = builder.jobParameterDefinitions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the JobParameterDefinitions property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasJobParameterDefinitions() {
        return jobParameterDefinitions != null && !(jobParameterDefinitions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * Lists parameter definitions of a job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasJobParameterDefinitions} method.
     * </p>
     * 
     * @return Lists parameter definitions of a job.
     */
    public final List<Document> jobParameterDefinitions() {
        return jobParameterDefinitions;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasJobParameterDefinitions() ? jobParameterDefinitions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListJobParameterDefinitionsResponse)) {
            return false;
        }
        ListJobParameterDefinitionsResponse other = (ListJobParameterDefinitionsResponse) obj;
        return hasJobParameterDefinitions() == other.hasJobParameterDefinitions()
                && Objects.equals(jobParameterDefinitions(), other.jobParameterDefinitions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListJobParameterDefinitionsResponse")
                .add("JobParameterDefinitions", hasJobParameterDefinitions() ? jobParameterDefinitions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobParameterDefinitions":
            return Optional.ofNullable(clazz.cast(jobParameterDefinitions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobParameterDefinitions", JOB_PARAMETER_DEFINITIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListJobParameterDefinitionsResponse, T> g) {
        return obj -> g.apply((ListJobParameterDefinitionsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListJobParameterDefinitionsResponse> {
        /**
         * <p>
         * Lists parameter definitions of a job.
         * </p>
         * 
         * @param jobParameterDefinitions
         *        Lists parameter definitions of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobParameterDefinitions(Collection<Document> jobParameterDefinitions);

        /**
         * <p>
         * Lists parameter definitions of a job.
         * </p>
         * 
         * @param jobParameterDefinitions
         *        Lists parameter definitions of a job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobParameterDefinitions(Document... jobParameterDefinitions);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<Document> jobParameterDefinitions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListJobParameterDefinitionsResponse model) {
            super(model);
            jobParameterDefinitions(model.jobParameterDefinitions);
            nextToken(model.nextToken);
        }

        public final Collection<Document> getJobParameterDefinitions() {
            if (jobParameterDefinitions instanceof SdkAutoConstructList) {
                return null;
            }
            return jobParameterDefinitions;
        }

        public final void setJobParameterDefinitions(Collection<Document> jobParameterDefinitions) {
            this.jobParameterDefinitions = JobParameterDefinitionsCopier.copy(jobParameterDefinitions);
        }

        @Override
        public final Builder jobParameterDefinitions(Collection<Document> jobParameterDefinitions) {
            this.jobParameterDefinitions = JobParameterDefinitionsCopier.copy(jobParameterDefinitions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder jobParameterDefinitions(Document... jobParameterDefinitions) {
            jobParameterDefinitions(Arrays.asList(jobParameterDefinitions));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListJobParameterDefinitionsResponse build() {
            return new ListJobParameterDefinitionsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
