/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListQueueFleetAssociationsResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListQueueFleetAssociationsResponse.Builder, ListQueueFleetAssociationsResponse> {
    private static final SdkField<List<QueueFleetAssociationSummary>> QUEUE_FLEET_ASSOCIATIONS_FIELD = SdkField
            .<List<QueueFleetAssociationSummary>> builder(MarshallingType.LIST)
            .memberName("queueFleetAssociations")
            .getter(getter(ListQueueFleetAssociationsResponse::queueFleetAssociations))
            .setter(setter(Builder::queueFleetAssociations))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueFleetAssociations").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<QueueFleetAssociationSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(QueueFleetAssociationSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListQueueFleetAssociationsResponse::nextToken))
            .setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(
            QUEUE_FLEET_ASSOCIATIONS_FIELD, NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<QueueFleetAssociationSummary> queueFleetAssociations;

    private final String nextToken;

    private ListQueueFleetAssociationsResponse(BuilderImpl builder) {
        super(builder);
        this.queueFleetAssociations = builder.queueFleetAssociations;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueueFleetAssociations property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasQueueFleetAssociations() {
        return queueFleetAssociations != null && !(queueFleetAssociations instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The queue-fleet associations on the list.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueueFleetAssociations} method.
     * </p>
     * 
     * @return The queue-fleet associations on the list.
     */
    public final List<QueueFleetAssociationSummary> queueFleetAssociations() {
        return queueFleetAssociations;
    }

    /**
     * <p>
     * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the operation
     * again using the returned token. Keep all other arguments unchanged. If no results remain, then
     * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you provide
     * a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     * </p>
     * 
     * @return If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
     *         <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
     *         operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
     *         <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
     *         provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueFleetAssociations() ? queueFleetAssociations() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListQueueFleetAssociationsResponse)) {
            return false;
        }
        ListQueueFleetAssociationsResponse other = (ListQueueFleetAssociationsResponse) obj;
        return hasQueueFleetAssociations() == other.hasQueueFleetAssociations()
                && Objects.equals(queueFleetAssociations(), other.queueFleetAssociations())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListQueueFleetAssociationsResponse")
                .add("QueueFleetAssociations", hasQueueFleetAssociations() ? queueFleetAssociations() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueFleetAssociations":
            return Optional.ofNullable(clazz.cast(queueFleetAssociations()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queueFleetAssociations", QUEUE_FLEET_ASSOCIATIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListQueueFleetAssociationsResponse, T> g) {
        return obj -> g.apply((ListQueueFleetAssociationsResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo,
            CopyableBuilder<Builder, ListQueueFleetAssociationsResponse> {
        /**
         * <p>
         * The queue-fleet associations on the list.
         * </p>
         * 
         * @param queueFleetAssociations
         *        The queue-fleet associations on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueFleetAssociations(Collection<QueueFleetAssociationSummary> queueFleetAssociations);

        /**
         * <p>
         * The queue-fleet associations on the list.
         * </p>
         * 
         * @param queueFleetAssociations
         *        The queue-fleet associations on the list.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueFleetAssociations(QueueFleetAssociationSummary... queueFleetAssociations);

        /**
         * <p>
         * The queue-fleet associations on the list.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary.Builder} avoiding the need
         * to create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #queueFleetAssociations(List<QueueFleetAssociationSummary>)}.
         * 
         * @param queueFleetAssociations
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.QueueFleetAssociationSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #queueFleetAssociations(java.util.Collection<QueueFleetAssociationSummary>)
         */
        Builder queueFleetAssociations(Consumer<QueueFleetAssociationSummary.Builder>... queueFleetAssociations);

        /**
         * <p>
         * If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         * <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         * operation again using the returned token. Keep all other arguments unchanged. If no results remain, then
         * <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours. If you
         * provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code> error.
         * </p>
         * 
         * @param nextToken
         *        If Deadline Cloud returns <code>nextToken</code>, then there are more results available. The value of
         *        <code>nextToken</code> is a unique pagination token for each page. To retrieve the next page, call the
         *        operation again using the returned token. Keep all other arguments unchanged. If no results remain,
         *        then <code>nextToken</code> is set to <code>null</code>. Each pagination token expires after 24 hours.
         *        If you provide a token that isn't valid, then you receive an HTTP 400 <code>ValidationException</code>
         *        error.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<QueueFleetAssociationSummary> queueFleetAssociations = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListQueueFleetAssociationsResponse model) {
            super(model);
            queueFleetAssociations(model.queueFleetAssociations);
            nextToken(model.nextToken);
        }

        public final List<QueueFleetAssociationSummary.Builder> getQueueFleetAssociations() {
            List<QueueFleetAssociationSummary.Builder> result = QueueFleetAssociationSummariesCopier
                    .copyToBuilder(this.queueFleetAssociations);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setQueueFleetAssociations(Collection<QueueFleetAssociationSummary.BuilderImpl> queueFleetAssociations) {
            this.queueFleetAssociations = QueueFleetAssociationSummariesCopier.copyFromBuilder(queueFleetAssociations);
        }

        @Override
        public final Builder queueFleetAssociations(Collection<QueueFleetAssociationSummary> queueFleetAssociations) {
            this.queueFleetAssociations = QueueFleetAssociationSummariesCopier.copy(queueFleetAssociations);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueFleetAssociations(QueueFleetAssociationSummary... queueFleetAssociations) {
            queueFleetAssociations(Arrays.asList(queueFleetAssociations));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueFleetAssociations(Consumer<QueueFleetAssociationSummary.Builder>... queueFleetAssociations) {
            queueFleetAssociations(Stream.of(queueFleetAssociations)
                    .map(c -> QueueFleetAssociationSummary.builder().applyMutation(c).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListQueueFleetAssociationsResponse build() {
            return new ListQueueFleetAssociationsResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
