/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a source and destination path.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class PathMappingRule implements SdkPojo, Serializable, ToCopyableBuilder<PathMappingRule.Builder, PathMappingRule> {
    private static final SdkField<String> SOURCE_PATH_FORMAT_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourcePathFormat").getter(getter(PathMappingRule::sourcePathFormatAsString))
            .setter(setter(Builder::sourcePathFormat))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePathFormat").build()).build();

    private static final SdkField<String> SOURCE_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sourcePath").getter(getter(PathMappingRule::sourcePath)).setter(setter(Builder::sourcePath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sourcePath").build()).build();

    private static final SdkField<String> DESTINATION_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("destinationPath").getter(getter(PathMappingRule::destinationPath))
            .setter(setter(Builder::destinationPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("destinationPath").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SOURCE_PATH_FORMAT_FIELD,
            SOURCE_PATH_FIELD, DESTINATION_PATH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sourcePathFormat;

    private final String sourcePath;

    private final String destinationPath;

    private PathMappingRule(BuilderImpl builder) {
        this.sourcePathFormat = builder.sourcePathFormat;
        this.sourcePath = builder.sourcePath;
        this.destinationPath = builder.destinationPath;
    }

    /**
     * <p>
     * The source path format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourcePathFormat}
     * will return {@link PathFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourcePathFormatAsString}.
     * </p>
     * 
     * @return The source path format.
     * @see PathFormat
     */
    public final PathFormat sourcePathFormat() {
        return PathFormat.fromValue(sourcePathFormat);
    }

    /**
     * <p>
     * The source path format.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #sourcePathFormat}
     * will return {@link PathFormat#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #sourcePathFormatAsString}.
     * </p>
     * 
     * @return The source path format.
     * @see PathFormat
     */
    public final String sourcePathFormatAsString() {
        return sourcePathFormat;
    }

    /**
     * <p>
     * The source path.
     * </p>
     * 
     * @return The source path.
     */
    public final String sourcePath() {
        return sourcePath;
    }

    /**
     * <p>
     * The destination path.
     * </p>
     * 
     * @return The destination path.
     */
    public final String destinationPath() {
        return destinationPath;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sourcePathFormatAsString());
        hashCode = 31 * hashCode + Objects.hashCode(sourcePath());
        hashCode = 31 * hashCode + Objects.hashCode(destinationPath());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PathMappingRule)) {
            return false;
        }
        PathMappingRule other = (PathMappingRule) obj;
        return Objects.equals(sourcePathFormatAsString(), other.sourcePathFormatAsString())
                && Objects.equals(sourcePath(), other.sourcePath()) && Objects.equals(destinationPath(), other.destinationPath());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("PathMappingRule").add("SourcePathFormat", sourcePathFormatAsString())
                .add("SourcePath", sourcePath()).add("DestinationPath", destinationPath()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sourcePathFormat":
            return Optional.ofNullable(clazz.cast(sourcePathFormatAsString()));
        case "sourcePath":
            return Optional.ofNullable(clazz.cast(sourcePath()));
        case "destinationPath":
            return Optional.ofNullable(clazz.cast(destinationPath()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sourcePathFormat", SOURCE_PATH_FORMAT_FIELD);
        map.put("sourcePath", SOURCE_PATH_FIELD);
        map.put("destinationPath", DESTINATION_PATH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<PathMappingRule, T> g) {
        return obj -> g.apply((PathMappingRule) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, PathMappingRule> {
        /**
         * <p>
         * The source path format.
         * </p>
         * 
         * @param sourcePathFormat
         *        The source path format.
         * @see PathFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PathFormat
         */
        Builder sourcePathFormat(String sourcePathFormat);

        /**
         * <p>
         * The source path format.
         * </p>
         * 
         * @param sourcePathFormat
         *        The source path format.
         * @see PathFormat
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PathFormat
         */
        Builder sourcePathFormat(PathFormat sourcePathFormat);

        /**
         * <p>
         * The source path.
         * </p>
         * 
         * @param sourcePath
         *        The source path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sourcePath(String sourcePath);

        /**
         * <p>
         * The destination path.
         * </p>
         * 
         * @param destinationPath
         *        The destination path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder destinationPath(String destinationPath);
    }

    static final class BuilderImpl implements Builder {
        private String sourcePathFormat;

        private String sourcePath;

        private String destinationPath;

        private BuilderImpl() {
        }

        private BuilderImpl(PathMappingRule model) {
            sourcePathFormat(model.sourcePathFormat);
            sourcePath(model.sourcePath);
            destinationPath(model.destinationPath);
        }

        public final String getSourcePathFormat() {
            return sourcePathFormat;
        }

        public final void setSourcePathFormat(String sourcePathFormat) {
            this.sourcePathFormat = sourcePathFormat;
        }

        @Override
        public final Builder sourcePathFormat(String sourcePathFormat) {
            this.sourcePathFormat = sourcePathFormat;
            return this;
        }

        @Override
        public final Builder sourcePathFormat(PathFormat sourcePathFormat) {
            this.sourcePathFormat(sourcePathFormat == null ? null : sourcePathFormat.toString());
            return this;
        }

        public final String getSourcePath() {
            return sourcePath;
        }

        public final void setSourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
        }

        @Override
        public final Builder sourcePath(String sourcePath) {
            this.sourcePath = sourcePath;
            return this;
        }

        public final String getDestinationPath() {
            return destinationPath;
        }

        public final void setDestinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
        }

        @Override
        public final Builder destinationPath(String destinationPath) {
            this.destinationPath = destinationPath;
            return this;
        }

        @Override
        public PathMappingRule build() {
            return new PathMappingRule(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
