/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The Amazon EC2 instance capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceManagedEc2InstanceCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceManagedEc2InstanceCapabilities.Builder, ServiceManagedEc2InstanceCapabilities> {
    private static final SdkField<VCpuCountRange> V_CPU_COUNT_FIELD = SdkField.<VCpuCountRange> builder(MarshallingType.SDK_POJO)
            .memberName("vCpuCount").getter(getter(ServiceManagedEc2InstanceCapabilities::vCpuCount))
            .setter(setter(Builder::vCpuCount)).constructor(VCpuCountRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpuCount").build()).build();

    private static final SdkField<MemoryMiBRange> MEMORY_MIB_FIELD = SdkField.<MemoryMiBRange> builder(MarshallingType.SDK_POJO)
            .memberName("memoryMiB").getter(getter(ServiceManagedEc2InstanceCapabilities::memoryMiB))
            .setter(setter(Builder::memoryMiB)).constructor(MemoryMiBRange::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryMiB").build()).build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(ServiceManagedEc2InstanceCapabilities::osFamilyAsString))
            .setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final SdkField<String> CPU_ARCHITECTURE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("cpuArchitectureType").getter(getter(ServiceManagedEc2InstanceCapabilities::cpuArchitectureTypeAsString))
            .setter(setter(Builder::cpuArchitectureType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitectureType").build())
            .build();

    private static final SdkField<Ec2EbsVolume> ROOT_EBS_VOLUME_FIELD = SdkField.<Ec2EbsVolume> builder(MarshallingType.SDK_POJO)
            .memberName("rootEbsVolume").getter(getter(ServiceManagedEc2InstanceCapabilities::rootEbsVolume))
            .setter(setter(Builder::rootEbsVolume)).constructor(Ec2EbsVolume::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootEbsVolume").build()).build();

    private static final SdkField<AcceleratorCapabilities> ACCELERATOR_CAPABILITIES_FIELD = SdkField
            .<AcceleratorCapabilities> builder(MarshallingType.SDK_POJO).memberName("acceleratorCapabilities")
            .getter(getter(ServiceManagedEc2InstanceCapabilities::acceleratorCapabilities))
            .setter(setter(Builder::acceleratorCapabilities)).constructor(AcceleratorCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorCapabilities").build())
            .build();

    private static final SdkField<List<String>> ALLOWED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("allowedInstanceTypes")
            .getter(getter(ServiceManagedEc2InstanceCapabilities::allowedInstanceTypes))
            .setter(setter(Builder::allowedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("excludedInstanceTypes")
            .getter(getter(ServiceManagedEc2InstanceCapabilities::excludedInstanceTypes))
            .setter(setter(Builder::excludedInstanceTypes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedInstanceTypes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FleetAmountCapability>> CUSTOM_AMOUNTS_FIELD = SdkField
            .<List<FleetAmountCapability>> builder(MarshallingType.LIST)
            .memberName("customAmounts")
            .getter(getter(ServiceManagedEc2InstanceCapabilities::customAmounts))
            .setter(setter(Builder::customAmounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAmounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAmountCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAmountCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<FleetAttributeCapability>> CUSTOM_ATTRIBUTES_FIELD = SdkField
            .<List<FleetAttributeCapability>> builder(MarshallingType.LIST)
            .memberName("customAttributes")
            .getter(getter(ServiceManagedEc2InstanceCapabilities::customAttributes))
            .setter(setter(Builder::customAttributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<FleetAttributeCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(FleetAttributeCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_COUNT_FIELD,
            MEMORY_MIB_FIELD, OS_FAMILY_FIELD, CPU_ARCHITECTURE_TYPE_FIELD, ROOT_EBS_VOLUME_FIELD,
            ACCELERATOR_CAPABILITIES_FIELD, ALLOWED_INSTANCE_TYPES_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, CUSTOM_AMOUNTS_FIELD,
            CUSTOM_ATTRIBUTES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final VCpuCountRange vCpuCount;

    private final MemoryMiBRange memoryMiB;

    private final String osFamily;

    private final String cpuArchitectureType;

    private final Ec2EbsVolume rootEbsVolume;

    private final AcceleratorCapabilities acceleratorCapabilities;

    private final List<String> allowedInstanceTypes;

    private final List<String> excludedInstanceTypes;

    private final List<FleetAmountCapability> customAmounts;

    private final List<FleetAttributeCapability> customAttributes;

    private ServiceManagedEc2InstanceCapabilities(BuilderImpl builder) {
        this.vCpuCount = builder.vCpuCount;
        this.memoryMiB = builder.memoryMiB;
        this.osFamily = builder.osFamily;
        this.cpuArchitectureType = builder.cpuArchitectureType;
        this.rootEbsVolume = builder.rootEbsVolume;
        this.acceleratorCapabilities = builder.acceleratorCapabilities;
        this.allowedInstanceTypes = builder.allowedInstanceTypes;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.customAmounts = builder.customAmounts;
        this.customAttributes = builder.customAttributes;
    }

    /**
     * <p>
     * The amount of vCPU to require for instances in this fleet.
     * </p>
     * 
     * @return The amount of vCPU to require for instances in this fleet.
     */
    public final VCpuCountRange vCpuCount() {
        return vCpuCount;
    }

    /**
     * <p>
     * The memory, as MiB, for the Amazon EC2 instance type.
     * </p>
     * 
     * @return The memory, as MiB, for the Amazon EC2 instance type.
     */
    public final MemoryMiBRange memoryMiB() {
        return memoryMiB;
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link ServiceManagedFleetOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see ServiceManagedFleetOperatingSystemFamily
     */
    public final ServiceManagedFleetOperatingSystemFamily osFamily() {
        return ServiceManagedFleetOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link ServiceManagedFleetOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the
     * service is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see ServiceManagedFleetOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    /**
     * <p>
     * The CPU architecture type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cpuArchitectureType} will return {@link CpuArchitectureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cpuArchitectureTypeAsString}.
     * </p>
     * 
     * @return The CPU architecture type.
     * @see CpuArchitectureType
     */
    public final CpuArchitectureType cpuArchitectureType() {
        return CpuArchitectureType.fromValue(cpuArchitectureType);
    }

    /**
     * <p>
     * The CPU architecture type.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #cpuArchitectureType} will return {@link CpuArchitectureType#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #cpuArchitectureTypeAsString}.
     * </p>
     * 
     * @return The CPU architecture type.
     * @see CpuArchitectureType
     */
    public final String cpuArchitectureTypeAsString() {
        return cpuArchitectureType;
    }

    /**
     * <p>
     * The root EBS volume.
     * </p>
     * 
     * @return The root EBS volume.
     */
    public final Ec2EbsVolume rootEbsVolume() {
        return rootEbsVolume;
    }

    /**
     * <p>
     * The GPU accelerator capabilities required for the Amazon EC2 instances. If you include the
     * <code>acceleratorCapabilities</code> property in the <a
     * href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_ServiceManagedEc2InstanceCapabilities"
     * >ServiceManagedEc2InstanceCapabilities</a> object, all of the Amazon EC2 instances will have at least one
     * accelerator.
     * </p>
     * 
     * @return The GPU accelerator capabilities required for the Amazon EC2 instances. If you include the
     *         <code>acceleratorCapabilities</code> property in the <a
     *         href="https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_ServiceManagedEc2InstanceCapabilities"
     *         >ServiceManagedEc2InstanceCapabilities</a> object, all of the Amazon EC2 instances will have at least one
     *         accelerator.
     */
    public final AcceleratorCapabilities acceleratorCapabilities() {
        return acceleratorCapabilities;
    }

    /**
     * For responses, this returns true if the service returned a value for the AllowedInstanceTypes property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAllowedInstanceTypes() {
        return allowedInstanceTypes != null && !(allowedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The allowable Amazon EC2 instance types.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAllowedInstanceTypes} method.
     * </p>
     * 
     * @return The allowable Amazon EC2 instance types.
     */
    public final List<String> allowedInstanceTypes() {
        return allowedInstanceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the ExcludedInstanceTypes property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasExcludedInstanceTypes() {
        return excludedInstanceTypes != null && !(excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The instance types to exclude from the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasExcludedInstanceTypes} method.
     * </p>
     * 
     * @return The instance types to exclude from the fleet.
     */
    public final List<String> excludedInstanceTypes() {
        return excludedInstanceTypes;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAmounts property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAmounts() {
        return customAmounts != null && !(customAmounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom capability amounts to require for instances in this fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAmounts} method.
     * </p>
     * 
     * @return The custom capability amounts to require for instances in this fleet.
     */
    public final List<FleetAmountCapability> customAmounts() {
        return customAmounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the CustomAttributes property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCustomAttributes() {
        return customAttributes != null && !(customAttributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The custom capability attributes to require for instances in this fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCustomAttributes} method.
     * </p>
     * 
     * @return The custom capability attributes to require for instances in this fleet.
     */
    public final List<FleetAttributeCapability> customAttributes() {
        return customAttributes;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(vCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(cpuArchitectureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(rootEbsVolume());
        hashCode = 31 * hashCode + Objects.hashCode(acceleratorCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hasAllowedInstanceTypes() ? allowedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasExcludedInstanceTypes() ? excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAmounts() ? customAmounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCustomAttributes() ? customAttributes() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEc2InstanceCapabilities)) {
            return false;
        }
        ServiceManagedEc2InstanceCapabilities other = (ServiceManagedEc2InstanceCapabilities) obj;
        return Objects.equals(vCpuCount(), other.vCpuCount()) && Objects.equals(memoryMiB(), other.memoryMiB())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString())
                && Objects.equals(cpuArchitectureTypeAsString(), other.cpuArchitectureTypeAsString())
                && Objects.equals(rootEbsVolume(), other.rootEbsVolume())
                && Objects.equals(acceleratorCapabilities(), other.acceleratorCapabilities())
                && hasAllowedInstanceTypes() == other.hasAllowedInstanceTypes()
                && Objects.equals(allowedInstanceTypes(), other.allowedInstanceTypes())
                && hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes()
                && Objects.equals(excludedInstanceTypes(), other.excludedInstanceTypes())
                && hasCustomAmounts() == other.hasCustomAmounts() && Objects.equals(customAmounts(), other.customAmounts())
                && hasCustomAttributes() == other.hasCustomAttributes()
                && Objects.equals(customAttributes(), other.customAttributes());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceManagedEc2InstanceCapabilities").add("VCpuCount", vCpuCount())
                .add("MemoryMiB", memoryMiB()).add("OsFamily", osFamilyAsString())
                .add("CpuArchitectureType", cpuArchitectureTypeAsString()).add("RootEbsVolume", rootEbsVolume())
                .add("AcceleratorCapabilities", acceleratorCapabilities())
                .add("AllowedInstanceTypes", hasAllowedInstanceTypes() ? allowedInstanceTypes() : null)
                .add("ExcludedInstanceTypes", hasExcludedInstanceTypes() ? excludedInstanceTypes() : null)
                .add("CustomAmounts", hasCustomAmounts() ? customAmounts() : null)
                .add("CustomAttributes", hasCustomAttributes() ? customAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "vCpuCount":
            return Optional.ofNullable(clazz.cast(vCpuCount()));
        case "memoryMiB":
            return Optional.ofNullable(clazz.cast(memoryMiB()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        case "cpuArchitectureType":
            return Optional.ofNullable(clazz.cast(cpuArchitectureTypeAsString()));
        case "rootEbsVolume":
            return Optional.ofNullable(clazz.cast(rootEbsVolume()));
        case "acceleratorCapabilities":
            return Optional.ofNullable(clazz.cast(acceleratorCapabilities()));
        case "allowedInstanceTypes":
            return Optional.ofNullable(clazz.cast(allowedInstanceTypes()));
        case "excludedInstanceTypes":
            return Optional.ofNullable(clazz.cast(excludedInstanceTypes()));
        case "customAmounts":
            return Optional.ofNullable(clazz.cast(customAmounts()));
        case "customAttributes":
            return Optional.ofNullable(clazz.cast(customAttributes()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("vCpuCount", V_CPU_COUNT_FIELD);
        map.put("memoryMiB", MEMORY_MIB_FIELD);
        map.put("osFamily", OS_FAMILY_FIELD);
        map.put("cpuArchitectureType", CPU_ARCHITECTURE_TYPE_FIELD);
        map.put("rootEbsVolume", ROOT_EBS_VOLUME_FIELD);
        map.put("acceleratorCapabilities", ACCELERATOR_CAPABILITIES_FIELD);
        map.put("allowedInstanceTypes", ALLOWED_INSTANCE_TYPES_FIELD);
        map.put("excludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        map.put("customAmounts", CUSTOM_AMOUNTS_FIELD);
        map.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceManagedEc2InstanceCapabilities, T> g) {
        return obj -> g.apply((ServiceManagedEc2InstanceCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceManagedEc2InstanceCapabilities> {
        /**
         * <p>
         * The amount of vCPU to require for instances in this fleet.
         * </p>
         * 
         * @param vCpuCount
         *        The amount of vCPU to require for instances in this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vCpuCount(VCpuCountRange vCpuCount);

        /**
         * <p>
         * The amount of vCPU to require for instances in this fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VCpuCountRange.Builder} avoiding the need
         * to create one manually via {@link VCpuCountRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VCpuCountRange.Builder#build()} is called immediately and its
         * result is passed to {@link #vCpuCount(VCpuCountRange)}.
         * 
         * @param vCpuCount
         *        a consumer that will call methods on {@link VCpuCountRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vCpuCount(VCpuCountRange)
         */
        default Builder vCpuCount(Consumer<VCpuCountRange.Builder> vCpuCount) {
            return vCpuCount(VCpuCountRange.builder().applyMutation(vCpuCount).build());
        }

        /**
         * <p>
         * The memory, as MiB, for the Amazon EC2 instance type.
         * </p>
         * 
         * @param memoryMiB
         *        The memory, as MiB, for the Amazon EC2 instance type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder memoryMiB(MemoryMiBRange memoryMiB);

        /**
         * <p>
         * The memory, as MiB, for the Amazon EC2 instance type.
         * </p>
         * This is a convenience method that creates an instance of the {@link MemoryMiBRange.Builder} avoiding the need
         * to create one manually via {@link MemoryMiBRange#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link MemoryMiBRange.Builder#build()} is called immediately and its
         * result is passed to {@link #memoryMiB(MemoryMiBRange)}.
         * 
         * @param memoryMiB
         *        a consumer that will call methods on {@link MemoryMiBRange.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #memoryMiB(MemoryMiBRange)
         */
        default Builder memoryMiB(Consumer<MemoryMiBRange.Builder> memoryMiB) {
            return memoryMiB(MemoryMiBRange.builder().applyMutation(memoryMiB).build());
        }

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see ServiceManagedFleetOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceManagedFleetOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see ServiceManagedFleetOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ServiceManagedFleetOperatingSystemFamily
         */
        Builder osFamily(ServiceManagedFleetOperatingSystemFamily osFamily);

        /**
         * <p>
         * The CPU architecture type.
         * </p>
         * 
         * @param cpuArchitectureType
         *        The CPU architecture type.
         * @see CpuArchitectureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuArchitectureType
         */
        Builder cpuArchitectureType(String cpuArchitectureType);

        /**
         * <p>
         * The CPU architecture type.
         * </p>
         * 
         * @param cpuArchitectureType
         *        The CPU architecture type.
         * @see CpuArchitectureType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see CpuArchitectureType
         */
        Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType);

        /**
         * <p>
         * The root EBS volume.
         * </p>
         * 
         * @param rootEbsVolume
         *        The root EBS volume.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder rootEbsVolume(Ec2EbsVolume rootEbsVolume);

        /**
         * <p>
         * The root EBS volume.
         * </p>
         * This is a convenience method that creates an instance of the {@link Ec2EbsVolume.Builder} avoiding the need
         * to create one manually via {@link Ec2EbsVolume#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link Ec2EbsVolume.Builder#build()} is called immediately and its
         * result is passed to {@link #rootEbsVolume(Ec2EbsVolume)}.
         * 
         * @param rootEbsVolume
         *        a consumer that will call methods on {@link Ec2EbsVolume.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #rootEbsVolume(Ec2EbsVolume)
         */
        default Builder rootEbsVolume(Consumer<Ec2EbsVolume.Builder> rootEbsVolume) {
            return rootEbsVolume(Ec2EbsVolume.builder().applyMutation(rootEbsVolume).build());
        }

        /**
         * <p>
         * The GPU accelerator capabilities required for the Amazon EC2 instances. If you include the
         * <code>acceleratorCapabilities</code> property in the <a href=
         * "https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_ServiceManagedEc2InstanceCapabilities"
         * >ServiceManagedEc2InstanceCapabilities</a> object, all of the Amazon EC2 instances will have at least one
         * accelerator.
         * </p>
         * 
         * @param acceleratorCapabilities
         *        The GPU accelerator capabilities required for the Amazon EC2 instances. If you include the
         *        <code>acceleratorCapabilities</code> property in the <a href=
         *        "https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_ServiceManagedEc2InstanceCapabilities"
         *        >ServiceManagedEc2InstanceCapabilities</a> object, all of the Amazon EC2 instances will have at least
         *        one accelerator.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder acceleratorCapabilities(AcceleratorCapabilities acceleratorCapabilities);

        /**
         * <p>
         * The GPU accelerator capabilities required for the Amazon EC2 instances. If you include the
         * <code>acceleratorCapabilities</code> property in the <a href=
         * "https://docs.aws.amazon.com/deadline-cloud/latest/APIReference/API_ServiceManagedEc2InstanceCapabilities"
         * >ServiceManagedEc2InstanceCapabilities</a> object, all of the Amazon EC2 instances will have at least one
         * accelerator.
         * </p>
         * This is a convenience method that creates an instance of the {@link AcceleratorCapabilities.Builder} avoiding
         * the need to create one manually via {@link AcceleratorCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link AcceleratorCapabilities.Builder#build()} is called immediately
         * and its result is passed to {@link #acceleratorCapabilities(AcceleratorCapabilities)}.
         * 
         * @param acceleratorCapabilities
         *        a consumer that will call methods on {@link AcceleratorCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #acceleratorCapabilities(AcceleratorCapabilities)
         */
        default Builder acceleratorCapabilities(Consumer<AcceleratorCapabilities.Builder> acceleratorCapabilities) {
            return acceleratorCapabilities(AcceleratorCapabilities.builder().applyMutation(acceleratorCapabilities).build());
        }

        /**
         * <p>
         * The allowable Amazon EC2 instance types.
         * </p>
         * 
         * @param allowedInstanceTypes
         *        The allowable Amazon EC2 instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedInstanceTypes(Collection<String> allowedInstanceTypes);

        /**
         * <p>
         * The allowable Amazon EC2 instance types.
         * </p>
         * 
         * @param allowedInstanceTypes
         *        The allowable Amazon EC2 instance types.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder allowedInstanceTypes(String... allowedInstanceTypes);

        /**
         * <p>
         * The instance types to exclude from the fleet.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        The instance types to exclude from the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes);

        /**
         * <p>
         * The instance types to exclude from the fleet.
         * </p>
         * 
         * @param excludedInstanceTypes
         *        The instance types to exclude from the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder excludedInstanceTypes(String... excludedInstanceTypes);

        /**
         * <p>
         * The custom capability amounts to require for instances in this fleet.
         * </p>
         * 
         * @param customAmounts
         *        The custom capability amounts to require for instances in this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmounts(Collection<FleetAmountCapability> customAmounts);

        /**
         * <p>
         * The custom capability amounts to require for instances in this fleet.
         * </p>
         * 
         * @param customAmounts
         *        The custom capability amounts to require for instances in this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAmounts(FleetAmountCapability... customAmounts);

        /**
         * <p>
         * The custom capability amounts to require for instances in this fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #customAmounts(List<FleetAmountCapability>)}.
         * 
         * @param customAmounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAmountCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAmounts(java.util.Collection<FleetAmountCapability>)
         */
        Builder customAmounts(Consumer<FleetAmountCapability.Builder>... customAmounts);

        /**
         * <p>
         * The custom capability attributes to require for instances in this fleet.
         * </p>
         * 
         * @param customAttributes
         *        The custom capability attributes to require for instances in this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(Collection<FleetAttributeCapability> customAttributes);

        /**
         * <p>
         * The custom capability attributes to require for instances in this fleet.
         * </p>
         * 
         * @param customAttributes
         *        The custom capability attributes to require for instances in this fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder customAttributes(FleetAttributeCapability... customAttributes);

        /**
         * <p>
         * The custom capability attributes to require for instances in this fleet.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #customAttributes(List<FleetAttributeCapability>)}.
         * 
         * @param customAttributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.FleetAttributeCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #customAttributes(java.util.Collection<FleetAttributeCapability>)
         */
        Builder customAttributes(Consumer<FleetAttributeCapability.Builder>... customAttributes);
    }

    static final class BuilderImpl implements Builder {
        private VCpuCountRange vCpuCount;

        private MemoryMiBRange memoryMiB;

        private String osFamily;

        private String cpuArchitectureType;

        private Ec2EbsVolume rootEbsVolume;

        private AcceleratorCapabilities acceleratorCapabilities;

        private List<String> allowedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();

        private List<FleetAmountCapability> customAmounts = DefaultSdkAutoConstructList.getInstance();

        private List<FleetAttributeCapability> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceManagedEc2InstanceCapabilities model) {
            vCpuCount(model.vCpuCount);
            memoryMiB(model.memoryMiB);
            osFamily(model.osFamily);
            cpuArchitectureType(model.cpuArchitectureType);
            rootEbsVolume(model.rootEbsVolume);
            acceleratorCapabilities(model.acceleratorCapabilities);
            allowedInstanceTypes(model.allowedInstanceTypes);
            excludedInstanceTypes(model.excludedInstanceTypes);
            customAmounts(model.customAmounts);
            customAttributes(model.customAttributes);
        }

        public final VCpuCountRange.Builder getVCpuCount() {
            return vCpuCount != null ? vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(VCpuCountRange.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(VCpuCountRange vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public final MemoryMiBRange.Builder getMemoryMiB() {
            return memoryMiB != null ? memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(MemoryMiBRange.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(MemoryMiBRange memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(ServiceManagedFleetOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final String getCpuArchitectureType() {
            return cpuArchitectureType;
        }

        public final void setCpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
        }

        @Override
        public final Builder cpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
            return this;
        }

        @Override
        public final Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
            this.cpuArchitectureType(cpuArchitectureType == null ? null : cpuArchitectureType.toString());
            return this;
        }

        public final Ec2EbsVolume.Builder getRootEbsVolume() {
            return rootEbsVolume != null ? rootEbsVolume.toBuilder() : null;
        }

        public final void setRootEbsVolume(Ec2EbsVolume.BuilderImpl rootEbsVolume) {
            this.rootEbsVolume = rootEbsVolume != null ? rootEbsVolume.build() : null;
        }

        @Override
        public final Builder rootEbsVolume(Ec2EbsVolume rootEbsVolume) {
            this.rootEbsVolume = rootEbsVolume;
            return this;
        }

        public final AcceleratorCapabilities.Builder getAcceleratorCapabilities() {
            return acceleratorCapabilities != null ? acceleratorCapabilities.toBuilder() : null;
        }

        public final void setAcceleratorCapabilities(AcceleratorCapabilities.BuilderImpl acceleratorCapabilities) {
            this.acceleratorCapabilities = acceleratorCapabilities != null ? acceleratorCapabilities.build() : null;
        }

        @Override
        public final Builder acceleratorCapabilities(AcceleratorCapabilities acceleratorCapabilities) {
            this.acceleratorCapabilities = acceleratorCapabilities;
            return this;
        }

        public final Collection<String> getAllowedInstanceTypes() {
            if (allowedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return allowedInstanceTypes;
        }

        public final void setAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypesCopier.copy(allowedInstanceTypes);
        }

        @Override
        public final Builder allowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypesCopier.copy(allowedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedInstanceTypes(String... allowedInstanceTypes) {
            allowedInstanceTypes(Arrays.asList(allowedInstanceTypes));
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypesCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypesCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String... excludedInstanceTypes) {
            excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final List<FleetAmountCapability.Builder> getCustomAmounts() {
            List<FleetAmountCapability.Builder> result = CustomFleetAmountCapabilitiesCopier.copyToBuilder(this.customAmounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAmounts(Collection<FleetAmountCapability.BuilderImpl> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copyFromBuilder(customAmounts);
        }

        @Override
        public final Builder customAmounts(Collection<FleetAmountCapability> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copy(customAmounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(FleetAmountCapability... customAmounts) {
            customAmounts(Arrays.asList(customAmounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(Consumer<FleetAmountCapability.Builder>... customAmounts) {
            customAmounts(Stream.of(customAmounts).map(c -> FleetAmountCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getCustomAttributes() {
            List<FleetAttributeCapability.Builder> result = CustomFleetAttributeCapabilitiesCopier
                    .copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<FleetAttributeCapability.BuilderImpl> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<FleetAttributeCapability> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(FleetAttributeCapability... customAttributes) {
            customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<FleetAttributeCapability.Builder>... customAttributes) {
            customAttributes(Stream.of(customAttributes).map(c -> FleetAttributeCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public ServiceManagedEc2InstanceCapabilities build() {
            return new ServiceManagedEc2InstanceCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
