/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a step search.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepSearchSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StepSearchSummary.Builder, StepSearchSummary> {
    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(StepSearchSummary::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StepSearchSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(StepSearchSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("name")
            .getter(getter(StepSearchSummary::name)).setter(setter(Builder::name))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("name").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(StepSearchSummary::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<String> LIFECYCLE_STATUS_MESSAGE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatusMessage").getter(getter(StepSearchSummary::lifecycleStatusMessage))
            .setter(setter(Builder::lifecycleStatusMessage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatusMessage").build())
            .build();

    private static final SdkField<String> TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("taskRunStatus").getter(getter(StepSearchSummary::taskRunStatusAsString))
            .setter(setter(Builder::taskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatus").build()).build();

    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetTaskRunStatus").getter(getter(StepSearchSummary::targetTaskRunStatusAsString))
            .setter(setter(Builder::targetTaskRunStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build())
            .build();

    private static final SdkField<Map<String, Integer>> TASK_RUN_STATUS_COUNTS_FIELD = SdkField
            .<Map<String, Integer>> builder(MarshallingType.MAP)
            .memberName("taskRunStatusCounts")
            .getter(getter(StepSearchSummary::taskRunStatusCountsAsStrings))
            .setter(setter(Builder::taskRunStatusCountsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("taskRunStatusCounts").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<Integer> builder(MarshallingType.INTEGER)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(StepSearchSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(StepSearchSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(StepSearchSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<ParameterSpace> PARAMETER_SPACE_FIELD = SdkField
            .<ParameterSpace> builder(MarshallingType.SDK_POJO).memberName("parameterSpace")
            .getter(getter(StepSearchSummary::parameterSpace)).setter(setter(Builder::parameterSpace))
            .constructor(ParameterSpace::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("parameterSpace").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STEP_ID_FIELD, JOB_ID_FIELD,
            QUEUE_ID_FIELD, NAME_FIELD, LIFECYCLE_STATUS_FIELD, LIFECYCLE_STATUS_MESSAGE_FIELD, TASK_RUN_STATUS_FIELD,
            TARGET_TASK_RUN_STATUS_FIELD, TASK_RUN_STATUS_COUNTS_FIELD, CREATED_AT_FIELD, STARTED_AT_FIELD, ENDED_AT_FIELD,
            PARAMETER_SPACE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String stepId;

    private final String jobId;

    private final String queueId;

    private final String name;

    private final String lifecycleStatus;

    private final String lifecycleStatusMessage;

    private final String taskRunStatus;

    private final String targetTaskRunStatus;

    private final Map<String, Integer> taskRunStatusCounts;

    private final Instant createdAt;

    private final Instant startedAt;

    private final Instant endedAt;

    private final ParameterSpace parameterSpace;

    private StepSearchSummary(BuilderImpl builder) {
        this.stepId = builder.stepId;
        this.jobId = builder.jobId;
        this.queueId = builder.queueId;
        this.name = builder.name;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.lifecycleStatusMessage = builder.lifecycleStatusMessage;
        this.taskRunStatus = builder.taskRunStatus;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.taskRunStatusCounts = builder.taskRunStatusCounts;
        this.createdAt = builder.createdAt;
        this.startedAt = builder.startedAt;
        this.endedAt = builder.endedAt;
        this.parameterSpace = builder.parameterSpace;
    }

    /**
     * <p>
     * The step ID.
     * </p>
     * 
     * @return The step ID.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The step name.
     * </p>
     * 
     * @return The step name.
     */
    public final String name() {
        return name;
    }

    /**
     * <p>
     * The life cycle status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link StepLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status.
     * @see StepLifecycleStatus
     */
    public final StepLifecycleStatus lifecycleStatus() {
        return StepLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link StepLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status.
     * @see StepLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * The life cycle status message.
     * </p>
     * 
     * @return The life cycle status message.
     */
    public final String lifecycleStatusMessage() {
        return lifecycleStatusMessage;
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>–pending and waiting for resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>–ready to be processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code>–assigned and will run next on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code>–scheduled to be run on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERRUPTING</code>–being interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>–running on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>–the task is suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>–the task has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>–the task has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>–the task has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>–pending and waiting for resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>–ready to be processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code>–assigned and will run next on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code>–scheduled to be run on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERRUPTING</code>–being interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>–running on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>–the task is suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>–the task has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>–the task has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>–the task has succeeded.
     *         </p>
     *         </li>
     * @see TaskRunStatus
     */
    public final TaskRunStatus taskRunStatus() {
        return TaskRunStatus.fromValue(taskRunStatus);
    }

    /**
     * <p>
     * The task run status for the job.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>PENDING</code>–pending and waiting for resources.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>READY</code>–ready to be processed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>ASSIGNED</code>–assigned and will run next on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SCHEDULED</code>–scheduled to be run on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>INTERRUPTING</code>–being interrupted.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>RUNNING</code>–running on a worker.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUSPENDED</code>–the task is suspended.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>CANCELED</code>–the task has been canceled.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>FAILED</code>–the task has failed.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>SUCCEEDED</code>–the task has succeeded.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #taskRunStatus}
     * will return {@link TaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #taskRunStatusAsString}.
     * </p>
     * 
     * @return The task run status for the job.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>PENDING</code>–pending and waiting for resources.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>READY</code>–ready to be processed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>ASSIGNED</code>–assigned and will run next on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SCHEDULED</code>–scheduled to be run on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>INTERRUPTING</code>–being interrupted.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>RUNNING</code>–running on a worker.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUSPENDED</code>–the task is suspended.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>CANCELED</code>–the task has been canceled.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>FAILED</code>–the task has failed.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>SUCCEEDED</code>–the task has succeeded.
     *         </p>
     *         </li>
     * @see TaskRunStatus
     */
    public final String taskRunStatusAsString() {
        return taskRunStatus;
    }

    /**
     * <p>
     * The task status to start with on the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to start with on the job.
     * @see StepTargetTaskRunStatus
     */
    public final StepTargetTaskRunStatus targetTaskRunStatus() {
        return StepTargetTaskRunStatus.fromValue(targetTaskRunStatus);
    }

    /**
     * <p>
     * The task status to start with on the job.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetTaskRunStatus} will return {@link StepTargetTaskRunStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #targetTaskRunStatusAsString}.
     * </p>
     * 
     * @return The task status to start with on the job.
     * @see StepTargetTaskRunStatus
     */
    public final String targetTaskRunStatusAsString() {
        return targetTaskRunStatus;
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<TaskRunStatus, Integer> taskRunStatusCounts() {
        return TaskRunStatusCountsCopier.copyStringToEnum(taskRunStatusCounts);
    }

    /**
     * For responses, this returns true if the service returned a value for the TaskRunStatusCounts property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasTaskRunStatusCounts() {
        return taskRunStatusCounts != null && !(taskRunStatusCounts instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The number of tasks running on the job.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasTaskRunStatusCounts} method.
     * </p>
     * 
     * @return The number of tasks running on the job.
     */
    public final Map<String, Integer> taskRunStatusCountsAsStrings() {
        return taskRunStatusCounts;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The parameters and combination expressions for the search.
     * </p>
     * 
     * @return The parameters and combination expressions for the search.
     */
    public final ParameterSpace parameterSpace() {
        return parameterSpace;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(name());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusMessage());
        hashCode = 31 * hashCode + Objects.hashCode(taskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(parameterSpace());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepSearchSummary)) {
            return false;
        }
        StepSearchSummary other = (StepSearchSummary) obj;
        return Objects.equals(stepId(), other.stepId()) && Objects.equals(jobId(), other.jobId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(name(), other.name())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(lifecycleStatusMessage(), other.lifecycleStatusMessage())
                && Objects.equals(taskRunStatusAsString(), other.taskRunStatusAsString())
                && Objects.equals(targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString())
                && hasTaskRunStatusCounts() == other.hasTaskRunStatusCounts()
                && Objects.equals(taskRunStatusCountsAsStrings(), other.taskRunStatusCountsAsStrings())
                && Objects.equals(createdAt(), other.createdAt()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(endedAt(), other.endedAt()) && Objects.equals(parameterSpace(), other.parameterSpace());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepSearchSummary").add("StepId", stepId()).add("JobId", jobId()).add("QueueId", queueId())
                .add("Name", name()).add("LifecycleStatus", lifecycleStatusAsString())
                .add("LifecycleStatusMessage", lifecycleStatusMessage()).add("TaskRunStatus", taskRunStatusAsString())
                .add("TargetTaskRunStatus", targetTaskRunStatusAsString())
                .add("TaskRunStatusCounts", hasTaskRunStatusCounts() ? taskRunStatusCountsAsStrings() : null)
                .add("CreatedAt", createdAt()).add("StartedAt", startedAt()).add("EndedAt", endedAt())
                .add("ParameterSpace", parameterSpace()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "name":
            return Optional.ofNullable(clazz.cast(name()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "lifecycleStatusMessage":
            return Optional.ofNullable(clazz.cast(lifecycleStatusMessage()));
        case "taskRunStatus":
            return Optional.ofNullable(clazz.cast(taskRunStatusAsString()));
        case "targetTaskRunStatus":
            return Optional.ofNullable(clazz.cast(targetTaskRunStatusAsString()));
        case "taskRunStatusCounts":
            return Optional.ofNullable(clazz.cast(taskRunStatusCountsAsStrings()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "parameterSpace":
            return Optional.ofNullable(clazz.cast(parameterSpace()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("stepId", STEP_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("name", NAME_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("lifecycleStatusMessage", LIFECYCLE_STATUS_MESSAGE_FIELD);
        map.put("taskRunStatus", TASK_RUN_STATUS_FIELD);
        map.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
        map.put("taskRunStatusCounts", TASK_RUN_STATUS_COUNTS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("parameterSpace", PARAMETER_SPACE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepSearchSummary, T> g) {
        return obj -> g.apply((StepSearchSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepSearchSummary> {
        /**
         * <p>
         * The step ID.
         * </p>
         * 
         * @param stepId
         *        The step ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The step name.
         * </p>
         * 
         * @param name
         *        The step name.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder name(String name);

        /**
         * <p>
         * The life cycle status.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status.
         * @see StepLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status.
         * @see StepLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepLifecycleStatus
         */
        Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * The life cycle status message.
         * </p>
         * 
         * @param lifecycleStatusMessage
         *        The life cycle status message.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder lifecycleStatusMessage(String lifecycleStatusMessage);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>–pending and waiting for resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>–ready to be processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code>–assigned and will run next on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code>–scheduled to be run on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERRUPTING</code>–being interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>–running on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>–the task is suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>–the task has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>–the task has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>–the task has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskRunStatus
         *        The task run status for the job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>–pending and waiting for resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>–ready to be processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code>–assigned and will run next on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code>–scheduled to be run on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERRUPTING</code>–being interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>–running on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>–the task is suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>–the task has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>–the task has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>–the task has succeeded.
         *        </p>
         *        </li>
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(String taskRunStatus);

        /**
         * <p>
         * The task run status for the job.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>PENDING</code>–pending and waiting for resources.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>READY</code>–ready to be processed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>ASSIGNED</code>–assigned and will run next on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SCHEDULED</code>–scheduled to be run on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>INTERRUPTING</code>–being interrupted.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>RUNNING</code>–running on a worker.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUSPENDED</code>–the task is suspended.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>CANCELED</code>–the task has been canceled.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>FAILED</code>–the task has failed.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>SUCCEEDED</code>–the task has succeeded.
         * </p>
         * </li>
         * </ul>
         * 
         * @param taskRunStatus
         *        The task run status for the job.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>PENDING</code>–pending and waiting for resources.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>READY</code>–ready to be processed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>ASSIGNED</code>–assigned and will run next on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SCHEDULED</code>–scheduled to be run on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>INTERRUPTING</code>–being interrupted.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>RUNNING</code>–running on a worker.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUSPENDED</code>–the task is suspended.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>CANCELED</code>–the task has been canceled.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>FAILED</code>–the task has failed.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>SUCCEEDED</code>–the task has succeeded.
         *        </p>
         *        </li>
         * @see TaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see TaskRunStatus
         */
        Builder taskRunStatus(TaskRunStatus taskRunStatus);

        /**
         * <p>
         * The task status to start with on the job.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to start with on the job.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(String targetTaskRunStatus);

        /**
         * <p>
         * The task status to start with on the job.
         * </p>
         * 
         * @param targetTaskRunStatus
         *        The task status to start with on the job.
         * @see StepTargetTaskRunStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StepTargetTaskRunStatus
         */
        Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The number of tasks running on the job.
         * </p>
         * 
         * @param taskRunStatusCounts
         *        The number of tasks running on the job.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The parameters and combination expressions for the search.
         * </p>
         * 
         * @param parameterSpace
         *        The parameters and combination expressions for the search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder parameterSpace(ParameterSpace parameterSpace);

        /**
         * <p>
         * The parameters and combination expressions for the search.
         * </p>
         * This is a convenience method that creates an instance of the {@link ParameterSpace.Builder} avoiding the need
         * to create one manually via {@link ParameterSpace#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ParameterSpace.Builder#build()} is called immediately and its
         * result is passed to {@link #parameterSpace(ParameterSpace)}.
         * 
         * @param parameterSpace
         *        a consumer that will call methods on {@link ParameterSpace.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #parameterSpace(ParameterSpace)
         */
        default Builder parameterSpace(Consumer<ParameterSpace.Builder> parameterSpace) {
            return parameterSpace(ParameterSpace.builder().applyMutation(parameterSpace).build());
        }
    }

    static final class BuilderImpl implements Builder {
        private String stepId;

        private String jobId;

        private String queueId;

        private String name;

        private String lifecycleStatus;

        private String lifecycleStatusMessage;

        private String taskRunStatus;

        private String targetTaskRunStatus;

        private Map<String, Integer> taskRunStatusCounts = DefaultSdkAutoConstructMap.getInstance();

        private Instant createdAt;

        private Instant startedAt;

        private Instant endedAt;

        private ParameterSpace parameterSpace;

        private BuilderImpl() {
        }

        private BuilderImpl(StepSearchSummary model) {
            stepId(model.stepId);
            jobId(model.jobId);
            queueId(model.queueId);
            name(model.name);
            lifecycleStatus(model.lifecycleStatus);
            lifecycleStatusMessage(model.lifecycleStatusMessage);
            taskRunStatus(model.taskRunStatus);
            targetTaskRunStatus(model.targetTaskRunStatus);
            taskRunStatusCountsWithStrings(model.taskRunStatusCounts);
            createdAt(model.createdAt);
            startedAt(model.startedAt);
            endedAt(model.endedAt);
            parameterSpace(model.parameterSpace);
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getName() {
            return name;
        }

        public final void setName(String name) {
            this.name = name;
        }

        @Override
        public final Builder name(String name) {
            this.name = name;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(StepLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final String getLifecycleStatusMessage() {
            return lifecycleStatusMessage;
        }

        public final void setLifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
        }

        @Override
        public final Builder lifecycleStatusMessage(String lifecycleStatusMessage) {
            this.lifecycleStatusMessage = lifecycleStatusMessage;
            return this;
        }

        public final String getTaskRunStatus() {
            return taskRunStatus;
        }

        public final void setTaskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
        }

        @Override
        public final Builder taskRunStatus(String taskRunStatus) {
            this.taskRunStatus = taskRunStatus;
            return this;
        }

        @Override
        public final Builder taskRunStatus(TaskRunStatus taskRunStatus) {
            this.taskRunStatus(taskRunStatus == null ? null : taskRunStatus.toString());
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(StepTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Map<String, Integer> getTaskRunStatusCounts() {
            if (taskRunStatusCounts instanceof SdkAutoConstructMap) {
                return null;
            }
            return taskRunStatusCounts;
        }

        public final void setTaskRunStatusCounts(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
        }

        @Override
        public final Builder taskRunStatusCountsWithStrings(Map<String, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copy(taskRunStatusCounts);
            return this;
        }

        @Override
        public final Builder taskRunStatusCounts(Map<TaskRunStatus, Integer> taskRunStatusCounts) {
            this.taskRunStatusCounts = TaskRunStatusCountsCopier.copyEnumToString(taskRunStatusCounts);
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final ParameterSpace.Builder getParameterSpace() {
            return parameterSpace != null ? parameterSpace.toBuilder() : null;
        }

        public final void setParameterSpace(ParameterSpace.BuilderImpl parameterSpace) {
            this.parameterSpace = parameterSpace != null ? parameterSpace.build() : null;
        }

        @Override
        public final Builder parameterSpace(ParameterSpace parameterSpace) {
            this.parameterSpace = parameterSpace;
            return this;
        }

        @Override
        public StepSearchSummary build() {
            return new StepSearchSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
