/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateQueueEnvironmentRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateQueueEnvironmentRequest.Builder, UpdateQueueEnvironmentRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(UpdateQueueEnvironmentRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateQueueEnvironmentRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(UpdateQueueEnvironmentRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> QUEUE_ENVIRONMENT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueEnvironmentId").getter(getter(UpdateQueueEnvironmentRequest::queueEnvironmentId))
            .setter(setter(Builder::queueEnvironmentId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueEnvironmentId").build()).build();

    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("priority").getter(getter(UpdateQueueEnvironmentRequest::priority)).setter(setter(Builder::priority))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()).build();

    private static final SdkField<String> TEMPLATE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("templateType").getter(getter(UpdateQueueEnvironmentRequest::templateTypeAsString))
            .setter(setter(Builder::templateType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("templateType").build()).build();

    private static final SdkField<String> TEMPLATE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("template").getter(getter(UpdateQueueEnvironmentRequest::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            FARM_ID_FIELD, QUEUE_ID_FIELD, QUEUE_ENVIRONMENT_ID_FIELD, PRIORITY_FIELD, TEMPLATE_TYPE_FIELD, TEMPLATE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String farmId;

    private final String queueId;

    private final String queueEnvironmentId;

    private final Integer priority;

    private final String templateType;

    private final String template;

    private UpdateQueueEnvironmentRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.queueEnvironmentId = builder.queueEnvironmentId;
        this.priority = builder.priority;
        this.templateType = builder.templateType;
        this.template = builder.template;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The farm ID of the queue environment to update.
     * </p>
     * 
     * @return The farm ID of the queue environment to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The queue ID of the queue environment to update.
     * </p>
     * 
     * @return The queue ID of the queue environment to update.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The queue environment ID to update.
     * </p>
     * 
     * @return The queue environment ID to update.
     */
    public final String queueEnvironmentId() {
        return queueEnvironmentId;
    }

    /**
     * <p>
     * The priority to update.
     * </p>
     * 
     * @return The priority to update.
     */
    public final Integer priority() {
        return priority;
    }

    /**
     * <p>
     * The template type to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link EnvironmentTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The template type to update.
     * @see EnvironmentTemplateType
     */
    public final EnvironmentTemplateType templateType() {
        return EnvironmentTemplateType.fromValue(templateType);
    }

    /**
     * <p>
     * The template type to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #templateType} will
     * return {@link EnvironmentTemplateType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #templateTypeAsString}.
     * </p>
     * 
     * @return The template type to update.
     * @see EnvironmentTemplateType
     */
    public final String templateTypeAsString() {
        return templateType;
    }

    /**
     * <p>
     * The template to update.
     * </p>
     * 
     * @return The template to update.
     */
    public final String template() {
        return template;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(queueEnvironmentId());
        hashCode = 31 * hashCode + Objects.hashCode(priority());
        hashCode = 31 * hashCode + Objects.hashCode(templateTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateQueueEnvironmentRequest)) {
            return false;
        }
        UpdateQueueEnvironmentRequest other = (UpdateQueueEnvironmentRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(queueEnvironmentId(), other.queueEnvironmentId())
                && Objects.equals(priority(), other.priority())
                && Objects.equals(templateTypeAsString(), other.templateTypeAsString())
                && Objects.equals(template(), other.template());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateQueueEnvironmentRequest").add("ClientToken", clientToken()).add("FarmId", farmId())
                .add("QueueId", queueId()).add("QueueEnvironmentId", queueEnvironmentId()).add("Priority", priority())
                .add("TemplateType", templateTypeAsString())
                .add("Template", template() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "queueEnvironmentId":
            return Optional.ofNullable(clazz.cast(queueEnvironmentId()));
        case "priority":
            return Optional.ofNullable(clazz.cast(priority()));
        case "templateType":
            return Optional.ofNullable(clazz.cast(templateTypeAsString()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("queueEnvironmentId", QUEUE_ENVIRONMENT_ID_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("templateType", TEMPLATE_TYPE_FIELD);
        map.put("template", TEMPLATE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateQueueEnvironmentRequest, T> g) {
        return obj -> g.apply((UpdateQueueEnvironmentRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateQueueEnvironmentRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The farm ID of the queue environment to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the queue environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The queue ID of the queue environment to update.
         * </p>
         * 
         * @param queueId
         *        The queue ID of the queue environment to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The queue environment ID to update.
         * </p>
         * 
         * @param queueEnvironmentId
         *        The queue environment ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueEnvironmentId(String queueEnvironmentId);

        /**
         * <p>
         * The priority to update.
         * </p>
         * 
         * @param priority
         *        The priority to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder priority(Integer priority);

        /**
         * <p>
         * The template type to update.
         * </p>
         * 
         * @param templateType
         *        The template type to update.
         * @see EnvironmentTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentTemplateType
         */
        Builder templateType(String templateType);

        /**
         * <p>
         * The template type to update.
         * </p>
         * 
         * @param templateType
         *        The template type to update.
         * @see EnvironmentTemplateType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see EnvironmentTemplateType
         */
        Builder templateType(EnvironmentTemplateType templateType);

        /**
         * <p>
         * The template to update.
         * </p>
         * 
         * @param template
         *        The template to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(String template);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String farmId;

        private String queueId;

        private String queueEnvironmentId;

        private Integer priority;

        private String templateType;

        private String template;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateQueueEnvironmentRequest model) {
            super(model);
            clientToken(model.clientToken);
            farmId(model.farmId);
            queueId(model.queueId);
            queueEnvironmentId(model.queueEnvironmentId);
            priority(model.priority);
            templateType(model.templateType);
            template(model.template);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getQueueEnvironmentId() {
            return queueEnvironmentId;
        }

        public final void setQueueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
        }

        @Override
        public final Builder queueEnvironmentId(String queueEnvironmentId) {
            this.queueEnvironmentId = queueEnvironmentId;
            return this;
        }

        public final Integer getPriority() {
            return priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final String getTemplateType() {
            return templateType;
        }

        public final void setTemplateType(String templateType) {
            this.templateType = templateType;
        }

        @Override
        public final Builder templateType(String templateType) {
            this.templateType = templateType;
            return this;
        }

        @Override
        public final Builder templateType(EnvironmentTemplateType templateType) {
            this.templateType(templateType == null ? null : templateType.toString());
            return this;
        }

        public final String getTemplate() {
            return template;
        }

        public final void setTemplate(String template) {
            this.template = template;
        }

        @Override
        public final Builder template(String template) {
            this.template = template;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateQueueEnvironmentRequest build() {
            return new UpdateQueueEnvironmentRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
