/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkerResponse extends DeadlineResponse implements
        ToCopyableBuilder<UpdateWorkerResponse.Builder, UpdateWorkerResponse> {
    private static final SdkField<LogConfiguration> LOG_FIELD = SdkField.<LogConfiguration> builder(MarshallingType.SDK_POJO)
            .memberName("log").getter(getter(UpdateWorkerResponse::log)).setter(setter(Builder::log))
            .constructor(LogConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LOG_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final LogConfiguration log;

    private UpdateWorkerResponse(BuilderImpl builder) {
        super(builder);
        this.log = builder.log;
    }

    /**
     * <p>
     * The worker log to update.
     * </p>
     * 
     * @return The worker log to update.
     */
    public final LogConfiguration log() {
        return log;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(log());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerResponse)) {
            return false;
        }
        UpdateWorkerResponse other = (UpdateWorkerResponse) obj;
        return Objects.equals(log(), other.log());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkerResponse").add("Log", log()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "log":
            return Optional.ofNullable(clazz.cast(log()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("log", LOG_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerResponse, T> g) {
        return obj -> g.apply((UpdateWorkerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkerResponse> {
        /**
         * <p>
         * The worker log to update.
         * </p>
         * 
         * @param log
         *        The worker log to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder log(LogConfiguration log);

        /**
         * <p>
         * The worker log to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link LogConfiguration.Builder} avoiding the
         * need to create one manually via {@link LogConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link LogConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #log(LogConfiguration)}.
         * 
         * @param log
         *        a consumer that will call methods on {@link LogConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #log(LogConfiguration)
         */
        default Builder log(Consumer<LogConfiguration.Builder> log) {
            return log(LogConfiguration.builder().applyMutation(log).build());
        }
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private LogConfiguration log;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerResponse model) {
            super(model);
            log(model.log);
        }

        public final LogConfiguration.Builder getLog() {
            return log != null ? log.toBuilder() : null;
        }

        public final void setLog(LogConfiguration.BuilderImpl log) {
            this.log = log != null ? log.build() : null;
        }

        @Override
        public final Builder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        @Override
        public UpdateWorkerResponse build() {
            return new UpdateWorkerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
