/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkerScheduleResponse extends DeadlineResponse implements
        ToCopyableBuilder<UpdateWorkerScheduleResponse.Builder, UpdateWorkerScheduleResponse> {
    private static final SdkField<Map<String, AssignedSession>> ASSIGNED_SESSIONS_FIELD = SdkField
            .<Map<String, AssignedSession>> builder(MarshallingType.MAP)
            .memberName("assignedSessions")
            .getter(getter(UpdateWorkerScheduleResponse::assignedSessions))
            .setter(setter(Builder::assignedSessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("assignedSessions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<AssignedSession> builder(MarshallingType.SDK_POJO)
                                            .constructor(AssignedSession::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final SdkField<Map<String, List<String>>> CANCEL_SESSION_ACTIONS_FIELD = SdkField
            .<Map<String, List<String>>> builder(MarshallingType.MAP)
            .memberName("cancelSessionActions")
            .getter(getter(UpdateWorkerScheduleResponse::cancelSessionActions))
            .setter(setter(Builder::cancelSessionActions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cancelSessionActions").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<List<String>> builder(MarshallingType.LIST)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build(),
                                                    ListTrait
                                                            .builder()
                                                            .memberLocationName(null)
                                                            .memberFieldInfo(
                                                                    SdkField.<String> builder(MarshallingType.STRING)
                                                                            .traits(LocationTrait.builder()
                                                                                    .location(MarshallLocation.PAYLOAD)
                                                                                    .locationName("member").build()).build())
                                                            .build()).build()).build()).build();

    private static final SdkField<String> DESIRED_WORKER_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("desiredWorkerStatus").getter(getter(UpdateWorkerScheduleResponse::desiredWorkerStatusAsString))
            .setter(setter(Builder::desiredWorkerStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("desiredWorkerStatus").build())
            .build();

    private static final SdkField<Integer> UPDATE_INTERVAL_SECONDS_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("updateIntervalSeconds").getter(getter(UpdateWorkerScheduleResponse::updateIntervalSeconds))
            .setter(setter(Builder::updateIntervalSeconds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updateIntervalSeconds").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ASSIGNED_SESSIONS_FIELD,
            CANCEL_SESSION_ACTIONS_FIELD, DESIRED_WORKER_STATUS_FIELD, UPDATE_INTERVAL_SECONDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final Map<String, AssignedSession> assignedSessions;

    private final Map<String, List<String>> cancelSessionActions;

    private final String desiredWorkerStatus;

    private final Integer updateIntervalSeconds;

    private UpdateWorkerScheduleResponse(BuilderImpl builder) {
        super(builder);
        this.assignedSessions = builder.assignedSessions;
        this.cancelSessionActions = builder.cancelSessionActions;
        this.desiredWorkerStatus = builder.desiredWorkerStatus;
        this.updateIntervalSeconds = builder.updateIntervalSeconds;
    }

    /**
     * For responses, this returns true if the service returned a value for the AssignedSessions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasAssignedSessions() {
        return assignedSessions != null && !(assignedSessions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The assigned sessions to update.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAssignedSessions} method.
     * </p>
     * 
     * @return The assigned sessions to update.
     */
    public final Map<String, AssignedSession> assignedSessions() {
        return assignedSessions;
    }

    /**
     * For responses, this returns true if the service returned a value for the CancelSessionActions property. This DOES
     * NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasCancelSessionActions() {
        return cancelSessionActions != null && !(cancelSessionActions instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * The session actions associated with the worker schedule to cancel.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasCancelSessionActions} method.
     * </p>
     * 
     * @return The session actions associated with the worker schedule to cancel.
     */
    public final Map<String, List<String>> cancelSessionActions() {
        return cancelSessionActions;
    }

    /**
     * <p>
     * The status to update the worker to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #desiredWorkerStatus} will return {@link DesiredWorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #desiredWorkerStatusAsString}.
     * </p>
     * 
     * @return The status to update the worker to.
     * @see DesiredWorkerStatus
     */
    public final DesiredWorkerStatus desiredWorkerStatus() {
        return DesiredWorkerStatus.fromValue(desiredWorkerStatus);
    }

    /**
     * <p>
     * The status to update the worker to.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #desiredWorkerStatus} will return {@link DesiredWorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value
     * returned by the service is available from {@link #desiredWorkerStatusAsString}.
     * </p>
     * 
     * @return The status to update the worker to.
     * @see DesiredWorkerStatus
     */
    public final String desiredWorkerStatusAsString() {
        return desiredWorkerStatus;
    }

    /**
     * <p>
     * Updates the time interval (in seconds) for the schedule.
     * </p>
     * 
     * @return Updates the time interval (in seconds) for the schedule.
     */
    public final Integer updateIntervalSeconds() {
        return updateIntervalSeconds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasAssignedSessions() ? assignedSessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasCancelSessionActions() ? cancelSessionActions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(desiredWorkerStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(updateIntervalSeconds());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerScheduleResponse)) {
            return false;
        }
        UpdateWorkerScheduleResponse other = (UpdateWorkerScheduleResponse) obj;
        return hasAssignedSessions() == other.hasAssignedSessions()
                && Objects.equals(assignedSessions(), other.assignedSessions())
                && hasCancelSessionActions() == other.hasCancelSessionActions()
                && Objects.equals(cancelSessionActions(), other.cancelSessionActions())
                && Objects.equals(desiredWorkerStatusAsString(), other.desiredWorkerStatusAsString())
                && Objects.equals(updateIntervalSeconds(), other.updateIntervalSeconds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkerScheduleResponse")
                .add("AssignedSessions", hasAssignedSessions() ? assignedSessions() : null)
                .add("CancelSessionActions", hasCancelSessionActions() ? cancelSessionActions() : null)
                .add("DesiredWorkerStatus", desiredWorkerStatusAsString()).add("UpdateIntervalSeconds", updateIntervalSeconds())
                .build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "assignedSessions":
            return Optional.ofNullable(clazz.cast(assignedSessions()));
        case "cancelSessionActions":
            return Optional.ofNullable(clazz.cast(cancelSessionActions()));
        case "desiredWorkerStatus":
            return Optional.ofNullable(clazz.cast(desiredWorkerStatusAsString()));
        case "updateIntervalSeconds":
            return Optional.ofNullable(clazz.cast(updateIntervalSeconds()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("assignedSessions", ASSIGNED_SESSIONS_FIELD);
        map.put("cancelSessionActions", CANCEL_SESSION_ACTIONS_FIELD);
        map.put("desiredWorkerStatus", DESIRED_WORKER_STATUS_FIELD);
        map.put("updateIntervalSeconds", UPDATE_INTERVAL_SECONDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerScheduleResponse, T> g) {
        return obj -> g.apply((UpdateWorkerScheduleResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkerScheduleResponse> {
        /**
         * <p>
         * The assigned sessions to update.
         * </p>
         * 
         * @param assignedSessions
         *        The assigned sessions to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder assignedSessions(Map<String, AssignedSession> assignedSessions);

        /**
         * <p>
         * The session actions associated with the worker schedule to cancel.
         * </p>
         * 
         * @param cancelSessionActions
         *        The session actions associated with the worker schedule to cancel.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder cancelSessionActions(Map<String, ? extends Collection<String>> cancelSessionActions);

        /**
         * <p>
         * The status to update the worker to.
         * </p>
         * 
         * @param desiredWorkerStatus
         *        The status to update the worker to.
         * @see DesiredWorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredWorkerStatus
         */
        Builder desiredWorkerStatus(String desiredWorkerStatus);

        /**
         * <p>
         * The status to update the worker to.
         * </p>
         * 
         * @param desiredWorkerStatus
         *        The status to update the worker to.
         * @see DesiredWorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see DesiredWorkerStatus
         */
        Builder desiredWorkerStatus(DesiredWorkerStatus desiredWorkerStatus);

        /**
         * <p>
         * Updates the time interval (in seconds) for the schedule.
         * </p>
         * 
         * @param updateIntervalSeconds
         *        Updates the time interval (in seconds) for the schedule.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updateIntervalSeconds(Integer updateIntervalSeconds);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private Map<String, AssignedSession> assignedSessions = DefaultSdkAutoConstructMap.getInstance();

        private Map<String, List<String>> cancelSessionActions = DefaultSdkAutoConstructMap.getInstance();

        private String desiredWorkerStatus;

        private Integer updateIntervalSeconds;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerScheduleResponse model) {
            super(model);
            assignedSessions(model.assignedSessions);
            cancelSessionActions(model.cancelSessionActions);
            desiredWorkerStatus(model.desiredWorkerStatus);
            updateIntervalSeconds(model.updateIntervalSeconds);
        }

        public final Map<String, AssignedSession.Builder> getAssignedSessions() {
            Map<String, AssignedSession.Builder> result = AssignedSessionsCopier.copyToBuilder(this.assignedSessions);
            if (result instanceof SdkAutoConstructMap) {
                return null;
            }
            return result;
        }

        public final void setAssignedSessions(Map<String, AssignedSession.BuilderImpl> assignedSessions) {
            this.assignedSessions = AssignedSessionsCopier.copyFromBuilder(assignedSessions);
        }

        @Override
        public final Builder assignedSessions(Map<String, AssignedSession> assignedSessions) {
            this.assignedSessions = AssignedSessionsCopier.copy(assignedSessions);
            return this;
        }

        public final Map<String, ? extends Collection<String>> getCancelSessionActions() {
            if (cancelSessionActions instanceof SdkAutoConstructMap) {
                return null;
            }
            return cancelSessionActions;
        }

        public final void setCancelSessionActions(Map<String, ? extends Collection<String>> cancelSessionActions) {
            this.cancelSessionActions = CancelSessionActionsCopier.copy(cancelSessionActions);
        }

        @Override
        public final Builder cancelSessionActions(Map<String, ? extends Collection<String>> cancelSessionActions) {
            this.cancelSessionActions = CancelSessionActionsCopier.copy(cancelSessionActions);
            return this;
        }

        public final String getDesiredWorkerStatus() {
            return desiredWorkerStatus;
        }

        public final void setDesiredWorkerStatus(String desiredWorkerStatus) {
            this.desiredWorkerStatus = desiredWorkerStatus;
        }

        @Override
        public final Builder desiredWorkerStatus(String desiredWorkerStatus) {
            this.desiredWorkerStatus = desiredWorkerStatus;
            return this;
        }

        @Override
        public final Builder desiredWorkerStatus(DesiredWorkerStatus desiredWorkerStatus) {
            this.desiredWorkerStatus(desiredWorkerStatus == null ? null : desiredWorkerStatus.toString());
            return this;
        }

        public final Integer getUpdateIntervalSeconds() {
            return updateIntervalSeconds;
        }

        public final void setUpdateIntervalSeconds(Integer updateIntervalSeconds) {
            this.updateIntervalSeconds = updateIntervalSeconds;
        }

        @Override
        public final Builder updateIntervalSeconds(Integer updateIntervalSeconds) {
            this.updateIntervalSeconds = updateIntervalSeconds;
            return this;
        }

        @Override
        public UpdateWorkerScheduleResponse build() {
            return new UpdateWorkerScheduleResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
