/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Summarizes the session for a particular worker.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class WorkerSessionSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<WorkerSessionSummary.Builder, WorkerSessionSummary> {
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("sessionId").getter(getter(WorkerSessionSummary::sessionId)).setter(setter(Builder::sessionId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessionId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(WorkerSessionSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(WorkerSessionSummary::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<Instant> STARTED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startedAt")
            .getter(getter(WorkerSessionSummary::startedAt))
            .setter(setter(Builder::startedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("lifecycleStatus").getter(getter(WorkerSessionSummary::lifecycleStatusAsString))
            .setter(setter(Builder::lifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()).build();

    private static final SdkField<Instant> ENDED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endedAt")
            .getter(getter(WorkerSessionSummary::endedAt))
            .setter(setter(Builder::endedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TARGET_LIFECYCLE_STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("targetLifecycleStatus").getter(getter(WorkerSessionSummary::targetLifecycleStatusAsString))
            .setter(setter(Builder::targetLifecycleStatus))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetLifecycleStatus").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(SESSION_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, STARTED_AT_FIELD, LIFECYCLE_STATUS_FIELD, ENDED_AT_FIELD,
                    TARGET_LIFECYCLE_STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String sessionId;

    private final String queueId;

    private final String jobId;

    private final Instant startedAt;

    private final String lifecycleStatus;

    private final Instant endedAt;

    private final String targetLifecycleStatus;

    private WorkerSessionSummary(BuilderImpl builder) {
        this.sessionId = builder.sessionId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.startedAt = builder.startedAt;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.endedAt = builder.endedAt;
        this.targetLifecycleStatus = builder.targetLifecycleStatus;
    }

    /**
     * <p>
     * The session ID for the session action.
     * </p>
     * 
     * @return The session ID for the session action.
     */
    public final String sessionId() {
        return sessionId;
    }

    /**
     * <p>
     * The queue ID for the queue associated to the worker.
     * </p>
     * 
     * @return The queue ID for the queue associated to the worker.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The job ID for the job associated with the worker's session.
     * </p>
     * 
     * @return The job ID for the job associated with the worker's session.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The date and time the resource started running.
     * </p>
     * 
     * @return The date and time the resource started running.
     */
    public final Instant startedAt() {
        return startedAt;
    }

    /**
     * <p>
     * The life cycle status for the worker's session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link SessionLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status for the worker's session.
     * @see SessionLifecycleStatus
     */
    public final SessionLifecycleStatus lifecycleStatus() {
        return SessionLifecycleStatus.fromValue(lifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status for the worker's session.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #lifecycleStatus}
     * will return {@link SessionLifecycleStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #lifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status for the worker's session.
     * @see SessionLifecycleStatus
     */
    public final String lifecycleStatusAsString() {
        return lifecycleStatus;
    }

    /**
     * <p>
     * The date and time the resource ended running.
     * </p>
     * 
     * @return The date and time the resource ended running.
     */
    public final Instant endedAt() {
        return endedAt;
    }

    /**
     * <p>
     * The life cycle status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status
     * @see SessionLifecycleTargetStatus
     */
    public final SessionLifecycleTargetStatus targetLifecycleStatus() {
        return SessionLifecycleTargetStatus.fromValue(targetLifecycleStatus);
    }

    /**
     * <p>
     * The life cycle status
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version,
     * {@link #targetLifecycleStatus} will return {@link SessionLifecycleTargetStatus#UNKNOWN_TO_SDK_VERSION}. The raw
     * value returned by the service is available from {@link #targetLifecycleStatusAsString}.
     * </p>
     * 
     * @return The life cycle status
     * @see SessionLifecycleTargetStatus
     */
    public final String targetLifecycleStatusAsString() {
        return targetLifecycleStatus;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(sessionId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(startedAt());
        hashCode = 31 * hashCode + Objects.hashCode(lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(endedAt());
        hashCode = 31 * hashCode + Objects.hashCode(targetLifecycleStatusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerSessionSummary)) {
            return false;
        }
        WorkerSessionSummary other = (WorkerSessionSummary) obj;
        return Objects.equals(sessionId(), other.sessionId()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(jobId(), other.jobId()) && Objects.equals(startedAt(), other.startedAt())
                && Objects.equals(lifecycleStatusAsString(), other.lifecycleStatusAsString())
                && Objects.equals(endedAt(), other.endedAt())
                && Objects.equals(targetLifecycleStatusAsString(), other.targetLifecycleStatusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("WorkerSessionSummary").add("SessionId", sessionId()).add("QueueId", queueId())
                .add("JobId", jobId()).add("StartedAt", startedAt()).add("LifecycleStatus", lifecycleStatusAsString())
                .add("EndedAt", endedAt()).add("TargetLifecycleStatus", targetLifecycleStatusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessionId":
            return Optional.ofNullable(clazz.cast(sessionId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "startedAt":
            return Optional.ofNullable(clazz.cast(startedAt()));
        case "lifecycleStatus":
            return Optional.ofNullable(clazz.cast(lifecycleStatusAsString()));
        case "endedAt":
            return Optional.ofNullable(clazz.cast(endedAt()));
        case "targetLifecycleStatus":
            return Optional.ofNullable(clazz.cast(targetLifecycleStatusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessionId", SESSION_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("startedAt", STARTED_AT_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("endedAt", ENDED_AT_FIELD);
        map.put("targetLifecycleStatus", TARGET_LIFECYCLE_STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerSessionSummary, T> g) {
        return obj -> g.apply((WorkerSessionSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    public interface Builder extends SdkPojo, CopyableBuilder<Builder, WorkerSessionSummary> {
        /**
         * <p>
         * The session ID for the session action.
         * </p>
         * 
         * @param sessionId
         *        The session ID for the session action.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessionId(String sessionId);

        /**
         * <p>
         * The queue ID for the queue associated to the worker.
         * </p>
         * 
         * @param queueId
         *        The queue ID for the queue associated to the worker.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The job ID for the job associated with the worker's session.
         * </p>
         * 
         * @param jobId
         *        The job ID for the job associated with the worker's session.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The date and time the resource started running.
         * </p>
         * 
         * @param startedAt
         *        The date and time the resource started running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startedAt(Instant startedAt);

        /**
         * <p>
         * The life cycle status for the worker's session.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status for the worker's session.
         * @see SessionLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleStatus
         */
        Builder lifecycleStatus(String lifecycleStatus);

        /**
         * <p>
         * The life cycle status for the worker's session.
         * </p>
         * 
         * @param lifecycleStatus
         *        The life cycle status for the worker's session.
         * @see SessionLifecycleStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleStatus
         */
        Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus);

        /**
         * <p>
         * The date and time the resource ended running.
         * </p>
         * 
         * @param endedAt
         *        The date and time the resource ended running.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endedAt(Instant endedAt);

        /**
         * <p>
         * The life cycle status
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(String targetLifecycleStatus);

        /**
         * <p>
         * The life cycle status
         * </p>
         * 
         * @param targetLifecycleStatus
         *        The life cycle status
         * @see SessionLifecycleTargetStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see SessionLifecycleTargetStatus
         */
        Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus);
    }

    static final class BuilderImpl implements Builder {
        private String sessionId;

        private String queueId;

        private String jobId;

        private Instant startedAt;

        private String lifecycleStatus;

        private Instant endedAt;

        private String targetLifecycleStatus;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerSessionSummary model) {
            sessionId(model.sessionId);
            queueId(model.queueId);
            jobId(model.jobId);
            startedAt(model.startedAt);
            lifecycleStatus(model.lifecycleStatus);
            endedAt(model.endedAt);
            targetLifecycleStatus(model.targetLifecycleStatus);
        }

        public final String getSessionId() {
            return sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final Instant getStartedAt() {
            return startedAt;
        }

        public final void setStartedAt(Instant startedAt) {
            this.startedAt = startedAt;
        }

        @Override
        public final Builder startedAt(Instant startedAt) {
            this.startedAt = startedAt;
            return this;
        }

        public final String getLifecycleStatus() {
            return lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(SessionLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final Instant getEndedAt() {
            return endedAt;
        }

        public final void setEndedAt(Instant endedAt) {
            this.endedAt = endedAt;
        }

        @Override
        public final Builder endedAt(Instant endedAt) {
            this.endedAt = endedAt;
            return this;
        }

        public final String getTargetLifecycleStatus() {
            return targetLifecycleStatus;
        }

        public final void setTargetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
        }

        @Override
        public final Builder targetLifecycleStatus(String targetLifecycleStatus) {
            this.targetLifecycleStatus = targetLifecycleStatus;
            return this;
        }

        @Override
        public final Builder targetLifecycleStatus(SessionLifecycleTargetStatus targetLifecycleStatus) {
            this.targetLifecycleStatus(targetLifecycleStatus == null ? null : targetLifecycleStatus.toString());
            return this;
        }

        @Override
        public WorkerSessionSummary build() {
            return new WorkerSessionSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
