/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.deadline.model.AcceleratorCapabilities;
import software.amazon.awssdk.services.deadline.model.CpuArchitectureType;
import software.amazon.awssdk.services.deadline.model.CustomFleetAmountCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.CustomFleetAttributeCapabilitiesCopier;
import software.amazon.awssdk.services.deadline.model.Ec2EbsVolume;
import software.amazon.awssdk.services.deadline.model.FleetAmountCapability;
import software.amazon.awssdk.services.deadline.model.FleetAttributeCapability;
import software.amazon.awssdk.services.deadline.model.InstanceTypesCopier;
import software.amazon.awssdk.services.deadline.model.MemoryMiBRange;
import software.amazon.awssdk.services.deadline.model.ServiceManagedFleetOperatingSystemFamily;
import software.amazon.awssdk.services.deadline.model.VCpuCountRange;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceManagedEc2InstanceCapabilities
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceManagedEc2InstanceCapabilities> {
    private static final SdkField<VCpuCountRange> V_CPU_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("vCpuCount").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::vCpuCount)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::vCpuCount)).constructor(VCpuCountRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vCpuCount").build()}).build();
    private static final SdkField<MemoryMiBRange> MEMORY_MIB_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("memoryMiB").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::memoryMiB)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::memoryMiB)).constructor(MemoryMiBRange::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("memoryMiB").build()}).build();
    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("osFamily").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::osFamilyAsString)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::osFamily)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()}).build();
    private static final SdkField<String> CPU_ARCHITECTURE_TYPE_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("cpuArchitectureType").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::cpuArchitectureTypeAsString)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::cpuArchitectureType)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("cpuArchitectureType").build()}).build();
    private static final SdkField<Ec2EbsVolume> ROOT_EBS_VOLUME_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("rootEbsVolume").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::rootEbsVolume)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::rootEbsVolume)).constructor(Ec2EbsVolume::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("rootEbsVolume").build()}).build();
    private static final SdkField<AcceleratorCapabilities> ACCELERATOR_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("acceleratorCapabilities").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::acceleratorCapabilities)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::acceleratorCapabilities)).constructor(AcceleratorCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("acceleratorCapabilities").build()}).build();
    private static final SdkField<List<String>> ALLOWED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("allowedInstanceTypes").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::allowedInstanceTypes)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::allowedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("allowedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<String>> EXCLUDED_INSTANCE_TYPES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("excludedInstanceTypes").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::excludedInstanceTypes)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::excludedInstanceTypes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("excludedInstanceTypes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.STRING).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FleetAmountCapability>> CUSTOM_AMOUNTS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customAmounts").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::customAmounts)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::customAmounts)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAmounts").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAmountCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final SdkField<List<FleetAttributeCapability>> CUSTOM_ATTRIBUTES_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("customAttributes").getter(ServiceManagedEc2InstanceCapabilities.getter(ServiceManagedEc2InstanceCapabilities::customAttributes)).setter(ServiceManagedEc2InstanceCapabilities.setter(Builder::customAttributes)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("customAttributes").build(), ListTrait.builder().memberLocationName(null).memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(FleetAttributeCapability::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("member").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(V_CPU_COUNT_FIELD, MEMORY_MIB_FIELD, OS_FAMILY_FIELD, CPU_ARCHITECTURE_TYPE_FIELD, ROOT_EBS_VOLUME_FIELD, ACCELERATOR_CAPABILITIES_FIELD, ALLOWED_INSTANCE_TYPES_FIELD, EXCLUDED_INSTANCE_TYPES_FIELD, CUSTOM_AMOUNTS_FIELD, CUSTOM_ATTRIBUTES_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceManagedEc2InstanceCapabilities.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final VCpuCountRange vCpuCount;
    private final MemoryMiBRange memoryMiB;
    private final String osFamily;
    private final String cpuArchitectureType;
    private final Ec2EbsVolume rootEbsVolume;
    private final AcceleratorCapabilities acceleratorCapabilities;
    private final List<String> allowedInstanceTypes;
    private final List<String> excludedInstanceTypes;
    private final List<FleetAmountCapability> customAmounts;
    private final List<FleetAttributeCapability> customAttributes;

    private ServiceManagedEc2InstanceCapabilities(BuilderImpl builder) {
        this.vCpuCount = builder.vCpuCount;
        this.memoryMiB = builder.memoryMiB;
        this.osFamily = builder.osFamily;
        this.cpuArchitectureType = builder.cpuArchitectureType;
        this.rootEbsVolume = builder.rootEbsVolume;
        this.acceleratorCapabilities = builder.acceleratorCapabilities;
        this.allowedInstanceTypes = builder.allowedInstanceTypes;
        this.excludedInstanceTypes = builder.excludedInstanceTypes;
        this.customAmounts = builder.customAmounts;
        this.customAttributes = builder.customAttributes;
    }

    public final VCpuCountRange vCpuCount() {
        return this.vCpuCount;
    }

    public final MemoryMiBRange memoryMiB() {
        return this.memoryMiB;
    }

    public final ServiceManagedFleetOperatingSystemFamily osFamily() {
        return ServiceManagedFleetOperatingSystemFamily.fromValue(this.osFamily);
    }

    public final String osFamilyAsString() {
        return this.osFamily;
    }

    public final CpuArchitectureType cpuArchitectureType() {
        return CpuArchitectureType.fromValue(this.cpuArchitectureType);
    }

    public final String cpuArchitectureTypeAsString() {
        return this.cpuArchitectureType;
    }

    public final Ec2EbsVolume rootEbsVolume() {
        return this.rootEbsVolume;
    }

    public final AcceleratorCapabilities acceleratorCapabilities() {
        return this.acceleratorCapabilities;
    }

    public final boolean hasAllowedInstanceTypes() {
        return this.allowedInstanceTypes != null && !(this.allowedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> allowedInstanceTypes() {
        return this.allowedInstanceTypes;
    }

    public final boolean hasExcludedInstanceTypes() {
        return this.excludedInstanceTypes != null && !(this.excludedInstanceTypes instanceof SdkAutoConstructList);
    }

    public final List<String> excludedInstanceTypes() {
        return this.excludedInstanceTypes;
    }

    public final boolean hasCustomAmounts() {
        return this.customAmounts != null && !(this.customAmounts instanceof SdkAutoConstructList);
    }

    public final List<FleetAmountCapability> customAmounts() {
        return this.customAmounts;
    }

    public final boolean hasCustomAttributes() {
        return this.customAttributes != null && !(this.customAttributes instanceof SdkAutoConstructList);
    }

    public final List<FleetAttributeCapability> customAttributes() {
        return this.customAttributes;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.vCpuCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.memoryMiB());
        hashCode = 31 * hashCode + Objects.hashCode(this.osFamilyAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.cpuArchitectureTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.rootEbsVolume());
        hashCode = 31 * hashCode + Objects.hashCode(this.acceleratorCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasAllowedInstanceTypes() ? this.allowedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAmounts() ? this.customAmounts() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.hasCustomAttributes() ? this.customAttributes() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEc2InstanceCapabilities)) {
            return false;
        }
        ServiceManagedEc2InstanceCapabilities other = (ServiceManagedEc2InstanceCapabilities)obj;
        return Objects.equals(this.vCpuCount(), other.vCpuCount()) && Objects.equals(this.memoryMiB(), other.memoryMiB()) && Objects.equals(this.osFamilyAsString(), other.osFamilyAsString()) && Objects.equals(this.cpuArchitectureTypeAsString(), other.cpuArchitectureTypeAsString()) && Objects.equals(this.rootEbsVolume(), other.rootEbsVolume()) && Objects.equals(this.acceleratorCapabilities(), other.acceleratorCapabilities()) && this.hasAllowedInstanceTypes() == other.hasAllowedInstanceTypes() && Objects.equals(this.allowedInstanceTypes(), other.allowedInstanceTypes()) && this.hasExcludedInstanceTypes() == other.hasExcludedInstanceTypes() && Objects.equals(this.excludedInstanceTypes(), other.excludedInstanceTypes()) && this.hasCustomAmounts() == other.hasCustomAmounts() && Objects.equals(this.customAmounts(), other.customAmounts()) && this.hasCustomAttributes() == other.hasCustomAttributes() && Objects.equals(this.customAttributes(), other.customAttributes());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceManagedEc2InstanceCapabilities").add("VCpuCount", (Object)this.vCpuCount()).add("MemoryMiB", (Object)this.memoryMiB()).add("OsFamily", (Object)this.osFamilyAsString()).add("CpuArchitectureType", (Object)this.cpuArchitectureTypeAsString()).add("RootEbsVolume", (Object)this.rootEbsVolume()).add("AcceleratorCapabilities", (Object)this.acceleratorCapabilities()).add("AllowedInstanceTypes", this.hasAllowedInstanceTypes() ? this.allowedInstanceTypes() : null).add("ExcludedInstanceTypes", this.hasExcludedInstanceTypes() ? this.excludedInstanceTypes() : null).add("CustomAmounts", this.hasCustomAmounts() ? this.customAmounts() : null).add("CustomAttributes", this.hasCustomAttributes() ? this.customAttributes() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "vCpuCount": {
                return Optional.ofNullable(clazz.cast(this.vCpuCount()));
            }
            case "memoryMiB": {
                return Optional.ofNullable(clazz.cast(this.memoryMiB()));
            }
            case "osFamily": {
                return Optional.ofNullable(clazz.cast(this.osFamilyAsString()));
            }
            case "cpuArchitectureType": {
                return Optional.ofNullable(clazz.cast(this.cpuArchitectureTypeAsString()));
            }
            case "rootEbsVolume": {
                return Optional.ofNullable(clazz.cast(this.rootEbsVolume()));
            }
            case "acceleratorCapabilities": {
                return Optional.ofNullable(clazz.cast(this.acceleratorCapabilities()));
            }
            case "allowedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.allowedInstanceTypes()));
            }
            case "excludedInstanceTypes": {
                return Optional.ofNullable(clazz.cast(this.excludedInstanceTypes()));
            }
            case "customAmounts": {
                return Optional.ofNullable(clazz.cast(this.customAmounts()));
            }
            case "customAttributes": {
                return Optional.ofNullable(clazz.cast(this.customAttributes()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("vCpuCount", V_CPU_COUNT_FIELD);
        map.put("memoryMiB", MEMORY_MIB_FIELD);
        map.put("osFamily", OS_FAMILY_FIELD);
        map.put("cpuArchitectureType", CPU_ARCHITECTURE_TYPE_FIELD);
        map.put("rootEbsVolume", ROOT_EBS_VOLUME_FIELD);
        map.put("acceleratorCapabilities", ACCELERATOR_CAPABILITIES_FIELD);
        map.put("allowedInstanceTypes", ALLOWED_INSTANCE_TYPES_FIELD);
        map.put("excludedInstanceTypes", EXCLUDED_INSTANCE_TYPES_FIELD);
        map.put("customAmounts", CUSTOM_AMOUNTS_FIELD);
        map.put("customAttributes", CUSTOM_ATTRIBUTES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceManagedEc2InstanceCapabilities, T> g) {
        return obj -> g.apply((ServiceManagedEc2InstanceCapabilities)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private VCpuCountRange vCpuCount;
        private MemoryMiBRange memoryMiB;
        private String osFamily;
        private String cpuArchitectureType;
        private Ec2EbsVolume rootEbsVolume;
        private AcceleratorCapabilities acceleratorCapabilities;
        private List<String> allowedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<String> excludedInstanceTypes = DefaultSdkAutoConstructList.getInstance();
        private List<FleetAmountCapability> customAmounts = DefaultSdkAutoConstructList.getInstance();
        private List<FleetAttributeCapability> customAttributes = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceManagedEc2InstanceCapabilities model) {
            this.vCpuCount(model.vCpuCount);
            this.memoryMiB(model.memoryMiB);
            this.osFamily(model.osFamily);
            this.cpuArchitectureType(model.cpuArchitectureType);
            this.rootEbsVolume(model.rootEbsVolume);
            this.acceleratorCapabilities(model.acceleratorCapabilities);
            this.allowedInstanceTypes(model.allowedInstanceTypes);
            this.excludedInstanceTypes(model.excludedInstanceTypes);
            this.customAmounts(model.customAmounts);
            this.customAttributes(model.customAttributes);
        }

        public final VCpuCountRange.Builder getVCpuCount() {
            return this.vCpuCount != null ? this.vCpuCount.toBuilder() : null;
        }

        public final void setVCpuCount(VCpuCountRange.BuilderImpl vCpuCount) {
            this.vCpuCount = vCpuCount != null ? vCpuCount.build() : null;
        }

        @Override
        public final Builder vCpuCount(VCpuCountRange vCpuCount) {
            this.vCpuCount = vCpuCount;
            return this;
        }

        public final MemoryMiBRange.Builder getMemoryMiB() {
            return this.memoryMiB != null ? this.memoryMiB.toBuilder() : null;
        }

        public final void setMemoryMiB(MemoryMiBRange.BuilderImpl memoryMiB) {
            this.memoryMiB = memoryMiB != null ? memoryMiB.build() : null;
        }

        @Override
        public final Builder memoryMiB(MemoryMiBRange memoryMiB) {
            this.memoryMiB = memoryMiB;
            return this;
        }

        public final String getOsFamily() {
            return this.osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(ServiceManagedFleetOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        public final String getCpuArchitectureType() {
            return this.cpuArchitectureType;
        }

        public final void setCpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
        }

        @Override
        public final Builder cpuArchitectureType(String cpuArchitectureType) {
            this.cpuArchitectureType = cpuArchitectureType;
            return this;
        }

        @Override
        public final Builder cpuArchitectureType(CpuArchitectureType cpuArchitectureType) {
            this.cpuArchitectureType(cpuArchitectureType == null ? null : cpuArchitectureType.toString());
            return this;
        }

        public final Ec2EbsVolume.Builder getRootEbsVolume() {
            return this.rootEbsVolume != null ? this.rootEbsVolume.toBuilder() : null;
        }

        public final void setRootEbsVolume(Ec2EbsVolume.BuilderImpl rootEbsVolume) {
            this.rootEbsVolume = rootEbsVolume != null ? rootEbsVolume.build() : null;
        }

        @Override
        public final Builder rootEbsVolume(Ec2EbsVolume rootEbsVolume) {
            this.rootEbsVolume = rootEbsVolume;
            return this;
        }

        public final AcceleratorCapabilities.Builder getAcceleratorCapabilities() {
            return this.acceleratorCapabilities != null ? this.acceleratorCapabilities.toBuilder() : null;
        }

        public final void setAcceleratorCapabilities(AcceleratorCapabilities.BuilderImpl acceleratorCapabilities) {
            this.acceleratorCapabilities = acceleratorCapabilities != null ? acceleratorCapabilities.build() : null;
        }

        @Override
        public final Builder acceleratorCapabilities(AcceleratorCapabilities acceleratorCapabilities) {
            this.acceleratorCapabilities = acceleratorCapabilities;
            return this;
        }

        public final Collection<String> getAllowedInstanceTypes() {
            if (this.allowedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.allowedInstanceTypes;
        }

        public final void setAllowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypesCopier.copy(allowedInstanceTypes);
        }

        @Override
        public final Builder allowedInstanceTypes(Collection<String> allowedInstanceTypes) {
            this.allowedInstanceTypes = InstanceTypesCopier.copy(allowedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder allowedInstanceTypes(String ... allowedInstanceTypes) {
            this.allowedInstanceTypes(Arrays.asList(allowedInstanceTypes));
            return this;
        }

        public final Collection<String> getExcludedInstanceTypes() {
            if (this.excludedInstanceTypes instanceof SdkAutoConstructList) {
                return null;
            }
            return this.excludedInstanceTypes;
        }

        public final void setExcludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypesCopier.copy(excludedInstanceTypes);
        }

        @Override
        public final Builder excludedInstanceTypes(Collection<String> excludedInstanceTypes) {
            this.excludedInstanceTypes = InstanceTypesCopier.copy(excludedInstanceTypes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder excludedInstanceTypes(String ... excludedInstanceTypes) {
            this.excludedInstanceTypes(Arrays.asList(excludedInstanceTypes));
            return this;
        }

        public final List<FleetAmountCapability.Builder> getCustomAmounts() {
            List<FleetAmountCapability.Builder> result = CustomFleetAmountCapabilitiesCopier.copyToBuilder(this.customAmounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAmounts(Collection<FleetAmountCapability.BuilderImpl> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copyFromBuilder(customAmounts);
        }

        @Override
        public final Builder customAmounts(Collection<FleetAmountCapability> customAmounts) {
            this.customAmounts = CustomFleetAmountCapabilitiesCopier.copy(customAmounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(FleetAmountCapability ... customAmounts) {
            this.customAmounts(Arrays.asList(customAmounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAmounts(Consumer<FleetAmountCapability.Builder> ... customAmounts) {
            this.customAmounts(Stream.of(customAmounts).map(c -> (FleetAmountCapability)((FleetAmountCapability.Builder)FleetAmountCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final List<FleetAttributeCapability.Builder> getCustomAttributes() {
            List<FleetAttributeCapability.Builder> result = CustomFleetAttributeCapabilitiesCopier.copyToBuilder(this.customAttributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setCustomAttributes(Collection<FleetAttributeCapability.BuilderImpl> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copyFromBuilder(customAttributes);
        }

        @Override
        public final Builder customAttributes(Collection<FleetAttributeCapability> customAttributes) {
            this.customAttributes = CustomFleetAttributeCapabilitiesCopier.copy(customAttributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(FleetAttributeCapability ... customAttributes) {
            this.customAttributes(Arrays.asList(customAttributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder customAttributes(Consumer<FleetAttributeCapability.Builder> ... customAttributes) {
            this.customAttributes(Stream.of(customAttributes).map(c -> (FleetAttributeCapability)((FleetAttributeCapability.Builder)FleetAttributeCapability.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public ServiceManagedEc2InstanceCapabilities build() {
            return new ServiceManagedEc2InstanceCapabilities(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceManagedEc2InstanceCapabilities> {
        public Builder vCpuCount(VCpuCountRange var1);

        default public Builder vCpuCount(Consumer<VCpuCountRange.Builder> vCpuCount) {
            return this.vCpuCount((VCpuCountRange)((VCpuCountRange.Builder)VCpuCountRange.builder().applyMutation(vCpuCount)).build());
        }

        public Builder memoryMiB(MemoryMiBRange var1);

        default public Builder memoryMiB(Consumer<MemoryMiBRange.Builder> memoryMiB) {
            return this.memoryMiB((MemoryMiBRange)((MemoryMiBRange.Builder)MemoryMiBRange.builder().applyMutation(memoryMiB)).build());
        }

        public Builder osFamily(String var1);

        public Builder osFamily(ServiceManagedFleetOperatingSystemFamily var1);

        public Builder cpuArchitectureType(String var1);

        public Builder cpuArchitectureType(CpuArchitectureType var1);

        public Builder rootEbsVolume(Ec2EbsVolume var1);

        default public Builder rootEbsVolume(Consumer<Ec2EbsVolume.Builder> rootEbsVolume) {
            return this.rootEbsVolume((Ec2EbsVolume)((Ec2EbsVolume.Builder)Ec2EbsVolume.builder().applyMutation(rootEbsVolume)).build());
        }

        public Builder acceleratorCapabilities(AcceleratorCapabilities var1);

        default public Builder acceleratorCapabilities(Consumer<AcceleratorCapabilities.Builder> acceleratorCapabilities) {
            return this.acceleratorCapabilities((AcceleratorCapabilities)((AcceleratorCapabilities.Builder)AcceleratorCapabilities.builder().applyMutation(acceleratorCapabilities)).build());
        }

        public Builder allowedInstanceTypes(Collection<String> var1);

        public Builder allowedInstanceTypes(String ... var1);

        public Builder excludedInstanceTypes(Collection<String> var1);

        public Builder excludedInstanceTypes(String ... var1);

        public Builder customAmounts(Collection<FleetAmountCapability> var1);

        public Builder customAmounts(FleetAmountCapability ... var1);

        public Builder customAmounts(Consumer<FleetAmountCapability.Builder> ... var1);

        public Builder customAttributes(Collection<FleetAttributeCapability> var1);

        public Builder customAttributes(FleetAttributeCapability ... var1);

        public Builder customAttributes(Consumer<FleetAttributeCapability.Builder> ... var1);
    }
}

