/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.services.deadline.model.JobTargetTaskRunStatus;
import software.amazon.awssdk.services.deadline.model.UpdateJobLifecycleStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class UpdateJobRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, UpdateJobRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("clientToken").getter(UpdateJobRequest.getter(UpdateJobRequest::clientToken)).setter(UpdateJobRequest.setter(Builder::clientToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(), DefaultValueTrait.idempotencyToken()}).build();
    private static final SdkField<String> TARGET_TASK_RUN_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("targetTaskRunStatus").getter(UpdateJobRequest.getter(UpdateJobRequest::targetTaskRunStatusAsString)).setter(UpdateJobRequest.setter(Builder::targetTaskRunStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("targetTaskRunStatus").build()}).build();
    private static final SdkField<Integer> PRIORITY_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("priority").getter(UpdateJobRequest.getter(UpdateJobRequest::priority)).setter(UpdateJobRequest.setter(Builder::priority)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("priority").build()}).build();
    private static final SdkField<Integer> MAX_FAILED_TASKS_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxFailedTasksCount").getter(UpdateJobRequest.getter(UpdateJobRequest::maxFailedTasksCount)).setter(UpdateJobRequest.setter(Builder::maxFailedTasksCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxFailedTasksCount").build()}).build();
    private static final SdkField<Integer> MAX_RETRIES_PER_TASK_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxRetriesPerTask").getter(UpdateJobRequest.getter(UpdateJobRequest::maxRetriesPerTask)).setter(UpdateJobRequest.setter(Builder::maxRetriesPerTask)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxRetriesPerTask").build()}).build();
    private static final SdkField<String> LIFECYCLE_STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("lifecycleStatus").getter(UpdateJobRequest.getter(UpdateJobRequest::lifecycleStatusAsString)).setter(UpdateJobRequest.setter(Builder::lifecycleStatus)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("lifecycleStatus").build()}).build();
    private static final SdkField<Integer> MAX_WORKER_COUNT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("maxWorkerCount").getter(UpdateJobRequest.getter(UpdateJobRequest::maxWorkerCount)).setter(UpdateJobRequest.setter(Builder::maxWorkerCount)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxWorkerCount").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(UpdateJobRequest.getter(UpdateJobRequest::farmId)).setter(UpdateJobRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(UpdateJobRequest.getter(UpdateJobRequest::queueId)).setter(UpdateJobRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(UpdateJobRequest.getter(UpdateJobRequest::jobId)).setter(UpdateJobRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD, TARGET_TASK_RUN_STATUS_FIELD, PRIORITY_FIELD, MAX_FAILED_TASKS_COUNT_FIELD, MAX_RETRIES_PER_TASK_FIELD, LIFECYCLE_STATUS_FIELD, MAX_WORKER_COUNT_FIELD, FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = UpdateJobRequest.memberNameToFieldInitializer();
    private final String clientToken;
    private final String targetTaskRunStatus;
    private final Integer priority;
    private final Integer maxFailedTasksCount;
    private final Integer maxRetriesPerTask;
    private final String lifecycleStatus;
    private final Integer maxWorkerCount;
    private final String farmId;
    private final String queueId;
    private final String jobId;

    private UpdateJobRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.targetTaskRunStatus = builder.targetTaskRunStatus;
        this.priority = builder.priority;
        this.maxFailedTasksCount = builder.maxFailedTasksCount;
        this.maxRetriesPerTask = builder.maxRetriesPerTask;
        this.lifecycleStatus = builder.lifecycleStatus;
        this.maxWorkerCount = builder.maxWorkerCount;
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
    }

    public final String clientToken() {
        return this.clientToken;
    }

    public final JobTargetTaskRunStatus targetTaskRunStatus() {
        return JobTargetTaskRunStatus.fromValue(this.targetTaskRunStatus);
    }

    public final String targetTaskRunStatusAsString() {
        return this.targetTaskRunStatus;
    }

    public final Integer priority() {
        return this.priority;
    }

    public final Integer maxFailedTasksCount() {
        return this.maxFailedTasksCount;
    }

    public final Integer maxRetriesPerTask() {
        return this.maxRetriesPerTask;
    }

    public final UpdateJobLifecycleStatus lifecycleStatus() {
        return UpdateJobLifecycleStatus.fromValue(this.lifecycleStatus);
    }

    public final String lifecycleStatusAsString() {
        return this.lifecycleStatus;
    }

    public final Integer maxWorkerCount() {
        return this.maxWorkerCount;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String jobId() {
        return this.jobId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(this.targetTaskRunStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.priority());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxFailedTasksCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxRetriesPerTask());
        hashCode = 31 * hashCode + Objects.hashCode(this.lifecycleStatusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.maxWorkerCount());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateJobRequest)) {
            return false;
        }
        UpdateJobRequest other = (UpdateJobRequest)((Object)obj);
        return Objects.equals(this.clientToken(), other.clientToken()) && Objects.equals(this.targetTaskRunStatusAsString(), other.targetTaskRunStatusAsString()) && Objects.equals(this.priority(), other.priority()) && Objects.equals(this.maxFailedTasksCount(), other.maxFailedTasksCount()) && Objects.equals(this.maxRetriesPerTask(), other.maxRetriesPerTask()) && Objects.equals(this.lifecycleStatusAsString(), other.lifecycleStatusAsString()) && Objects.equals(this.maxWorkerCount(), other.maxWorkerCount()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.jobId(), other.jobId());
    }

    public final String toString() {
        return ToString.builder((String)"UpdateJobRequest").add("ClientToken", (Object)this.clientToken()).add("TargetTaskRunStatus", (Object)this.targetTaskRunStatusAsString()).add("Priority", (Object)this.priority()).add("MaxFailedTasksCount", (Object)this.maxFailedTasksCount()).add("MaxRetriesPerTask", (Object)this.maxRetriesPerTask()).add("LifecycleStatus", (Object)this.lifecycleStatusAsString()).add("MaxWorkerCount", (Object)this.maxWorkerCount()).add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("JobId", (Object)this.jobId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "clientToken": {
                return Optional.ofNullable(clazz.cast(this.clientToken()));
            }
            case "targetTaskRunStatus": {
                return Optional.ofNullable(clazz.cast(this.targetTaskRunStatusAsString()));
            }
            case "priority": {
                return Optional.ofNullable(clazz.cast(this.priority()));
            }
            case "maxFailedTasksCount": {
                return Optional.ofNullable(clazz.cast(this.maxFailedTasksCount()));
            }
            case "maxRetriesPerTask": {
                return Optional.ofNullable(clazz.cast(this.maxRetriesPerTask()));
            }
            case "lifecycleStatus": {
                return Optional.ofNullable(clazz.cast(this.lifecycleStatusAsString()));
            }
            case "maxWorkerCount": {
                return Optional.ofNullable(clazz.cast(this.maxWorkerCount()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("targetTaskRunStatus", TARGET_TASK_RUN_STATUS_FIELD);
        map.put("priority", PRIORITY_FIELD);
        map.put("maxFailedTasksCount", MAX_FAILED_TASKS_COUNT_FIELD);
        map.put("maxRetriesPerTask", MAX_RETRIES_PER_TASK_FIELD);
        map.put("lifecycleStatus", LIFECYCLE_STATUS_FIELD);
        map.put("maxWorkerCount", MAX_WORKER_COUNT_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateJobRequest, T> g) {
        return obj -> g.apply((UpdateJobRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String clientToken;
        private String targetTaskRunStatus;
        private Integer priority;
        private Integer maxFailedTasksCount;
        private Integer maxRetriesPerTask;
        private String lifecycleStatus;
        private Integer maxWorkerCount;
        private String farmId;
        private String queueId;
        private String jobId;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateJobRequest model) {
            super(model);
            this.clientToken(model.clientToken);
            this.targetTaskRunStatus(model.targetTaskRunStatus);
            this.priority(model.priority);
            this.maxFailedTasksCount(model.maxFailedTasksCount);
            this.maxRetriesPerTask(model.maxRetriesPerTask);
            this.lifecycleStatus(model.lifecycleStatus);
            this.maxWorkerCount(model.maxWorkerCount);
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.jobId(model.jobId);
        }

        public final String getClientToken() {
            return this.clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getTargetTaskRunStatus() {
            return this.targetTaskRunStatus;
        }

        public final void setTargetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
        }

        @Override
        public final Builder targetTaskRunStatus(String targetTaskRunStatus) {
            this.targetTaskRunStatus = targetTaskRunStatus;
            return this;
        }

        @Override
        public final Builder targetTaskRunStatus(JobTargetTaskRunStatus targetTaskRunStatus) {
            this.targetTaskRunStatus(targetTaskRunStatus == null ? null : targetTaskRunStatus.toString());
            return this;
        }

        public final Integer getPriority() {
            return this.priority;
        }

        public final void setPriority(Integer priority) {
            this.priority = priority;
        }

        @Override
        public final Builder priority(Integer priority) {
            this.priority = priority;
            return this;
        }

        public final Integer getMaxFailedTasksCount() {
            return this.maxFailedTasksCount;
        }

        public final void setMaxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
        }

        @Override
        public final Builder maxFailedTasksCount(Integer maxFailedTasksCount) {
            this.maxFailedTasksCount = maxFailedTasksCount;
            return this;
        }

        public final Integer getMaxRetriesPerTask() {
            return this.maxRetriesPerTask;
        }

        public final void setMaxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
        }

        @Override
        public final Builder maxRetriesPerTask(Integer maxRetriesPerTask) {
            this.maxRetriesPerTask = maxRetriesPerTask;
            return this;
        }

        public final String getLifecycleStatus() {
            return this.lifecycleStatus;
        }

        public final void setLifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
        }

        @Override
        public final Builder lifecycleStatus(String lifecycleStatus) {
            this.lifecycleStatus = lifecycleStatus;
            return this;
        }

        @Override
        public final Builder lifecycleStatus(UpdateJobLifecycleStatus lifecycleStatus) {
            this.lifecycleStatus(lifecycleStatus == null ? null : lifecycleStatus.toString());
            return this;
        }

        public final Integer getMaxWorkerCount() {
            return this.maxWorkerCount;
        }

        public final void setMaxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
        }

        @Override
        public final Builder maxWorkerCount(Integer maxWorkerCount) {
            this.maxWorkerCount = maxWorkerCount;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateJobRequest build() {
            return new UpdateJobRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, UpdateJobRequest> {
        public Builder clientToken(String var1);

        public Builder targetTaskRunStatus(String var1);

        public Builder targetTaskRunStatus(JobTargetTaskRunStatus var1);

        public Builder priority(Integer var1);

        public Builder maxFailedTasksCount(Integer var1);

        public Builder maxRetriesPerTask(Integer var1);

        public Builder lifecycleStatus(String var1);

        public Builder lifecycleStatus(UpdateJobLifecycleStatus var1);

        public Builder maxWorkerCount(Integer var1);

        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder jobId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

