/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceCapabilities;
import software.amazon.awssdk.services.deadline.model.ServiceManagedEc2InstanceMarketOptions;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class ServiceManagedEc2FleetConfiguration
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, ServiceManagedEc2FleetConfiguration> {
    private static final SdkField<ServiceManagedEc2InstanceCapabilities> INSTANCE_CAPABILITIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceCapabilities").getter(ServiceManagedEc2FleetConfiguration.getter(ServiceManagedEc2FleetConfiguration::instanceCapabilities)).setter(ServiceManagedEc2FleetConfiguration.setter(Builder::instanceCapabilities)).constructor(ServiceManagedEc2InstanceCapabilities::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCapabilities").build()}).build();
    private static final SdkField<ServiceManagedEc2InstanceMarketOptions> INSTANCE_MARKET_OPTIONS_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("instanceMarketOptions").getter(ServiceManagedEc2FleetConfiguration.getter(ServiceManagedEc2FleetConfiguration::instanceMarketOptions)).setter(ServiceManagedEc2FleetConfiguration.setter(Builder::instanceMarketOptions)).constructor(ServiceManagedEc2InstanceMarketOptions::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMarketOptions").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_CAPABILITIES_FIELD, INSTANCE_MARKET_OPTIONS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = ServiceManagedEc2FleetConfiguration.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final ServiceManagedEc2InstanceCapabilities instanceCapabilities;
    private final ServiceManagedEc2InstanceMarketOptions instanceMarketOptions;

    private ServiceManagedEc2FleetConfiguration(BuilderImpl builder) {
        this.instanceCapabilities = builder.instanceCapabilities;
        this.instanceMarketOptions = builder.instanceMarketOptions;
    }

    public final ServiceManagedEc2InstanceCapabilities instanceCapabilities() {
        return this.instanceCapabilities;
    }

    public final ServiceManagedEc2InstanceMarketOptions instanceMarketOptions() {
        return this.instanceMarketOptions;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(this.instanceMarketOptions());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEc2FleetConfiguration)) {
            return false;
        }
        ServiceManagedEc2FleetConfiguration other = (ServiceManagedEc2FleetConfiguration)obj;
        return Objects.equals(this.instanceCapabilities(), other.instanceCapabilities()) && Objects.equals(this.instanceMarketOptions(), other.instanceMarketOptions());
    }

    public final String toString() {
        return ToString.builder((String)"ServiceManagedEc2FleetConfiguration").add("InstanceCapabilities", (Object)this.instanceCapabilities()).add("InstanceMarketOptions", (Object)this.instanceMarketOptions()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "instanceCapabilities": {
                return Optional.ofNullable(clazz.cast(this.instanceCapabilities()));
            }
            case "instanceMarketOptions": {
                return Optional.ofNullable(clazz.cast(this.instanceMarketOptions()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("instanceCapabilities", INSTANCE_CAPABILITIES_FIELD);
        map.put("instanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceManagedEc2FleetConfiguration, T> g) {
        return obj -> g.apply((ServiceManagedEc2FleetConfiguration)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private ServiceManagedEc2InstanceCapabilities instanceCapabilities;
        private ServiceManagedEc2InstanceMarketOptions instanceMarketOptions;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceManagedEc2FleetConfiguration model) {
            this.instanceCapabilities(model.instanceCapabilities);
            this.instanceMarketOptions(model.instanceMarketOptions);
        }

        public final ServiceManagedEc2InstanceCapabilities.Builder getInstanceCapabilities() {
            return this.instanceCapabilities != null ? this.instanceCapabilities.toBuilder() : null;
        }

        public final void setInstanceCapabilities(ServiceManagedEc2InstanceCapabilities.BuilderImpl instanceCapabilities) {
            this.instanceCapabilities = instanceCapabilities != null ? instanceCapabilities.build() : null;
        }

        @Override
        public final Builder instanceCapabilities(ServiceManagedEc2InstanceCapabilities instanceCapabilities) {
            this.instanceCapabilities = instanceCapabilities;
            return this;
        }

        public final ServiceManagedEc2InstanceMarketOptions.Builder getInstanceMarketOptions() {
            return this.instanceMarketOptions != null ? this.instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(ServiceManagedEc2InstanceMarketOptions.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public ServiceManagedEc2FleetConfiguration build() {
            return new ServiceManagedEc2FleetConfiguration(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, ServiceManagedEc2FleetConfiguration> {
        public Builder instanceCapabilities(ServiceManagedEc2InstanceCapabilities var1);

        default public Builder instanceCapabilities(Consumer<ServiceManagedEc2InstanceCapabilities.Builder> instanceCapabilities) {
            return this.instanceCapabilities((ServiceManagedEc2InstanceCapabilities)((ServiceManagedEc2InstanceCapabilities.Builder)ServiceManagedEc2InstanceCapabilities.builder().applyMutation(instanceCapabilities)).build());
        }

        public Builder instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions var1);

        default public Builder instanceMarketOptions(Consumer<ServiceManagedEc2InstanceMarketOptions.Builder> instanceMarketOptions) {
            return this.instanceMarketOptions((ServiceManagedEc2InstanceMarketOptions)((ServiceManagedEc2InstanceMarketOptions.Builder)ServiceManagedEc2InstanceMarketOptions.builder().applyMutation(instanceMarketOptions)).build());
        }
    }
}

