/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineAsyncClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.LimitSummary;
import software.amazon.awssdk.services.deadline.model.ListLimitsRequest;
import software.amazon.awssdk.services.deadline.model.ListLimitsResponse;

public class ListLimitsPublisher
implements SdkPublisher<ListLimitsResponse> {
    private final DeadlineAsyncClient client;
    private final ListLimitsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public ListLimitsPublisher(DeadlineAsyncClient client, ListLimitsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private ListLimitsPublisher(DeadlineAsyncClient client, ListLimitsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new ListLimitsResponseFetcher();
    }

    public void subscribe(Subscriber<? super ListLimitsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<LimitSummary> limits() {
        Function<ListLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.limits() != null) {
                return response.limits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new ListLimitsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class ListLimitsResponseFetcher
    implements AsyncPageFetcher<ListLimitsResponse> {
        private ListLimitsResponseFetcher() {
        }

        public boolean hasNextPage(ListLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<ListLimitsResponse> nextPage(ListLimitsResponse previousPage) {
            if (previousPage == null) {
                return ListLimitsPublisher.this.client.listLimits(ListLimitsPublisher.this.firstRequest);
            }
            return ListLimitsPublisher.this.client.listLimits((ListLimitsRequest)((Object)ListLimitsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

