/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.DeadlineRequest;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class GetSessionRequest
extends DeadlineRequest
implements ToCopyableBuilder<Builder, GetSessionRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(GetSessionRequest.getter(GetSessionRequest::farmId)).setter(GetSessionRequest.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()}).build();
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("queueId").getter(GetSessionRequest.getter(GetSessionRequest::queueId)).setter(GetSessionRequest.setter(Builder::queueId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()}).build();
    private static final SdkField<String> JOB_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("jobId").getter(GetSessionRequest.getter(GetSessionRequest::jobId)).setter(GetSessionRequest.setter(Builder::jobId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("jobId").build()}).build();
    private static final SdkField<String> SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("sessionId").getter(GetSessionRequest.getter(GetSessionRequest::sessionId)).setter(GetSessionRequest.setter(Builder::sessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PATH).locationName("sessionId").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, QUEUE_ID_FIELD, JOB_ID_FIELD, SESSION_ID_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = GetSessionRequest.memberNameToFieldInitializer();
    private final String farmId;
    private final String queueId;
    private final String jobId;
    private final String sessionId;

    private GetSessionRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.jobId = builder.jobId;
        this.sessionId = builder.sessionId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String queueId() {
        return this.queueId;
    }

    public final String jobId() {
        return this.jobId;
    }

    public final String sessionId() {
        return this.sessionId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.queueId());
        hashCode = 31 * hashCode + Objects.hashCode(this.jobId());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionId());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof GetSessionRequest)) {
            return false;
        }
        GetSessionRequest other = (GetSessionRequest)((Object)obj);
        return Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.queueId(), other.queueId()) && Objects.equals(this.jobId(), other.jobId()) && Objects.equals(this.sessionId(), other.sessionId());
    }

    public final String toString() {
        return ToString.builder((String)"GetSessionRequest").add("FarmId", (Object)this.farmId()).add("QueueId", (Object)this.queueId()).add("JobId", (Object)this.jobId()).add("SessionId", (Object)this.sessionId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "queueId": {
                return Optional.ofNullable(clazz.cast(this.queueId()));
            }
            case "jobId": {
                return Optional.ofNullable(clazz.cast(this.jobId()));
            }
            case "sessionId": {
                return Optional.ofNullable(clazz.cast(this.sessionId()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, SdkField<String>> map = new HashMap<String, SdkField<String>>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("jobId", JOB_ID_FIELD);
        map.put("sessionId", SESSION_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<GetSessionRequest, T> g) {
        return obj -> g.apply((GetSessionRequest)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends DeadlineRequest.BuilderImpl
    implements Builder {
        private String farmId;
        private String queueId;
        private String jobId;
        private String sessionId;

        private BuilderImpl() {
        }

        private BuilderImpl(GetSessionRequest model) {
            super(model);
            this.farmId(model.farmId);
            this.queueId(model.queueId);
            this.jobId(model.jobId);
            this.sessionId(model.sessionId);
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return this.queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getJobId() {
            return this.jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getSessionId() {
            return this.sessionId;
        }

        public final void setSessionId(String sessionId) {
            this.sessionId = sessionId;
        }

        @Override
        public final Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public GetSessionRequest build() {
            return new GetSessionRequest(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends DeadlineRequest.Builder,
    SdkPojo,
    CopyableBuilder<Builder, GetSessionRequest> {
        public Builder farmId(String var1);

        public Builder queueId(String var1);

        public Builder jobId(String var1);

        public Builder sessionId(String var1);

        public Builder overrideConfiguration(AwsRequestOverrideConfiguration var1);

        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> var1);
    }
}

