/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.services.deadline.model.HostPropertiesResponse;
import software.amazon.awssdk.services.deadline.model.LogConfiguration;
import software.amazon.awssdk.services.deadline.model.WorkerStatus;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class WorkerSummary
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, WorkerSummary> {
    private static final SdkField<String> WORKER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("workerId").getter(WorkerSummary.getter(WorkerSummary::workerId)).setter(WorkerSummary.setter(Builder::workerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("workerId").build()}).build();
    private static final SdkField<String> FARM_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("farmId").getter(WorkerSummary.getter(WorkerSummary::farmId)).setter(WorkerSummary.setter(Builder::farmId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("farmId").build()}).build();
    private static final SdkField<String> FLEET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("fleetId").getter(WorkerSummary.getter(WorkerSummary::fleetId)).setter(WorkerSummary.setter(Builder::fleetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()}).build();
    private static final SdkField<String> STATUS_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("status").getter(WorkerSummary.getter(WorkerSummary::statusAsString)).setter(WorkerSummary.setter(Builder::status)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()}).build();
    private static final SdkField<HostPropertiesResponse> HOST_PROPERTIES_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("hostProperties").getter(WorkerSummary.getter(WorkerSummary::hostProperties)).setter(WorkerSummary.setter(Builder::hostProperties)).constructor(HostPropertiesResponse::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()}).build();
    private static final SdkField<LogConfiguration> LOG_FIELD = SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).memberName("log").getter(WorkerSummary.getter(WorkerSummary::log)).setter(WorkerSummary.setter(Builder::log)).constructor(LogConfiguration::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("log").build()}).build();
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("createdAt").getter(WorkerSummary.getter(WorkerSummary::createdAt)).setter(WorkerSummary.setter(Builder::createdAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> CREATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("createdBy").getter(WorkerSummary.getter(WorkerSummary::createdBy)).setter(WorkerSummary.setter(Builder::createdBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()}).build();
    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField.builder((MarshallingType)MarshallingType.INSTANT).memberName("updatedAt").getter(WorkerSummary.getter(WorkerSummary::updatedAt)).setter(WorkerSummary.setter(Builder::updatedAt)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(), TimestampFormatTrait.create((TimestampFormatTrait.Format)TimestampFormatTrait.Format.ISO_8601)}).build();
    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("updatedBy").getter(WorkerSummary.getter(WorkerSummary::updatedBy)).setter(WorkerSummary.setter(Builder::updatedBy)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(WORKER_ID_FIELD, FARM_ID_FIELD, FLEET_ID_FIELD, STATUS_FIELD, HOST_PROPERTIES_FIELD, LOG_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = WorkerSummary.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String workerId;
    private final String farmId;
    private final String fleetId;
    private final String status;
    private final HostPropertiesResponse hostProperties;
    private final LogConfiguration log;
    private final Instant createdAt;
    private final String createdBy;
    private final Instant updatedAt;
    private final String updatedBy;

    private WorkerSummary(BuilderImpl builder) {
        this.workerId = builder.workerId;
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.status = builder.status;
        this.hostProperties = builder.hostProperties;
        this.log = builder.log;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    public final String workerId() {
        return this.workerId;
    }

    public final String farmId() {
        return this.farmId;
    }

    public final String fleetId() {
        return this.fleetId;
    }

    public final WorkerStatus status() {
        return WorkerStatus.fromValue(this.status);
    }

    public final String statusAsString() {
        return this.status;
    }

    public final HostPropertiesResponse hostProperties() {
        return this.hostProperties;
    }

    public final LogConfiguration log() {
        return this.log;
    }

    public final Instant createdAt() {
        return this.createdAt;
    }

    public final String createdBy() {
        return this.createdBy;
    }

    public final Instant updatedAt() {
        return this.updatedAt;
    }

    public final String updatedBy() {
        return this.updatedBy;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.workerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.farmId());
        hashCode = 31 * hashCode + Objects.hashCode(this.fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(this.hostProperties());
        hashCode = 31 * hashCode + Objects.hashCode(this.log());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(this.updatedBy());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WorkerSummary)) {
            return false;
        }
        WorkerSummary other = (WorkerSummary)obj;
        return Objects.equals(this.workerId(), other.workerId()) && Objects.equals(this.farmId(), other.farmId()) && Objects.equals(this.fleetId(), other.fleetId()) && Objects.equals(this.statusAsString(), other.statusAsString()) && Objects.equals(this.hostProperties(), other.hostProperties()) && Objects.equals(this.log(), other.log()) && Objects.equals(this.createdAt(), other.createdAt()) && Objects.equals(this.createdBy(), other.createdBy()) && Objects.equals(this.updatedAt(), other.updatedAt()) && Objects.equals(this.updatedBy(), other.updatedBy());
    }

    public final String toString() {
        return ToString.builder((String)"WorkerSummary").add("WorkerId", (Object)this.workerId()).add("FarmId", (Object)this.farmId()).add("FleetId", (Object)this.fleetId()).add("Status", (Object)this.statusAsString()).add("HostProperties", (Object)this.hostProperties()).add("Log", (Object)this.log()).add("CreatedAt", (Object)this.createdAt()).add("CreatedBy", (Object)this.createdBy()).add("UpdatedAt", (Object)this.updatedAt()).add("UpdatedBy", (Object)this.updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "workerId": {
                return Optional.ofNullable(clazz.cast(this.workerId()));
            }
            case "farmId": {
                return Optional.ofNullable(clazz.cast(this.farmId()));
            }
            case "fleetId": {
                return Optional.ofNullable(clazz.cast(this.fleetId()));
            }
            case "status": {
                return Optional.ofNullable(clazz.cast(this.statusAsString()));
            }
            case "hostProperties": {
                return Optional.ofNullable(clazz.cast(this.hostProperties()));
            }
            case "log": {
                return Optional.ofNullable(clazz.cast(this.log()));
            }
            case "createdAt": {
                return Optional.ofNullable(clazz.cast(this.createdAt()));
            }
            case "createdBy": {
                return Optional.ofNullable(clazz.cast(this.createdBy()));
            }
            case "updatedAt": {
                return Optional.ofNullable(clazz.cast(this.updatedAt()));
            }
            case "updatedBy": {
                return Optional.ofNullable(clazz.cast(this.updatedBy()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("workerId", WORKER_ID_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("hostProperties", HOST_PROPERTIES_FIELD);
        map.put("log", LOG_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<WorkerSummary, T> g) {
        return obj -> g.apply((WorkerSummary)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String workerId;
        private String farmId;
        private String fleetId;
        private String status;
        private HostPropertiesResponse hostProperties;
        private LogConfiguration log;
        private Instant createdAt;
        private String createdBy;
        private Instant updatedAt;
        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(WorkerSummary model) {
            this.workerId(model.workerId);
            this.farmId(model.farmId);
            this.fleetId(model.fleetId);
            this.status(model.status);
            this.hostProperties(model.hostProperties);
            this.log(model.log);
            this.createdAt(model.createdAt);
            this.createdBy(model.createdBy);
            this.updatedAt(model.updatedAt);
            this.updatedBy(model.updatedBy);
        }

        public final String getWorkerId() {
            return this.workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getFarmId() {
            return this.farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return this.fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getStatus() {
            return this.status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(WorkerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final HostPropertiesResponse.Builder getHostProperties() {
            return this.hostProperties != null ? this.hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesResponse.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesResponse hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        public final LogConfiguration.Builder getLog() {
            return this.log != null ? this.log.toBuilder() : null;
        }

        public final void setLog(LogConfiguration.BuilderImpl log) {
            this.log = log != null ? log.build() : null;
        }

        @Override
        public final Builder log(LogConfiguration log) {
            this.log = log;
            return this;
        }

        public final Instant getCreatedAt() {
            return this.createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return this.createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return this.updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return this.updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public WorkerSummary build() {
            return new WorkerSummary(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    @Mutable
    @NotThreadSafe
    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, WorkerSummary> {
        public Builder workerId(String var1);

        public Builder farmId(String var1);

        public Builder fleetId(String var1);

        public Builder status(String var1);

        public Builder status(WorkerStatus var1);

        public Builder hostProperties(HostPropertiesResponse var1);

        default public Builder hostProperties(Consumer<HostPropertiesResponse.Builder> hostProperties) {
            return this.hostProperties((HostPropertiesResponse)((HostPropertiesResponse.Builder)HostPropertiesResponse.builder().applyMutation(hostProperties)).build());
        }

        public Builder log(LogConfiguration var1);

        default public Builder log(Consumer<LogConfiguration.Builder> log) {
            return this.log((LogConfiguration)((LogConfiguration.Builder)LogConfiguration.builder().applyMutation(log)).build());
        }

        public Builder createdAt(Instant var1);

        public Builder createdBy(String var1);

        public Builder updatedAt(Instant var1);

        public Builder updatedBy(String var1);
    }
}

