/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The attachments for jobs.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class Attachments implements SdkPojo, Serializable, ToCopyableBuilder<Attachments.Builder, Attachments> {
    private static final SdkField<List<ManifestProperties>> MANIFESTS_FIELD = SdkField
            .<List<ManifestProperties>> builder(MarshallingType.LIST)
            .memberName("manifests")
            .getter(getter(Attachments::manifests))
            .setter(setter(Builder::manifests))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("manifests").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<ManifestProperties> builder(MarshallingType.SDK_POJO)
                                            .constructor(ManifestProperties::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> FILE_SYSTEM_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fileSystem").getter(getter(Attachments::fileSystemAsString)).setter(setter(Builder::fileSystem))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fileSystem").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(MANIFESTS_FIELD,
            FILE_SYSTEM_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<ManifestProperties> manifests;

    private final String fileSystem;

    private Attachments(BuilderImpl builder) {
        this.manifests = builder.manifests;
        this.fileSystem = builder.fileSystem;
    }

    /**
     * For responses, this returns true if the service returned a value for the Manifests property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasManifests() {
        return manifests != null && !(manifests instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * A list of manifests which describe job attachment configurations.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasManifests} method.
     * </p>
     * 
     * @return A list of manifests which describe job attachment configurations.
     */
    public final List<ManifestProperties> manifests() {
        return manifests;
    }

    /**
     * <p>
     * The file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileSystem} will
     * return {@link JobAttachmentsFileSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileSystemAsString}.
     * </p>
     * 
     * @return The file system.
     * @see JobAttachmentsFileSystem
     */
    public final JobAttachmentsFileSystem fileSystem() {
        return JobAttachmentsFileSystem.fromValue(fileSystem);
    }

    /**
     * <p>
     * The file system.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #fileSystem} will
     * return {@link JobAttachmentsFileSystem#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #fileSystemAsString}.
     * </p>
     * 
     * @return The file system.
     * @see JobAttachmentsFileSystem
     */
    public final String fileSystemAsString() {
        return fileSystem;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasManifests() ? manifests() : null);
        hashCode = 31 * hashCode + Objects.hashCode(fileSystemAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof Attachments)) {
            return false;
        }
        Attachments other = (Attachments) obj;
        return hasManifests() == other.hasManifests() && Objects.equals(manifests(), other.manifests())
                && Objects.equals(fileSystemAsString(), other.fileSystemAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("Attachments").add("Manifests", manifests() == null ? null : "*** Sensitive Data Redacted ***")
                .add("FileSystem", fileSystemAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "manifests":
            return Optional.ofNullable(clazz.cast(manifests()));
        case "fileSystem":
            return Optional.ofNullable(clazz.cast(fileSystemAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("manifests", MANIFESTS_FIELD);
        map.put("fileSystem", FILE_SYSTEM_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<Attachments, T> g) {
        return obj -> g.apply((Attachments) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, Attachments> {
        /**
         * <p>
         * A list of manifests which describe job attachment configurations.
         * </p>
         * 
         * @param manifests
         *        A list of manifests which describe job attachment configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifests(Collection<ManifestProperties> manifests);

        /**
         * <p>
         * A list of manifests which describe job attachment configurations.
         * </p>
         * 
         * @param manifests
         *        A list of manifests which describe job attachment configurations.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder manifests(ManifestProperties... manifests);

        /**
         * <p>
         * A list of manifests which describe job attachment configurations.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.ManifestProperties.Builder} avoiding the need to create
         * one manually via {@link software.amazon.awssdk.services.deadline.model.ManifestProperties#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.ManifestProperties.Builder#build()} is called
         * immediately and its result is passed to {@link #manifests(List<ManifestProperties>)}.
         * 
         * @param manifests
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.ManifestProperties.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #manifests(java.util.Collection<ManifestProperties>)
         */
        Builder manifests(Consumer<ManifestProperties.Builder>... manifests);

        /**
         * <p>
         * The file system.
         * </p>
         * 
         * @param fileSystem
         *        The file system.
         * @see JobAttachmentsFileSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobAttachmentsFileSystem
         */
        Builder fileSystem(String fileSystem);

        /**
         * <p>
         * The file system.
         * </p>
         * 
         * @param fileSystem
         *        The file system.
         * @see JobAttachmentsFileSystem
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see JobAttachmentsFileSystem
         */
        Builder fileSystem(JobAttachmentsFileSystem fileSystem);
    }

    static final class BuilderImpl implements Builder {
        private List<ManifestProperties> manifests = DefaultSdkAutoConstructList.getInstance();

        private String fileSystem;

        private BuilderImpl() {
        }

        private BuilderImpl(Attachments model) {
            manifests(model.manifests);
            fileSystem(model.fileSystem);
        }

        public final List<ManifestProperties.Builder> getManifests() {
            List<ManifestProperties.Builder> result = ManifestPropertiesListCopier.copyToBuilder(this.manifests);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setManifests(Collection<ManifestProperties.BuilderImpl> manifests) {
            this.manifests = ManifestPropertiesListCopier.copyFromBuilder(manifests);
        }

        @Override
        public final Builder manifests(Collection<ManifestProperties> manifests) {
            this.manifests = ManifestPropertiesListCopier.copy(manifests);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(ManifestProperties... manifests) {
            manifests(Arrays.asList(manifests));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder manifests(Consumer<ManifestProperties.Builder>... manifests) {
            manifests(Stream.of(manifests).map(c -> ManifestProperties.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getFileSystem() {
            return fileSystem;
        }

        public final void setFileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
        }

        @Override
        public final Builder fileSystem(String fileSystem) {
            this.fileSystem = fileSystem;
            return this;
        }

        @Override
        public final Builder fileSystem(JobAttachmentsFileSystem fileSystem) {
            this.fileSystem(fileSystem == null ? null : fileSystem.toString());
            return this;
        }

        @Override
        public Attachments build() {
            return new Attachments(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
