/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.exception.AwsErrorDetails;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.MapTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructMap;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Your request has conflicting operations. This can occur if you're trying to perform more than one operation on the
 * same resource at the same time.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConflictException extends DeadlineException implements
        ToCopyableBuilder<ConflictException.Builder, ConflictException> {
    private static final SdkField<String> REASON_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("reason")
            .getter(getter(ConflictException::reasonAsString)).setter(setter(Builder::reason))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("reason").build()).build();

    private static final SdkField<String> RESOURCE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceId").getter(getter(ConflictException::resourceId)).setter(setter(Builder::resourceId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceId").build()).build();

    private static final SdkField<String> RESOURCE_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("resourceType").getter(getter(ConflictException::resourceType)).setter(setter(Builder::resourceType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceType").build()).build();

    private static final SdkField<Map<String, String>> CONTEXT_FIELD = SdkField
            .<Map<String, String>> builder(MarshallingType.MAP)
            .memberName("context")
            .getter(getter(ConflictException::context))
            .setter(setter(Builder::context))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("context").build(),
                    MapTrait.builder()
                            .keyLocationName("key")
                            .valueLocationName("value")
                            .valueFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("value").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(REASON_FIELD,
            RESOURCE_ID_FIELD, RESOURCE_TYPE_FIELD, CONTEXT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String reason;

    private final String resourceId;

    private final String resourceType;

    private final Map<String, String> context;

    private ConflictException(BuilderImpl builder) {
        super(builder);
        this.reason = builder.reason;
        this.resourceId = builder.resourceId;
        this.resourceType = builder.resourceType;
        this.context = builder.context;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    /**
     * <p>
     * A description of the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return A description of the error.
     * @see ConflictExceptionReason
     */
    public ConflictExceptionReason reason() {
        return ConflictExceptionReason.fromValue(reason);
    }

    /**
     * <p>
     * A description of the error.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #reason} will
     * return {@link ConflictExceptionReason#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #reasonAsString}.
     * </p>
     * 
     * @return A description of the error.
     * @see ConflictExceptionReason
     */
    public String reasonAsString() {
        return reason;
    }

    /**
     * <p>
     * The identifier of the resource in use.
     * </p>
     * 
     * @return The identifier of the resource in use.
     */
    public String resourceId() {
        return resourceId;
    }

    /**
     * <p>
     * The type of the resource in use.
     * </p>
     * 
     * @return The type of the resource in use.
     */
    public String resourceType() {
        return resourceType;
    }

    /**
     * For responses, this returns true if the service returned a value for the Context property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public boolean hasContext() {
        return context != null && !(context instanceof SdkAutoConstructMap);
    }

    /**
     * <p>
     * Information about the resources in use when the exception was thrown.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasContext} method.
     * </p>
     * 
     * @return Information about the resources in use when the exception was thrown.
     */
    public Map<String, String> context() {
        return context;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("reason", REASON_FIELD);
        map.put("resourceId", RESOURCE_ID_FIELD);
        map.put("resourceType", RESOURCE_TYPE_FIELD);
        map.put("context", CONTEXT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConflictException, T> g) {
        return obj -> g.apply((ConflictException) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConflictException>, DeadlineException.Builder {
        /**
         * <p>
         * A description of the error.
         * </p>
         * 
         * @param reason
         *        A description of the error.
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(String reason);

        /**
         * <p>
         * A description of the error.
         * </p>
         * 
         * @param reason
         *        A description of the error.
         * @see ConflictExceptionReason
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see ConflictExceptionReason
         */
        Builder reason(ConflictExceptionReason reason);

        /**
         * <p>
         * The identifier of the resource in use.
         * </p>
         * 
         * @param resourceId
         *        The identifier of the resource in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceId(String resourceId);

        /**
         * <p>
         * The type of the resource in use.
         * </p>
         * 
         * @param resourceType
         *        The type of the resource in use.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceType(String resourceType);

        /**
         * <p>
         * Information about the resources in use when the exception was thrown.
         * </p>
         * 
         * @param context
         *        Information about the resources in use when the exception was thrown.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder context(Map<String, String> context);

        @Override
        Builder awsErrorDetails(AwsErrorDetails awsErrorDetails);

        @Override
        Builder message(String message);

        @Override
        Builder requestId(String requestId);

        @Override
        Builder statusCode(int statusCode);

        @Override
        Builder cause(Throwable cause);

        @Override
        Builder writableStackTrace(Boolean writableStackTrace);

        @Override
        Builder numAttempts(Integer numAttempts);
    }

    static final class BuilderImpl extends DeadlineException.BuilderImpl implements Builder {
        private String reason;

        private String resourceId;

        private String resourceType;

        private Map<String, String> context = DefaultSdkAutoConstructMap.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(ConflictException model) {
            super(model);
            reason(model.reason);
            resourceId(model.resourceId);
            resourceType(model.resourceType);
            context(model.context);
        }

        public final String getReason() {
            return reason;
        }

        public final void setReason(String reason) {
            this.reason = reason;
        }

        @Override
        public final Builder reason(String reason) {
            this.reason = reason;
            return this;
        }

        @Override
        public final Builder reason(ConflictExceptionReason reason) {
            this.reason(reason == null ? null : reason.toString());
            return this;
        }

        public final String getResourceId() {
            return resourceId;
        }

        public final void setResourceId(String resourceId) {
            this.resourceId = resourceId;
        }

        @Override
        public final Builder resourceId(String resourceId) {
            this.resourceId = resourceId;
            return this;
        }

        public final String getResourceType() {
            return resourceType;
        }

        public final void setResourceType(String resourceType) {
            this.resourceType = resourceType;
        }

        @Override
        public final Builder resourceType(String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        public final Map<String, String> getContext() {
            if (context instanceof SdkAutoConstructMap) {
                return null;
            }
            return context;
        }

        public final void setContext(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
        }

        @Override
        public final Builder context(Map<String, String> context) {
            this.context = ExceptionContextCopier.copy(context);
            return this;
        }

        @Override
        public BuilderImpl awsErrorDetails(AwsErrorDetails awsErrorDetails) {
            this.awsErrorDetails = awsErrorDetails;
            return this;
        }

        @Override
        public BuilderImpl message(String message) {
            this.message = message;
            return this;
        }

        @Override
        public BuilderImpl requestId(String requestId) {
            this.requestId = requestId;
            return this;
        }

        @Override
        public BuilderImpl statusCode(int statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        @Override
        public BuilderImpl cause(Throwable cause) {
            this.cause = cause;
            return this;
        }

        @Override
        public BuilderImpl writableStackTrace(Boolean writableStackTrace) {
            this.writableStackTrace = writableStackTrace;
            return this;
        }

        @Override
        public BuilderImpl numAttempts(Integer numAttempts) {
            this.numAttempts = numAttempts;
            return this;
        }

        @Override
        public ConflictException build() {
            return new ConflictException(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
