/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The consumed usage for the resource.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ConsumedUsages implements SdkPojo, Serializable, ToCopyableBuilder<ConsumedUsages.Builder, ConsumedUsages> {
    private static final SdkField<Float> APPROXIMATE_DOLLAR_USAGE_FIELD = SdkField.<Float> builder(MarshallingType.FLOAT)
            .memberName("approximateDollarUsage").getter(getter(ConsumedUsages::approximateDollarUsage))
            .setter(setter(Builder::approximateDollarUsage))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("approximateDollarUsage").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(APPROXIMATE_DOLLAR_USAGE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Float approximateDollarUsage;

    private ConsumedUsages(BuilderImpl builder) {
        this.approximateDollarUsage = builder.approximateDollarUsage;
    }

    /**
     * <p>
     * The amount of the budget consumed.
     * </p>
     * 
     * @return The amount of the budget consumed.
     */
    public final Float approximateDollarUsage() {
        return approximateDollarUsage;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(approximateDollarUsage());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ConsumedUsages)) {
            return false;
        }
        ConsumedUsages other = (ConsumedUsages) obj;
        return Objects.equals(approximateDollarUsage(), other.approximateDollarUsage());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ConsumedUsages").add("ApproximateDollarUsage", approximateDollarUsage()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "approximateDollarUsage":
            return Optional.ofNullable(clazz.cast(approximateDollarUsage()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("approximateDollarUsage", APPROXIMATE_DOLLAR_USAGE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ConsumedUsages, T> g) {
        return obj -> g.apply((ConsumedUsages) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ConsumedUsages> {
        /**
         * <p>
         * The amount of the budget consumed.
         * </p>
         * 
         * @param approximateDollarUsage
         *        The amount of the budget consumed.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder approximateDollarUsage(Float approximateDollarUsage);
    }

    static final class BuilderImpl implements Builder {
        private Float approximateDollarUsage;

        private BuilderImpl() {
        }

        private BuilderImpl(ConsumedUsages model) {
            approximateDollarUsage(model.approximateDollarUsage);
        }

        public final Float getApproximateDollarUsage() {
            return approximateDollarUsage;
        }

        public final void setApproximateDollarUsage(Float approximateDollarUsage) {
            this.approximateDollarUsage = approximateDollarUsage;
        }

        @Override
        public final Builder approximateDollarUsage(Float approximateDollarUsage) {
            this.approximateDollarUsage = approximateDollarUsage;
            return this;
        }

        @Override
        public ConsumedUsages build() {
            return new ConsumedUsages(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
