/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.DefaultValueTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class CreateLimitRequest extends DeadlineRequest implements
        ToCopyableBuilder<CreateLimitRequest.Builder, CreateLimitRequest> {
    private static final SdkField<String> CLIENT_TOKEN_FIELD = SdkField
            .<String> builder(MarshallingType.STRING)
            .memberName("clientToken")
            .getter(getter(CreateLimitRequest::clientToken))
            .setter(setter(Builder::clientToken))
            .traits(LocationTrait.builder().location(MarshallLocation.HEADER).locationName("X-Amz-Client-Token").build(),
                    DefaultValueTrait.idempotencyToken()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(CreateLimitRequest::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> AMOUNT_REQUIREMENT_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("amountRequirementName").getter(getter(CreateLimitRequest::amountRequirementName))
            .setter(setter(Builder::amountRequirementName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amountRequirementName").build())
            .build();

    private static final SdkField<Integer> MAX_COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("maxCount").getter(getter(CreateLimitRequest::maxCount)).setter(setter(Builder::maxCount))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("maxCount").build()).build();

    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(CreateLimitRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("description").getter(getter(CreateLimitRequest::description)).setter(setter(Builder::description))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("description").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CLIENT_TOKEN_FIELD,
            DISPLAY_NAME_FIELD, AMOUNT_REQUIREMENT_NAME_FIELD, MAX_COUNT_FIELD, FARM_ID_FIELD, DESCRIPTION_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String clientToken;

    private final String displayName;

    private final String amountRequirementName;

    private final Integer maxCount;

    private final String farmId;

    private final String description;

    private CreateLimitRequest(BuilderImpl builder) {
        super(builder);
        this.clientToken = builder.clientToken;
        this.displayName = builder.displayName;
        this.amountRequirementName = builder.amountRequirementName;
        this.maxCount = builder.maxCount;
        this.farmId = builder.farmId;
        this.description = builder.description;
    }

    /**
     * <p>
     * The unique token which the server uses to recognize retries of the same request.
     * </p>
     * 
     * @return The unique token which the server uses to recognize retries of the same request.
     */
    public final String clientToken() {
        return clientToken;
    }

    /**
     * <p>
     * The display name of the limit.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the limit.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
     * <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
     * </p>
     * 
     * @return The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
     *         <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
     */
    public final String amountRequirementName() {
        return amountRequirementName;
    }

    /**
     * <p>
     * The maximum number of resources constrained by this limit. When all of the resources are in use, steps that
     * require the limit won't be scheduled until the resource is available.
     * </p>
     * <p>
     * The <code>maxCount</code> must not be 0. If the value is -1, there is no restriction on the number of resources
     * that can be acquired for this limit.
     * </p>
     * 
     * @return The maximum number of resources constrained by this limit. When all of the resources are in use, steps
     *         that require the limit won't be scheduled until the resource is available.</p>
     *         <p>
     *         The <code>maxCount</code> must not be 0. If the value is -1, there is no restriction on the number of
     *         resources that can be acquired for this limit.
     */
    public final Integer maxCount() {
        return maxCount;
    }

    /**
     * <p>
     * The farm ID of the farm that contains the limit.
     * </p>
     * 
     * @return The farm ID of the farm that contains the limit.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * A description of the limit. A description helps you identify the purpose of the limit.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return A description of the limit. A description helps you identify the purpose of the limit.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String description() {
        return description;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(clientToken());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(amountRequirementName());
        hashCode = 31 * hashCode + Objects.hashCode(maxCount());
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(description());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateLimitRequest)) {
            return false;
        }
        CreateLimitRequest other = (CreateLimitRequest) obj;
        return Objects.equals(clientToken(), other.clientToken()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(amountRequirementName(), other.amountRequirementName())
                && Objects.equals(maxCount(), other.maxCount()) && Objects.equals(farmId(), other.farmId())
                && Objects.equals(description(), other.description());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("CreateLimitRequest").add("ClientToken", clientToken()).add("DisplayName", displayName())
                .add("AmountRequirementName", amountRequirementName()).add("MaxCount", maxCount()).add("FarmId", farmId())
                .add("Description", description() == null ? null : "*** Sensitive Data Redacted ***").build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "clientToken":
            return Optional.ofNullable(clazz.cast(clientToken()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "amountRequirementName":
            return Optional.ofNullable(clazz.cast(amountRequirementName()));
        case "maxCount":
            return Optional.ofNullable(clazz.cast(maxCount()));
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "description":
            return Optional.ofNullable(clazz.cast(description()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("X-Amz-Client-Token", CLIENT_TOKEN_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("amountRequirementName", AMOUNT_REQUIREMENT_NAME_FIELD);
        map.put("maxCount", MAX_COUNT_FIELD);
        map.put("farmId", FARM_ID_FIELD);
        map.put("description", DESCRIPTION_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<CreateLimitRequest, T> g) {
        return obj -> g.apply((CreateLimitRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, CreateLimitRequest> {
        /**
         * <p>
         * The unique token which the server uses to recognize retries of the same request.
         * </p>
         * 
         * @param clientToken
         *        The unique token which the server uses to recognize retries of the same request.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder clientToken(String clientToken);

        /**
         * <p>
         * The display name of the limit.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the limit.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
         * <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
         * </p>
         * 
         * @param amountRequirementName
         *        The value that you specify as the <code>name</code> in the <code>amounts</code> field of the
         *        <code>hostRequirements</code> in a step of a job template to declare the limit requirement.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amountRequirementName(String amountRequirementName);

        /**
         * <p>
         * The maximum number of resources constrained by this limit. When all of the resources are in use, steps that
         * require the limit won't be scheduled until the resource is available.
         * </p>
         * <p>
         * The <code>maxCount</code> must not be 0. If the value is -1, there is no restriction on the number of
         * resources that can be acquired for this limit.
         * </p>
         * 
         * @param maxCount
         *        The maximum number of resources constrained by this limit. When all of the resources are in use, steps
         *        that require the limit won't be scheduled until the resource is available.</p>
         *        <p>
         *        The <code>maxCount</code> must not be 0. If the value is -1, there is no restriction on the number of
         *        resources that can be acquired for this limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder maxCount(Integer maxCount);

        /**
         * <p>
         * The farm ID of the farm that contains the limit.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the farm that contains the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * A description of the limit. A description helps you identify the purpose of the limit.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param description
         *        A description of the limit. A description helps you identify the purpose of the limit.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder description(String description);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String clientToken;

        private String displayName;

        private String amountRequirementName;

        private Integer maxCount;

        private String farmId;

        private String description;

        private BuilderImpl() {
        }

        private BuilderImpl(CreateLimitRequest model) {
            super(model);
            clientToken(model.clientToken);
            displayName(model.displayName);
            amountRequirementName(model.amountRequirementName);
            maxCount(model.maxCount);
            farmId(model.farmId);
            description(model.description);
        }

        public final String getClientToken() {
            return clientToken;
        }

        public final void setClientToken(String clientToken) {
            this.clientToken = clientToken;
        }

        @Override
        public final Builder clientToken(String clientToken) {
            this.clientToken = clientToken;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getAmountRequirementName() {
            return amountRequirementName;
        }

        public final void setAmountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
        }

        @Override
        public final Builder amountRequirementName(String amountRequirementName) {
            this.amountRequirementName = amountRequirementName;
            return this;
        }

        public final Integer getMaxCount() {
            return maxCount;
        }

        public final void setMaxCount(Integer maxCount) {
            this.maxCount = maxCount;
        }

        @Override
        public final Builder maxCount(Integer maxCount) {
            this.maxCount = maxCount;
            return this;
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getDescription() {
            return description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public CreateLimitRequest build() {
            return new CreateLimitRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
