/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class ListSessionsForWorkerResponse extends DeadlineResponse implements
        ToCopyableBuilder<ListSessionsForWorkerResponse.Builder, ListSessionsForWorkerResponse> {
    private static final SdkField<List<WorkerSessionSummary>> SESSIONS_FIELD = SdkField
            .<List<WorkerSessionSummary>> builder(MarshallingType.LIST)
            .memberName("sessions")
            .getter(getter(ListSessionsForWorkerResponse::sessions))
            .setter(setter(Builder::sessions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sessions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<WorkerSessionSummary> builder(MarshallingType.SDK_POJO)
                                            .constructor(WorkerSessionSummary::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("nextToken").getter(getter(ListSessionsForWorkerResponse::nextToken)).setter(setter(Builder::nextToken))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("nextToken").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(SESSIONS_FIELD,
            NEXT_TOKEN_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final List<WorkerSessionSummary> sessions;

    private final String nextToken;

    private ListSessionsForWorkerResponse(BuilderImpl builder) {
        super(builder);
        this.sessions = builder.sessions;
        this.nextToken = builder.nextToken;
    }

    /**
     * For responses, this returns true if the service returned a value for the Sessions property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasSessions() {
        return sessions != null && !(sessions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The sessions in the response.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSessions} method.
     * </p>
     * 
     * @return The sessions in the response.
     */
    public final List<WorkerSessionSummary> sessions() {
        return sessions;
    }

    /**
     * <p>
     * The token for the next set of results, or <code>null</code> to start from the beginning.
     * </p>
     * 
     * @return The token for the next set of results, or <code>null</code> to start from the beginning.
     */
    public final String nextToken() {
        return nextToken;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(hasSessions() ? sessions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(nextToken());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ListSessionsForWorkerResponse)) {
            return false;
        }
        ListSessionsForWorkerResponse other = (ListSessionsForWorkerResponse) obj;
        return hasSessions() == other.hasSessions() && Objects.equals(sessions(), other.sessions())
                && Objects.equals(nextToken(), other.nextToken());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ListSessionsForWorkerResponse").add("Sessions", hasSessions() ? sessions() : null)
                .add("NextToken", nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "sessions":
            return Optional.ofNullable(clazz.cast(sessions()));
        case "nextToken":
            return Optional.ofNullable(clazz.cast(nextToken()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("sessions", SESSIONS_FIELD);
        map.put("nextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ListSessionsForWorkerResponse, T> g) {
        return obj -> g.apply((ListSessionsForWorkerResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineResponse.Builder, SdkPojo, CopyableBuilder<Builder, ListSessionsForWorkerResponse> {
        /**
         * <p>
         * The sessions in the response.
         * </p>
         * 
         * @param sessions
         *        The sessions in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(Collection<WorkerSessionSummary> sessions);

        /**
         * <p>
         * The sessions in the response.
         * </p>
         * 
         * @param sessions
         *        The sessions in the response.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sessions(WorkerSessionSummary... sessions);

        /**
         * <p>
         * The sessions in the response.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.WorkerSessionSummary.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.WorkerSessionSummary#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.WorkerSessionSummary.Builder#build()} is called
         * immediately and its result is passed to {@link #sessions(List<WorkerSessionSummary>)}.
         * 
         * @param sessions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.WorkerSessionSummary.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sessions(java.util.Collection<WorkerSessionSummary>)
         */
        Builder sessions(Consumer<WorkerSessionSummary.Builder>... sessions);

        /**
         * <p>
         * The token for the next set of results, or <code>null</code> to start from the beginning.
         * </p>
         * 
         * @param nextToken
         *        The token for the next set of results, or <code>null</code> to start from the beginning.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder nextToken(String nextToken);
    }

    static final class BuilderImpl extends DeadlineResponse.BuilderImpl implements Builder {
        private List<WorkerSessionSummary> sessions = DefaultSdkAutoConstructList.getInstance();

        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(ListSessionsForWorkerResponse model) {
            super(model);
            sessions(model.sessions);
            nextToken(model.nextToken);
        }

        public final List<WorkerSessionSummary.Builder> getSessions() {
            List<WorkerSessionSummary.Builder> result = ListSessionsForWorkerSummariesCopier.copyToBuilder(this.sessions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSessions(Collection<WorkerSessionSummary.BuilderImpl> sessions) {
            this.sessions = ListSessionsForWorkerSummariesCopier.copyFromBuilder(sessions);
        }

        @Override
        public final Builder sessions(Collection<WorkerSessionSummary> sessions) {
            this.sessions = ListSessionsForWorkerSummariesCopier.copy(sessions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(WorkerSessionSummary... sessions) {
            sessions(Arrays.asList(sessions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sessions(Consumer<WorkerSessionSummary.Builder>... sessions) {
            sessions(Stream.of(sessions).map(c -> WorkerSessionSummary.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public ListSessionsForWorkerResponse build() {
            return new ListSessionsForWorkerResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
