/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a queue-fleet association.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueFleetAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<QueueFleetAssociationSummary.Builder, QueueFleetAssociationSummary> {
    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(QueueFleetAssociationSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(QueueFleetAssociationSummary::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(QueueFleetAssociationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(QueueFleetAssociationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(QueueFleetAssociationSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(QueueFleetAssociationSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(QueueFleetAssociationSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_ID_FIELD,
            FLEET_ID_FIELD, STATUS_FIELD, CREATED_AT_FIELD, CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String queueId;

    private final String fleetId;

    private final String status;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private QueueFleetAssociationSummary(BuilderImpl builder) {
        this.queueId = builder.queueId;
        this.fleetId = builder.fleetId;
        this.status = builder.status;
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
    }

    /**
     * <p>
     * The queue ID.
     * </p>
     * 
     * @return The queue ID.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The fleet ID.
     * </p>
     * 
     * @return The fleet ID.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The status of task scheduling in the queue-fleet association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–Association is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is completing
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is canceling
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>–Association has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueFleetAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of task scheduling in the queue-fleet association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–Association is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
     *         completing current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is
     *         canceling current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code>–Association has been stopped.
     *         </p>
     *         </li>
     * @see QueueFleetAssociationStatus
     */
    public final QueueFleetAssociationStatus status() {
        return QueueFleetAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of task scheduling in the queue-fleet association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code>–Association is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is completing
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is canceling
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code>–Association has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueFleetAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of task scheduling in the queue-fleet association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code>–Association is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
     *         completing current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is
     *         canceling current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code>–Association has been stopped.
     *         </p>
     *         </li>
     * @see QueueFleetAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The date and time the resource was created.
     * </p>
     * 
     * @return The date and time the resource was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user or system that created this resource.
     * </p>
     * 
     * @return The user or system that created this resource.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The date and time the resource was updated.
     * </p>
     * 
     * @return The date and time the resource was updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user or system that updated this resource.
     * </p>
     * 
     * @return The user or system that updated this resource.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueFleetAssociationSummary)) {
            return false;
        }
        QueueFleetAssociationSummary other = (QueueFleetAssociationSummary) obj;
        return Objects.equals(queueId(), other.queueId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(statusAsString(), other.statusAsString()) && Objects.equals(createdAt(), other.createdAt())
                && Objects.equals(createdBy(), other.createdBy()) && Objects.equals(updatedAt(), other.updatedAt())
                && Objects.equals(updatedBy(), other.updatedBy());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueFleetAssociationSummary").add("QueueId", queueId()).add("FleetId", fleetId())
                .add("Status", statusAsString()).add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueueFleetAssociationSummary, T> g) {
        return obj -> g.apply((QueueFleetAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueFleetAssociationSummary> {
        /**
         * <p>
         * The queue ID.
         * </p>
         * 
         * @param queueId
         *        The queue ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The fleet ID.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The status of task scheduling in the queue-fleet association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–Association is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
         * completing current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is canceling
         * current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code>–Association has been stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of task scheduling in the queue-fleet association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–Association is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
         *        completing current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is
         *        canceling current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code>–Association has been stopped.
         *        </p>
         *        </li>
         * @see QueueFleetAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueFleetAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of task scheduling in the queue-fleet association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code>–Association is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
         * completing current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is canceling
         * current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code>–Association has been stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of task scheduling in the queue-fleet association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code>–Association is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_SCHEDULING_AND_COMPLETE_TASKS</code>–Association has stopped scheduling new tasks and is
         *        completing current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_SCHEDULING_AND_CANCEL_TASKS</code>–Association has stopped scheduling new tasks and is
         *        canceling current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code>–Association has been stopped.
         *        </p>
         *        </li>
         * @see QueueFleetAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueFleetAssociationStatus
         */
        Builder status(QueueFleetAssociationStatus status);

        /**
         * <p>
         * The date and time the resource was created.
         * </p>
         * 
         * @param createdAt
         *        The date and time the resource was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user or system that created this resource.
         * </p>
         * 
         * @param createdBy
         *        The user or system that created this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The date and time the resource was updated.
         * </p>
         * 
         * @param updatedAt
         *        The date and time the resource was updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user or system that updated this resource.
         * </p>
         * 
         * @param updatedBy
         *        The user or system that updated this resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);
    }

    static final class BuilderImpl implements Builder {
        private String queueId;

        private String fleetId;

        private String status;

        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueFleetAssociationSummary model) {
            queueId(model.queueId);
            fleetId(model.fleetId);
            status(model.status);
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueFleetAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        @Override
        public QueueFleetAssociationSummary build() {
            return new QueueFleetAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
