/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the association between a queue and a limit.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class QueueLimitAssociationSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<QueueLimitAssociationSummary.Builder, QueueLimitAssociationSummary> {
    private static final SdkField<Instant> CREATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("createdAt")
            .getter(getter(QueueLimitAssociationSummary::createdAt))
            .setter(setter(Builder::createdAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> CREATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("createdBy").getter(getter(QueueLimitAssociationSummary::createdBy)).setter(setter(Builder::createdBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("createdBy").build()).build();

    private static final SdkField<Instant> UPDATED_AT_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("updatedAt")
            .getter(getter(QueueLimitAssociationSummary::updatedAt))
            .setter(setter(Builder::updatedAt))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedAt").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> UPDATED_BY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("updatedBy").getter(getter(QueueLimitAssociationSummary::updatedBy)).setter(setter(Builder::updatedBy))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("updatedBy").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(QueueLimitAssociationSummary::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueId").build()).build();

    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("limitId").getter(getter(QueueLimitAssociationSummary::limitId)).setter(setter(Builder::limitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(QueueLimitAssociationSummary::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(CREATED_AT_FIELD,
            CREATED_BY_FIELD, UPDATED_AT_FIELD, UPDATED_BY_FIELD, QUEUE_ID_FIELD, LIMIT_ID_FIELD, STATUS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final Instant createdAt;

    private final String createdBy;

    private final Instant updatedAt;

    private final String updatedBy;

    private final String queueId;

    private final String limitId;

    private final String status;

    private QueueLimitAssociationSummary(BuilderImpl builder) {
        this.createdAt = builder.createdAt;
        this.createdBy = builder.createdBy;
        this.updatedAt = builder.updatedAt;
        this.updatedBy = builder.updatedBy;
        this.queueId = builder.queueId;
        this.limitId = builder.limitId;
        this.status = builder.status;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the association was created.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the association was created.
     */
    public final Instant createdAt() {
        return createdAt;
    }

    /**
     * <p>
     * The user identifier of the person that created the association.
     * </p>
     * 
     * @return The user identifier of the person that created the association.
     */
    public final String createdBy() {
        return createdBy;
    }

    /**
     * <p>
     * The Unix timestamp of the date and time that the association was last updated.
     * </p>
     * 
     * @return The Unix timestamp of the date and time that the association was last updated.
     */
    public final Instant updatedAt() {
        return updatedAt;
    }

    /**
     * <p>
     * The user identifier of the person that updated the association.
     * </p>
     * 
     * @return The user identifier of the person that updated the association.
     */
    public final String updatedBy() {
        return updatedBy;
    }

    /**
     * <p>
     * The unique identifier of the queue in the association.
     * </p>
     * 
     * @return The unique identifier of the queue in the association.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The unique identifier of the limit in the association.
     * </p>
     * 
     * @return The unique identifier of the limit in the association.
     */
    public final String limitId() {
        return limitId;
    }

    /**
     * <p>
     * The status of task scheduling in the queue-limit association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - Association is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is completing
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is canceling
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - Association has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueLimitAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of task scheduling in the queue-limit association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - Association is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
     *         completing current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
     *         canceling current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - Association has been stopped.
     *         </p>
     *         </li>
     * @see QueueLimitAssociationStatus
     */
    public final QueueLimitAssociationStatus status() {
        return QueueLimitAssociationStatus.fromValue(status);
    }

    /**
     * <p>
     * The status of task scheduling in the queue-limit association.
     * </p>
     * <ul>
     * <li>
     * <p>
     * <code>ACTIVE</code> - Association is active.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is completing
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is canceling
     * current tasks.
     * </p>
     * </li>
     * <li>
     * <p>
     * <code>STOPPED</code> - Association has been stopped.
     * </p>
     * </li>
     * </ul>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link QueueLimitAssociationStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is
     * available from {@link #statusAsString}.
     * </p>
     * 
     * @return The status of task scheduling in the queue-limit association.</p>
     *         <ul>
     *         <li>
     *         <p>
     *         <code>ACTIVE</code> - Association is active.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
     *         completing current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
     *         canceling current tasks.
     *         </p>
     *         </li>
     *         <li>
     *         <p>
     *         <code>STOPPED</code> - Association has been stopped.
     *         </p>
     *         </li>
     * @see QueueLimitAssociationStatus
     */
    public final String statusAsString() {
        return status;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(createdAt());
        hashCode = 31 * hashCode + Objects.hashCode(createdBy());
        hashCode = 31 * hashCode + Objects.hashCode(updatedAt());
        hashCode = 31 * hashCode + Objects.hashCode(updatedBy());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(limitId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof QueueLimitAssociationSummary)) {
            return false;
        }
        QueueLimitAssociationSummary other = (QueueLimitAssociationSummary) obj;
        return Objects.equals(createdAt(), other.createdAt()) && Objects.equals(createdBy(), other.createdBy())
                && Objects.equals(updatedAt(), other.updatedAt()) && Objects.equals(updatedBy(), other.updatedBy())
                && Objects.equals(queueId(), other.queueId()) && Objects.equals(limitId(), other.limitId())
                && Objects.equals(statusAsString(), other.statusAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("QueueLimitAssociationSummary").add("CreatedAt", createdAt()).add("CreatedBy", createdBy())
                .add("UpdatedAt", updatedAt()).add("UpdatedBy", updatedBy()).add("QueueId", queueId()).add("LimitId", limitId())
                .add("Status", statusAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "createdAt":
            return Optional.ofNullable(clazz.cast(createdAt()));
        case "createdBy":
            return Optional.ofNullable(clazz.cast(createdBy()));
        case "updatedAt":
            return Optional.ofNullable(clazz.cast(updatedAt()));
        case "updatedBy":
            return Optional.ofNullable(clazz.cast(updatedBy()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "limitId":
            return Optional.ofNullable(clazz.cast(limitId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("createdAt", CREATED_AT_FIELD);
        map.put("createdBy", CREATED_BY_FIELD);
        map.put("updatedAt", UPDATED_AT_FIELD);
        map.put("updatedBy", UPDATED_BY_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("status", STATUS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<QueueLimitAssociationSummary, T> g) {
        return obj -> g.apply((QueueLimitAssociationSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, QueueLimitAssociationSummary> {
        /**
         * <p>
         * The Unix timestamp of the date and time that the association was created.
         * </p>
         * 
         * @param createdAt
         *        The Unix timestamp of the date and time that the association was created.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdAt(Instant createdAt);

        /**
         * <p>
         * The user identifier of the person that created the association.
         * </p>
         * 
         * @param createdBy
         *        The user identifier of the person that created the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder createdBy(String createdBy);

        /**
         * <p>
         * The Unix timestamp of the date and time that the association was last updated.
         * </p>
         * 
         * @param updatedAt
         *        The Unix timestamp of the date and time that the association was last updated.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedAt(Instant updatedAt);

        /**
         * <p>
         * The user identifier of the person that updated the association.
         * </p>
         * 
         * @param updatedBy
         *        The user identifier of the person that updated the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder updatedBy(String updatedBy);

        /**
         * <p>
         * The unique identifier of the queue in the association.
         * </p>
         * 
         * @param queueId
         *        The unique identifier of the queue in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The unique identifier of the limit in the association.
         * </p>
         * 
         * @param limitId
         *        The unique identifier of the limit in the association.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitId(String limitId);

        /**
         * <p>
         * The status of task scheduling in the queue-limit association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - Association is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
         * completing current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
         * canceling current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> - Association has been stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of task scheduling in the queue-limit association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - Association is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
         *        completing current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
         *        canceling current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> - Association has been stopped.
         *        </p>
         *        </li>
         * @see QueueLimitAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueLimitAssociationStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The status of task scheduling in the queue-limit association.
         * </p>
         * <ul>
         * <li>
         * <p>
         * <code>ACTIVE</code> - Association is active.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
         * completing current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
         * canceling current tasks.
         * </p>
         * </li>
         * <li>
         * <p>
         * <code>STOPPED</code> - Association has been stopped.
         * </p>
         * </li>
         * </ul>
         * 
         * @param status
         *        The status of task scheduling in the queue-limit association.</p>
         *        <ul>
         *        <li>
         *        <p>
         *        <code>ACTIVE</code> - Association is active.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_LIMIT_USAGE_AND_COMPLETE_TASKS</code> - Association has stopped scheduling new tasks and is
         *        completing current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOP_LIMIT_USAGE_AND_CANCEL_TASKS</code> - Association has stopped scheduling new tasks and is
         *        canceling current tasks.
         *        </p>
         *        </li>
         *        <li>
         *        <p>
         *        <code>STOPPED</code> - Association has been stopped.
         *        </p>
         *        </li>
         * @see QueueLimitAssociationStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see QueueLimitAssociationStatus
         */
        Builder status(QueueLimitAssociationStatus status);
    }

    static final class BuilderImpl implements Builder {
        private Instant createdAt;

        private String createdBy;

        private Instant updatedAt;

        private String updatedBy;

        private String queueId;

        private String limitId;

        private String status;

        private BuilderImpl() {
        }

        private BuilderImpl(QueueLimitAssociationSummary model) {
            createdAt(model.createdAt);
            createdBy(model.createdBy);
            updatedAt(model.updatedAt);
            updatedBy(model.updatedBy);
            queueId(model.queueId);
            limitId(model.limitId);
            status(model.status);
        }

        public final Instant getCreatedAt() {
            return createdAt;
        }

        public final void setCreatedAt(Instant createdAt) {
            this.createdAt = createdAt;
        }

        @Override
        public final Builder createdAt(Instant createdAt) {
            this.createdAt = createdAt;
            return this;
        }

        public final String getCreatedBy() {
            return createdBy;
        }

        public final void setCreatedBy(String createdBy) {
            this.createdBy = createdBy;
        }

        @Override
        public final Builder createdBy(String createdBy) {
            this.createdBy = createdBy;
            return this;
        }

        public final Instant getUpdatedAt() {
            return updatedAt;
        }

        public final void setUpdatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
        }

        @Override
        public final Builder updatedAt(Instant updatedAt) {
            this.updatedAt = updatedAt;
            return this;
        }

        public final String getUpdatedBy() {
            return updatedBy;
        }

        public final void setUpdatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
        }

        @Override
        public final Builder updatedBy(String updatedBy) {
            this.updatedBy = updatedBy;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getLimitId() {
            return limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(QueueLimitAssociationStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        @Override
        public QueueLimitAssociationSummary build() {
            return new QueueLimitAssociationSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
