/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class SearchWorkersRequest extends DeadlineRequest implements
        ToCopyableBuilder<SearchWorkersRequest.Builder, SearchWorkersRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(SearchWorkersRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fleetIds")
            .getter(getter(SearchWorkersRequest::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<SearchGroupedFilterExpressions> FILTER_EXPRESSIONS_FIELD = SdkField
            .<SearchGroupedFilterExpressions> builder(MarshallingType.SDK_POJO).memberName("filterExpressions")
            .getter(getter(SearchWorkersRequest::filterExpressions)).setter(setter(Builder::filterExpressions))
            .constructor(SearchGroupedFilterExpressions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("filterExpressions").build()).build();

    private static final SdkField<List<SearchSortExpression>> SORT_EXPRESSIONS_FIELD = SdkField
            .<List<SearchSortExpression>> builder(MarshallingType.LIST)
            .memberName("sortExpressions")
            .getter(getter(SearchWorkersRequest::sortExpressions))
            .setter(setter(Builder::sortExpressions))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("sortExpressions").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<SearchSortExpression> builder(MarshallingType.SDK_POJO)
                                            .constructor(SearchSortExpression::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<Integer> ITEM_OFFSET_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("itemOffset").getter(getter(SearchWorkersRequest::itemOffset)).setter(setter(Builder::itemOffset))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("itemOffset").build()).build();

    private static final SdkField<Integer> PAGE_SIZE_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER)
            .memberName("pageSize").getter(getter(SearchWorkersRequest::pageSize)).setter(setter(Builder::pageSize))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("pageSize").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD,
            FLEET_IDS_FIELD, FILTER_EXPRESSIONS_FIELD, SORT_EXPRESSIONS_FIELD, ITEM_OFFSET_FIELD, PAGE_SIZE_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final List<String> fleetIds;

    private final SearchGroupedFilterExpressions filterExpressions;

    private final List<SearchSortExpression> sortExpressions;

    private final Integer itemOffset;

    private final Integer pageSize;

    private SearchWorkersRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetIds = builder.fleetIds;
        this.filterExpressions = builder.filterExpressions;
        this.sortExpressions = builder.sortExpressions;
        this.itemOffset = builder.itemOffset;
        this.pageSize = builder.pageSize;
    }

    /**
     * <p>
     * The farm ID in the workers search.
     * </p>
     * 
     * @return The farm ID in the workers search.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleetIds() {
        return fleetIds != null && !(fleetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The fleet ID of the workers to search for.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetIds} method.
     * </p>
     * 
     * @return The fleet ID of the workers to search for.
     */
    public final List<String> fleetIds() {
        return fleetIds;
    }

    /**
     * <p>
     * The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search strings
     * in a resource.
     * <p>
     * You can use two groupings per search each within parenthesis <code>()</code>.
     * </p>
     * </p>
     * 
     * @return The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search
     *         strings in a resource.
     *         <p>
     *         You can use two groupings per search each within parenthesis <code>()</code>.
     *         </p>
     */
    public final SearchGroupedFilterExpressions filterExpressions() {
        return filterExpressions;
    }

    /**
     * For responses, this returns true if the service returned a value for the SortExpressions property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasSortExpressions() {
        return sortExpressions != null && !(sortExpressions instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The search terms for a resource.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasSortExpressions} method.
     * </p>
     * 
     * @return The search terms for a resource.
     */
    public final List<SearchSortExpression> sortExpressions() {
        return sortExpressions;
    }

    /**
     * <p>
     * Defines how far into the scrollable list to start the return of results.
     * </p>
     * 
     * @return Defines how far into the scrollable list to start the return of results.
     */
    public final Integer itemOffset() {
        return itemOffset;
    }

    /**
     * <p>
     * Specifies the number of items per page for the resource.
     * </p>
     * 
     * @return Specifies the number of items per page for the resource.
     */
    public final Integer pageSize() {
        return pageSize;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetIds() ? fleetIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(filterExpressions());
        hashCode = 31 * hashCode + Objects.hashCode(hasSortExpressions() ? sortExpressions() : null);
        hashCode = 31 * hashCode + Objects.hashCode(itemOffset());
        hashCode = 31 * hashCode + Objects.hashCode(pageSize());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SearchWorkersRequest)) {
            return false;
        }
        SearchWorkersRequest other = (SearchWorkersRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && hasFleetIds() == other.hasFleetIds()
                && Objects.equals(fleetIds(), other.fleetIds()) && Objects.equals(filterExpressions(), other.filterExpressions())
                && hasSortExpressions() == other.hasSortExpressions()
                && Objects.equals(sortExpressions(), other.sortExpressions()) && Objects.equals(itemOffset(), other.itemOffset())
                && Objects.equals(pageSize(), other.pageSize());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SearchWorkersRequest").add("FarmId", farmId())
                .add("FleetIds", hasFleetIds() ? fleetIds() : null).add("FilterExpressions", filterExpressions())
                .add("SortExpressions", hasSortExpressions() ? sortExpressions() : null).add("ItemOffset", itemOffset())
                .add("PageSize", pageSize()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        case "filterExpressions":
            return Optional.ofNullable(clazz.cast(filterExpressions()));
        case "sortExpressions":
            return Optional.ofNullable(clazz.cast(sortExpressions()));
        case "itemOffset":
            return Optional.ofNullable(clazz.cast(itemOffset()));
        case "pageSize":
            return Optional.ofNullable(clazz.cast(pageSize()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("fleetIds", FLEET_IDS_FIELD);
        map.put("filterExpressions", FILTER_EXPRESSIONS_FIELD);
        map.put("sortExpressions", SORT_EXPRESSIONS_FIELD);
        map.put("itemOffset", ITEM_OFFSET_FIELD);
        map.put("pageSize", PAGE_SIZE_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SearchWorkersRequest, T> g) {
        return obj -> g.apply((SearchWorkersRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, SearchWorkersRequest> {
        /**
         * <p>
         * The farm ID in the workers search.
         * </p>
         * 
         * @param farmId
         *        The farm ID in the workers search.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID of the workers to search for.
         * </p>
         * 
         * @param fleetIds
         *        The fleet ID of the workers to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * The fleet ID of the workers to search for.
         * </p>
         * 
         * @param fleetIds
         *        The fleet ID of the workers to search for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);

        /**
         * <p>
         * The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search
         * strings in a resource.
         * <p>
         * You can use two groupings per search each within parenthesis <code>()</code>.
         * </p>
         * </p>
         * 
         * @param filterExpressions
         *        The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of
         *        search strings in a resource.
         *        <p>
         *        You can use two groupings per search each within parenthesis <code>()</code>.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder filterExpressions(SearchGroupedFilterExpressions filterExpressions);

        /**
         * <p>
         * The filter expression, <code>AND</code> or <code>OR</code>, to use when searching among a group of search
         * strings in a resource.
         * <p>
         * You can use two groupings per search each within parenthesis <code>()</code>.
         * </p>
         * </p> This is a convenience method that creates an instance of the
         * {@link SearchGroupedFilterExpressions.Builder} avoiding the need to create one manually via
         * {@link SearchGroupedFilterExpressions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SearchGroupedFilterExpressions.Builder#build()} is called
         * immediately and its result is passed to {@link #filterExpressions(SearchGroupedFilterExpressions)}.
         * 
         * @param filterExpressions
         *        a consumer that will call methods on {@link SearchGroupedFilterExpressions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #filterExpressions(SearchGroupedFilterExpressions)
         */
        default Builder filterExpressions(Consumer<SearchGroupedFilterExpressions.Builder> filterExpressions) {
            return filterExpressions(SearchGroupedFilterExpressions.builder().applyMutation(filterExpressions).build());
        }

        /**
         * <p>
         * The search terms for a resource.
         * </p>
         * 
         * @param sortExpressions
         *        The search terms for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortExpressions(Collection<SearchSortExpression> sortExpressions);

        /**
         * <p>
         * The search terms for a resource.
         * </p>
         * 
         * @param sortExpressions
         *        The search terms for a resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder sortExpressions(SearchSortExpression... sortExpressions);

        /**
         * <p>
         * The search terms for a resource.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.SearchSortExpression.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.SearchSortExpression#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.SearchSortExpression.Builder#build()} is called
         * immediately and its result is passed to {@link #sortExpressions(List<SearchSortExpression>)}.
         * 
         * @param sortExpressions
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.SearchSortExpression.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #sortExpressions(java.util.Collection<SearchSortExpression>)
         */
        Builder sortExpressions(Consumer<SearchSortExpression.Builder>... sortExpressions);

        /**
         * <p>
         * Defines how far into the scrollable list to start the return of results.
         * </p>
         * 
         * @param itemOffset
         *        Defines how far into the scrollable list to start the return of results.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder itemOffset(Integer itemOffset);

        /**
         * <p>
         * Specifies the number of items per page for the resource.
         * </p>
         * 
         * @param pageSize
         *        Specifies the number of items per page for the resource.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder pageSize(Integer pageSize);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private SearchGroupedFilterExpressions filterExpressions;

        private List<SearchSortExpression> sortExpressions = DefaultSdkAutoConstructList.getInstance();

        private Integer itemOffset;

        private Integer pageSize;

        private BuilderImpl() {
        }

        private BuilderImpl(SearchWorkersRequest model) {
            super(model);
            farmId(model.farmId);
            fleetIds(model.fleetIds);
            filterExpressions(model.filterExpressions);
            sortExpressions(model.sortExpressions);
            itemOffset(model.itemOffset);
            pageSize(model.pageSize);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            this.fleetIds = SearchWorkersRequestFleetIdsListCopier.copy(fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            this.fleetIds = SearchWorkersRequestFleetIdsListCopier.copy(fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        public final SearchGroupedFilterExpressions.Builder getFilterExpressions() {
            return filterExpressions != null ? filterExpressions.toBuilder() : null;
        }

        public final void setFilterExpressions(SearchGroupedFilterExpressions.BuilderImpl filterExpressions) {
            this.filterExpressions = filterExpressions != null ? filterExpressions.build() : null;
        }

        @Override
        public final Builder filterExpressions(SearchGroupedFilterExpressions filterExpressions) {
            this.filterExpressions = filterExpressions;
            return this;
        }

        public final List<SearchSortExpression.Builder> getSortExpressions() {
            List<SearchSortExpression.Builder> result = SearchSortExpressionsCopier.copyToBuilder(this.sortExpressions);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setSortExpressions(Collection<SearchSortExpression.BuilderImpl> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copyFromBuilder(sortExpressions);
        }

        @Override
        public final Builder sortExpressions(Collection<SearchSortExpression> sortExpressions) {
            this.sortExpressions = SearchSortExpressionsCopier.copy(sortExpressions);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(SearchSortExpression... sortExpressions) {
            sortExpressions(Arrays.asList(sortExpressions));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder sortExpressions(Consumer<SearchSortExpression.Builder>... sortExpressions) {
            sortExpressions(Stream.of(sortExpressions).map(c -> SearchSortExpression.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final Integer getItemOffset() {
            return itemOffset;
        }

        public final void setItemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
        }

        @Override
        public final Builder itemOffset(Integer itemOffset) {
            this.itemOffset = itemOffset;
            return this;
        }

        public final Integer getPageSize() {
            return pageSize;
        }

        public final void setPageSize(Integer pageSize) {
            this.pageSize = pageSize;
        }

        @Override
        public final Builder pageSize(Integer pageSize) {
            this.pageSize = pageSize;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public SearchWorkersRequest build() {
            return new SearchWorkersRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
