/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration details for a service managed Amazon EC2 fleet.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class ServiceManagedEc2FleetConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<ServiceManagedEc2FleetConfiguration.Builder, ServiceManagedEc2FleetConfiguration> {
    private static final SdkField<ServiceManagedEc2InstanceCapabilities> INSTANCE_CAPABILITIES_FIELD = SdkField
            .<ServiceManagedEc2InstanceCapabilities> builder(MarshallingType.SDK_POJO).memberName("instanceCapabilities")
            .getter(getter(ServiceManagedEc2FleetConfiguration::instanceCapabilities))
            .setter(setter(Builder::instanceCapabilities)).constructor(ServiceManagedEc2InstanceCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceCapabilities").build())
            .build();

    private static final SdkField<ServiceManagedEc2InstanceMarketOptions> INSTANCE_MARKET_OPTIONS_FIELD = SdkField
            .<ServiceManagedEc2InstanceMarketOptions> builder(MarshallingType.SDK_POJO).memberName("instanceMarketOptions")
            .getter(getter(ServiceManagedEc2FleetConfiguration::instanceMarketOptions))
            .setter(setter(Builder::instanceMarketOptions)).constructor(ServiceManagedEc2InstanceMarketOptions::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("instanceMarketOptions").build())
            .build();

    private static final SdkField<VpcConfiguration> VPC_CONFIGURATION_FIELD = SdkField
            .<VpcConfiguration> builder(MarshallingType.SDK_POJO).memberName("vpcConfiguration")
            .getter(getter(ServiceManagedEc2FleetConfiguration::vpcConfiguration)).setter(setter(Builder::vpcConfiguration))
            .constructor(VpcConfiguration::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("vpcConfiguration").build()).build();

    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(ServiceManagedEc2FleetConfiguration::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(INSTANCE_CAPABILITIES_FIELD,
            INSTANCE_MARKET_OPTIONS_FIELD, VPC_CONFIGURATION_FIELD, STORAGE_PROFILE_ID_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final ServiceManagedEc2InstanceCapabilities instanceCapabilities;

    private final ServiceManagedEc2InstanceMarketOptions instanceMarketOptions;

    private final VpcConfiguration vpcConfiguration;

    private final String storageProfileId;

    private ServiceManagedEc2FleetConfiguration(BuilderImpl builder) {
        this.instanceCapabilities = builder.instanceCapabilities;
        this.instanceMarketOptions = builder.instanceMarketOptions;
        this.vpcConfiguration = builder.vpcConfiguration;
        this.storageProfileId = builder.storageProfileId;
    }

    /**
     * <p>
     * The Amazon EC2 instance capabilities.
     * </p>
     * 
     * @return The Amazon EC2 instance capabilities.
     */
    public final ServiceManagedEc2InstanceCapabilities instanceCapabilities() {
        return instanceCapabilities;
    }

    /**
     * <p>
     * The Amazon EC2 market type.
     * </p>
     * 
     * @return The Amazon EC2 market type.
     */
    public final ServiceManagedEc2InstanceMarketOptions instanceMarketOptions() {
        return instanceMarketOptions;
    }

    /**
     * <p>
     * The VPC configuration details for a service managed Amazon EC2 fleet.
     * </p>
     * 
     * @return The VPC configuration details for a service managed Amazon EC2 fleet.
     */
    public final VpcConfiguration vpcConfiguration() {
        return vpcConfiguration;
    }

    /**
     * <p>
     * The storage profile ID.
     * </p>
     * 
     * @return The storage profile ID.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(instanceCapabilities());
        hashCode = 31 * hashCode + Objects.hashCode(instanceMarketOptions());
        hashCode = 31 * hashCode + Objects.hashCode(vpcConfiguration());
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof ServiceManagedEc2FleetConfiguration)) {
            return false;
        }
        ServiceManagedEc2FleetConfiguration other = (ServiceManagedEc2FleetConfiguration) obj;
        return Objects.equals(instanceCapabilities(), other.instanceCapabilities())
                && Objects.equals(instanceMarketOptions(), other.instanceMarketOptions())
                && Objects.equals(vpcConfiguration(), other.vpcConfiguration())
                && Objects.equals(storageProfileId(), other.storageProfileId());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("ServiceManagedEc2FleetConfiguration").add("InstanceCapabilities", instanceCapabilities())
                .add("InstanceMarketOptions", instanceMarketOptions()).add("VpcConfiguration", vpcConfiguration())
                .add("StorageProfileId", storageProfileId()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "instanceCapabilities":
            return Optional.ofNullable(clazz.cast(instanceCapabilities()));
        case "instanceMarketOptions":
            return Optional.ofNullable(clazz.cast(instanceMarketOptions()));
        case "vpcConfiguration":
            return Optional.ofNullable(clazz.cast(vpcConfiguration()));
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("instanceCapabilities", INSTANCE_CAPABILITIES_FIELD);
        map.put("instanceMarketOptions", INSTANCE_MARKET_OPTIONS_FIELD);
        map.put("vpcConfiguration", VPC_CONFIGURATION_FIELD);
        map.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<ServiceManagedEc2FleetConfiguration, T> g) {
        return obj -> g.apply((ServiceManagedEc2FleetConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, ServiceManagedEc2FleetConfiguration> {
        /**
         * <p>
         * The Amazon EC2 instance capabilities.
         * </p>
         * 
         * @param instanceCapabilities
         *        The Amazon EC2 instance capabilities.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceCapabilities(ServiceManagedEc2InstanceCapabilities instanceCapabilities);

        /**
         * <p>
         * The Amazon EC2 instance capabilities.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceManagedEc2InstanceCapabilities.Builder} avoiding the need to create one manually via
         * {@link ServiceManagedEc2InstanceCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedEc2InstanceCapabilities.Builder#build()} is called
         * immediately and its result is passed to {@link #instanceCapabilities(ServiceManagedEc2InstanceCapabilities)}.
         * 
         * @param instanceCapabilities
         *        a consumer that will call methods on {@link ServiceManagedEc2InstanceCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceCapabilities(ServiceManagedEc2InstanceCapabilities)
         */
        default Builder instanceCapabilities(Consumer<ServiceManagedEc2InstanceCapabilities.Builder> instanceCapabilities) {
            return instanceCapabilities(ServiceManagedEc2InstanceCapabilities.builder().applyMutation(instanceCapabilities)
                    .build());
        }

        /**
         * <p>
         * The Amazon EC2 market type.
         * </p>
         * 
         * @param instanceMarketOptions
         *        The Amazon EC2 market type.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions instanceMarketOptions);

        /**
         * <p>
         * The Amazon EC2 market type.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link ServiceManagedEc2InstanceMarketOptions.Builder} avoiding the need to create one manually via
         * {@link ServiceManagedEc2InstanceMarketOptions#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link ServiceManagedEc2InstanceMarketOptions.Builder#build()} is called
         * immediately and its result is passed to
         * {@link #instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions)}.
         * 
         * @param instanceMarketOptions
         *        a consumer that will call methods on {@link ServiceManagedEc2InstanceMarketOptions.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions)
         */
        default Builder instanceMarketOptions(Consumer<ServiceManagedEc2InstanceMarketOptions.Builder> instanceMarketOptions) {
            return instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions.builder().applyMutation(instanceMarketOptions)
                    .build());
        }

        /**
         * <p>
         * The VPC configuration details for a service managed Amazon EC2 fleet.
         * </p>
         * 
         * @param vpcConfiguration
         *        The VPC configuration details for a service managed Amazon EC2 fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder vpcConfiguration(VpcConfiguration vpcConfiguration);

        /**
         * <p>
         * The VPC configuration details for a service managed Amazon EC2 fleet.
         * </p>
         * This is a convenience method that creates an instance of the {@link VpcConfiguration.Builder} avoiding the
         * need to create one manually via {@link VpcConfiguration#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link VpcConfiguration.Builder#build()} is called immediately and its
         * result is passed to {@link #vpcConfiguration(VpcConfiguration)}.
         * 
         * @param vpcConfiguration
         *        a consumer that will call methods on {@link VpcConfiguration.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #vpcConfiguration(VpcConfiguration)
         */
        default Builder vpcConfiguration(Consumer<VpcConfiguration.Builder> vpcConfiguration) {
            return vpcConfiguration(VpcConfiguration.builder().applyMutation(vpcConfiguration).build());
        }

        /**
         * <p>
         * The storage profile ID.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);
    }

    static final class BuilderImpl implements Builder {
        private ServiceManagedEc2InstanceCapabilities instanceCapabilities;

        private ServiceManagedEc2InstanceMarketOptions instanceMarketOptions;

        private VpcConfiguration vpcConfiguration;

        private String storageProfileId;

        private BuilderImpl() {
        }

        private BuilderImpl(ServiceManagedEc2FleetConfiguration model) {
            instanceCapabilities(model.instanceCapabilities);
            instanceMarketOptions(model.instanceMarketOptions);
            vpcConfiguration(model.vpcConfiguration);
            storageProfileId(model.storageProfileId);
        }

        public final ServiceManagedEc2InstanceCapabilities.Builder getInstanceCapabilities() {
            return instanceCapabilities != null ? instanceCapabilities.toBuilder() : null;
        }

        public final void setInstanceCapabilities(ServiceManagedEc2InstanceCapabilities.BuilderImpl instanceCapabilities) {
            this.instanceCapabilities = instanceCapabilities != null ? instanceCapabilities.build() : null;
        }

        @Override
        public final Builder instanceCapabilities(ServiceManagedEc2InstanceCapabilities instanceCapabilities) {
            this.instanceCapabilities = instanceCapabilities;
            return this;
        }

        public final ServiceManagedEc2InstanceMarketOptions.Builder getInstanceMarketOptions() {
            return instanceMarketOptions != null ? instanceMarketOptions.toBuilder() : null;
        }

        public final void setInstanceMarketOptions(ServiceManagedEc2InstanceMarketOptions.BuilderImpl instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions != null ? instanceMarketOptions.build() : null;
        }

        @Override
        public final Builder instanceMarketOptions(ServiceManagedEc2InstanceMarketOptions instanceMarketOptions) {
            this.instanceMarketOptions = instanceMarketOptions;
            return this;
        }

        public final VpcConfiguration.Builder getVpcConfiguration() {
            return vpcConfiguration != null ? vpcConfiguration.toBuilder() : null;
        }

        public final void setVpcConfiguration(VpcConfiguration.BuilderImpl vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration != null ? vpcConfiguration.build() : null;
        }

        @Override
        public final Builder vpcConfiguration(VpcConfiguration vpcConfiguration) {
            this.vpcConfiguration = vpcConfiguration;
            return this;
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        @Override
        public ServiceManagedEc2FleetConfiguration build() {
            return new ServiceManagedEc2FleetConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
