/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructMap;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Specifies the fleet IDs or queue IDs to return statistics. You can specify only fleet IDs or queue IDS, not both.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class SessionsStatisticsResources implements SdkPojo, Serializable,
        ToCopyableBuilder<SessionsStatisticsResources.Builder, SessionsStatisticsResources> {
    private static final SdkField<List<String>> QUEUE_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("queueIds")
            .getter(getter(SessionsStatisticsResources::queueIds))
            .setter(setter(Builder::queueIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("queueIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> FLEET_IDS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("fleetIds")
            .getter(getter(SessionsStatisticsResources::fleetIds))
            .setter(setter(Builder::fleetIds))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("fleetIds").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(QUEUE_IDS_FIELD,
            FLEET_IDS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> queueIds;

    private final List<String> fleetIds;

    private final Type type;

    private SessionsStatisticsResources(BuilderImpl builder) {
        this.queueIds = builder.queueIds;
        this.fleetIds = builder.fleetIds;
        this.type = builder.type;
    }

    /**
     * For responses, this returns true if the service returned a value for the QueueIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasQueueIds() {
        return queueIds != null && !(queueIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One to 10 queue IDs that specify the queues to return statistics for. If you specify the <code>queueIds</code>
     * field, you can't specify the <code>fleetIds</code> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasQueueIds} method.
     * </p>
     * 
     * @return One to 10 queue IDs that specify the queues to return statistics for. If you specify the
     *         <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
     */
    public final List<String> queueIds() {
        return queueIds;
    }

    /**
     * For responses, this returns true if the service returned a value for the FleetIds property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasFleetIds() {
        return fleetIds != null && !(fleetIds instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the <code>fleetIds</code>
     * field, you can't specify the <code>queueIds</code> field.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasFleetIds} method.
     * </p>
     * 
     * @return One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
     *         <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
     */
    public final List<String> fleetIds() {
        return fleetIds;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasQueueIds() ? queueIds() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasFleetIds() ? fleetIds() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof SessionsStatisticsResources)) {
            return false;
        }
        SessionsStatisticsResources other = (SessionsStatisticsResources) obj;
        return hasQueueIds() == other.hasQueueIds() && Objects.equals(queueIds(), other.queueIds())
                && hasFleetIds() == other.hasFleetIds() && Objects.equals(fleetIds(), other.fleetIds());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("SessionsStatisticsResources").add("QueueIds", hasQueueIds() ? queueIds() : null)
                .add("FleetIds", hasFleetIds() ? fleetIds() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "queueIds":
            return Optional.ofNullable(clazz.cast(queueIds()));
        case "fleetIds":
            return Optional.ofNullable(clazz.cast(fleetIds()));
        default:
            return Optional.empty();
        }
    }

    /**
     * Create an instance of this class with {@link #queueIds()} initialized to the given value.
     *
     * <p>
     * One to 10 queue IDs that specify the queues to return statistics for. If you specify the <code>queueIds</code>
     * field, you can't specify the <code>fleetIds</code> field.
     * </p>
     * 
     * @param queueIds
     *        One to 10 queue IDs that specify the queues to return statistics for. If you specify the
     *        <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
     */
    public static SessionsStatisticsResources fromQueueIds(List<String> queueIds) {
        return builder().queueIds(queueIds).build();
    }

    /**
     * Create an instance of this class with {@link #fleetIds()} initialized to the given value.
     *
     * <p>
     * One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the <code>fleetIds</code>
     * field, you can't specify the <code>queueIds</code> field.
     * </p>
     * 
     * @param fleetIds
     *        One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
     *        <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
     */
    public static SessionsStatisticsResources fromFleetIds(List<String> fleetIds) {
        return builder().fleetIds(fleetIds).build();
    }

    /**
     * Retrieve an enum value representing which member of this object is populated.
     *
     * When this class is returned in a service response, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if the
     * service returned a member that is only known to a newer SDK version.
     *
     * When this class is created directly in your code, this will be {@link Type#UNKNOWN_TO_SDK_VERSION} if zero
     * members are set, and {@code null} if more than one member is set.
     */
    public Type type() {
        return type;
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("queueIds", QUEUE_IDS_FIELD);
        map.put("fleetIds", FLEET_IDS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<SessionsStatisticsResources, T> g) {
        return obj -> g.apply((SessionsStatisticsResources) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, SessionsStatisticsResources> {
        /**
         * <p>
         * One to 10 queue IDs that specify the queues to return statistics for. If you specify the
         * <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
         * </p>
         * 
         * @param queueIds
         *        One to 10 queue IDs that specify the queues to return statistics for. If you specify the
         *        <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueIds(Collection<String> queueIds);

        /**
         * <p>
         * One to 10 queue IDs that specify the queues to return statistics for. If you specify the
         * <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
         * </p>
         * 
         * @param queueIds
         *        One to 10 queue IDs that specify the queues to return statistics for. If you specify the
         *        <code>queueIds</code> field, you can't specify the <code>fleetIds</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueIds(String... queueIds);

        /**
         * <p>
         * One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
         * <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
         * </p>
         * 
         * @param fleetIds
         *        One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
         *        <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(Collection<String> fleetIds);

        /**
         * <p>
         * One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
         * <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
         * </p>
         * 
         * @param fleetIds
         *        One to 10 fleet IDs that specify the fleets to return statistics for. If you specify the
         *        <code>fleetIds</code> field, you can't specify the <code>queueIds</code> field.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetIds(String... fleetIds);
    }

    static final class BuilderImpl implements Builder {
        private List<String> queueIds = DefaultSdkAutoConstructList.getInstance();

        private List<String> fleetIds = DefaultSdkAutoConstructList.getInstance();

        private Type type = Type.UNKNOWN_TO_SDK_VERSION;

        private Set<Type> setTypes = EnumSet.noneOf(Type.class);

        private BuilderImpl() {
        }

        private BuilderImpl(SessionsStatisticsResources model) {
            queueIds(model.queueIds);
            fleetIds(model.fleetIds);
        }

        public final Collection<String> getQueueIds() {
            if (queueIds instanceof SdkAutoConstructList) {
                return null;
            }
            return queueIds;
        }

        public final void setQueueIds(Collection<String> queueIds) {
            Object oldValue = this.queueIds;
            this.queueIds = SessionsStatisticsResourcesQueueIdsListCopier.copy(queueIds);
            handleUnionValueChange(Type.QUEUE_IDS, oldValue, this.queueIds);
        }

        @Override
        public final Builder queueIds(Collection<String> queueIds) {
            Object oldValue = this.queueIds;
            this.queueIds = SessionsStatisticsResourcesQueueIdsListCopier.copy(queueIds);
            handleUnionValueChange(Type.QUEUE_IDS, oldValue, this.queueIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder queueIds(String... queueIds) {
            queueIds(Arrays.asList(queueIds));
            return this;
        }

        public final Collection<String> getFleetIds() {
            if (fleetIds instanceof SdkAutoConstructList) {
                return null;
            }
            return fleetIds;
        }

        public final void setFleetIds(Collection<String> fleetIds) {
            Object oldValue = this.fleetIds;
            this.fleetIds = SessionsStatisticsResourcesFleetIdsListCopier.copy(fleetIds);
            handleUnionValueChange(Type.FLEET_IDS, oldValue, this.fleetIds);
        }

        @Override
        public final Builder fleetIds(Collection<String> fleetIds) {
            Object oldValue = this.fleetIds;
            this.fleetIds = SessionsStatisticsResourcesFleetIdsListCopier.copy(fleetIds);
            handleUnionValueChange(Type.FLEET_IDS, oldValue, this.fleetIds);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder fleetIds(String... fleetIds) {
            fleetIds(Arrays.asList(fleetIds));
            return this;
        }

        @Override
        public SessionsStatisticsResources build() {
            return new SessionsStatisticsResources(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }

        private final void handleUnionValueChange(Type type, Object oldValue, Object newValue) {
            if (this.type == type || oldValue == newValue) {
                return;
            }
            if (newValue == null || newValue instanceof SdkAutoConstructList || newValue instanceof SdkAutoConstructMap) {
                setTypes.remove(type);
            } else if (oldValue == null || oldValue instanceof SdkAutoConstructList || oldValue instanceof SdkAutoConstructMap) {
                setTypes.add(type);
            }
            if (setTypes.size() == 1) {
                this.type = setTypes.iterator().next();
            } else if (setTypes.isEmpty()) {
                this.type = Type.UNKNOWN_TO_SDK_VERSION;
            } else {
                this.type = null;
            }
        }
    }

    /**
     * @see SessionsStatisticsResources#type()
     */
    public enum Type {
        QUEUE_IDS,

        FLEET_IDS,

        UNKNOWN_TO_SDK_VERSION
    }
}
