/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.TimestampFormatTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class StartSessionsStatisticsAggregationRequest extends DeadlineRequest implements
        ToCopyableBuilder<StartSessionsStatisticsAggregationRequest.Builder, StartSessionsStatisticsAggregationRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(StartSessionsStatisticsAggregationRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<SessionsStatisticsResources> RESOURCE_IDS_FIELD = SdkField
            .<SessionsStatisticsResources> builder(MarshallingType.SDK_POJO).memberName("resourceIds")
            .getter(getter(StartSessionsStatisticsAggregationRequest::resourceIds)).setter(setter(Builder::resourceIds))
            .constructor(SessionsStatisticsResources::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceIds").build()).build();

    private static final SdkField<Instant> START_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("startTime")
            .getter(getter(StartSessionsStatisticsAggregationRequest::startTime))
            .setter(setter(Builder::startTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("startTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<Instant> END_TIME_FIELD = SdkField
            .<Instant> builder(MarshallingType.INSTANT)
            .memberName("endTime")
            .getter(getter(StartSessionsStatisticsAggregationRequest::endTime))
            .setter(setter(Builder::endTime))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("endTime").build(),
                    TimestampFormatTrait.create(TimestampFormatTrait.Format.ISO_8601)).build();

    private static final SdkField<String> TIMEZONE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("timezone").getter(getter(StartSessionsStatisticsAggregationRequest::timezone))
            .setter(setter(Builder::timezone))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("timezone").build()).build();

    private static final SdkField<String> PERIOD_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("period")
            .getter(getter(StartSessionsStatisticsAggregationRequest::periodAsString)).setter(setter(Builder::period))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("period").build()).build();

    private static final SdkField<List<String>> GROUP_BY_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("groupBy")
            .getter(getter(StartSessionsStatisticsAggregationRequest::groupByAsStrings))
            .setter(setter(Builder::groupByWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("groupBy").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<String>> STATISTICS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("statistics")
            .getter(getter(StartSessionsStatisticsAggregationRequest::statisticsAsStrings))
            .setter(setter(Builder::statisticsWithStrings))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("statistics").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections
            .unmodifiableList(Arrays.asList(FARM_ID_FIELD, RESOURCE_IDS_FIELD, START_TIME_FIELD, END_TIME_FIELD, TIMEZONE_FIELD,
                    PERIOD_FIELD, GROUP_BY_FIELD, STATISTICS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final SessionsStatisticsResources resourceIds;

    private final Instant startTime;

    private final Instant endTime;

    private final String timezone;

    private final String period;

    private final List<String> groupBy;

    private final List<String> statistics;

    private StartSessionsStatisticsAggregationRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.resourceIds = builder.resourceIds;
        this.startTime = builder.startTime;
        this.endTime = builder.endTime;
        this.timezone = builder.timezone;
        this.period = builder.period;
        this.groupBy = builder.groupBy;
        this.statistics = builder.statistics;
    }

    /**
     * <p>
     * The identifier of the farm that contains queues or fleets to return statistics for.
     * </p>
     * 
     * @return The identifier of the farm that contains queues or fleets to return statistics for.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * A list of fleet IDs or queue IDs to gather statistics for.
     * </p>
     * 
     * @return A list of fleet IDs or queue IDs to gather statistics for.
     */
    public final SessionsStatisticsResources resourceIds() {
        return resourceIds;
    }

    /**
     * <p>
     * The Linux timestamp of the date and time that the statistics start.
     * </p>
     * 
     * @return The Linux timestamp of the date and time that the statistics start.
     */
    public final Instant startTime() {
        return startTime;
    }

    /**
     * <p>
     * The Linux timestamp of the date and time that the statistics end.
     * </p>
     * 
     * @return The Linux timestamp of the date and time that the statistics end.
     */
    public final Instant endTime() {
        return endTime;
    }

    /**
     * <p>
     * The timezone to use for the statistics. Use UTC notation such as "UTC+8."
     * </p>
     * 
     * @return The timezone to use for the statistics. Use UTC notation such as "UTC+8."
     */
    public final String timezone() {
        return timezone;
    }

    /**
     * <p>
     * The period to aggregate the statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link Period#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The period to aggregate the statistics.
     * @see Period
     */
    public final Period period() {
        return Period.fromValue(period);
    }

    /**
     * <p>
     * The period to aggregate the statistics.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #period} will
     * return {@link Period#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #periodAsString}.
     * </p>
     * 
     * @return The period to aggregate the statistics.
     * @see Period
     */
    public final String periodAsString() {
        return period;
    }

    /**
     * <p>
     * The field to use to group the statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return The field to use to group the statistics.
     */
    public final List<UsageGroupByField> groupBy() {
        return UsageGroupByCopier.copyStringToEnum(groupBy);
    }

    /**
     * For responses, this returns true if the service returned a value for the GroupBy property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasGroupBy() {
        return groupBy != null && !(groupBy instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The field to use to group the statistics.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasGroupBy} method.
     * </p>
     * 
     * @return The field to use to group the statistics.
     */
    public final List<String> groupByAsStrings() {
        return groupBy;
    }

    /**
     * <p>
     * One to four statistics to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return One to four statistics to return.
     */
    public final List<UsageStatistic> statistics() {
        return UsageStatisticsCopier.copyStringToEnum(statistics);
    }

    /**
     * For responses, this returns true if the service returned a value for the Statistics property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasStatistics() {
        return statistics != null && !(statistics instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * One to four statistics to return.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasStatistics} method.
     * </p>
     * 
     * @return One to four statistics to return.
     */
    public final List<String> statisticsAsStrings() {
        return statistics;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(resourceIds());
        hashCode = 31 * hashCode + Objects.hashCode(startTime());
        hashCode = 31 * hashCode + Objects.hashCode(endTime());
        hashCode = 31 * hashCode + Objects.hashCode(timezone());
        hashCode = 31 * hashCode + Objects.hashCode(periodAsString());
        hashCode = 31 * hashCode + Objects.hashCode(hasGroupBy() ? groupByAsStrings() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasStatistics() ? statisticsAsStrings() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StartSessionsStatisticsAggregationRequest)) {
            return false;
        }
        StartSessionsStatisticsAggregationRequest other = (StartSessionsStatisticsAggregationRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(resourceIds(), other.resourceIds())
                && Objects.equals(startTime(), other.startTime()) && Objects.equals(endTime(), other.endTime())
                && Objects.equals(timezone(), other.timezone()) && Objects.equals(periodAsString(), other.periodAsString())
                && hasGroupBy() == other.hasGroupBy() && Objects.equals(groupByAsStrings(), other.groupByAsStrings())
                && hasStatistics() == other.hasStatistics() && Objects.equals(statisticsAsStrings(), other.statisticsAsStrings());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StartSessionsStatisticsAggregationRequest").add("FarmId", farmId())
                .add("ResourceIds", resourceIds()).add("StartTime", startTime()).add("EndTime", endTime())
                .add("Timezone", timezone()).add("Period", periodAsString())
                .add("GroupBy", hasGroupBy() ? groupByAsStrings() : null)
                .add("Statistics", hasStatistics() ? statisticsAsStrings() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "resourceIds":
            return Optional.ofNullable(clazz.cast(resourceIds()));
        case "startTime":
            return Optional.ofNullable(clazz.cast(startTime()));
        case "endTime":
            return Optional.ofNullable(clazz.cast(endTime()));
        case "timezone":
            return Optional.ofNullable(clazz.cast(timezone()));
        case "period":
            return Optional.ofNullable(clazz.cast(periodAsString()));
        case "groupBy":
            return Optional.ofNullable(clazz.cast(groupByAsStrings()));
        case "statistics":
            return Optional.ofNullable(clazz.cast(statisticsAsStrings()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("resourceIds", RESOURCE_IDS_FIELD);
        map.put("startTime", START_TIME_FIELD);
        map.put("endTime", END_TIME_FIELD);
        map.put("timezone", TIMEZONE_FIELD);
        map.put("period", PERIOD_FIELD);
        map.put("groupBy", GROUP_BY_FIELD);
        map.put("statistics", STATISTICS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StartSessionsStatisticsAggregationRequest, T> g) {
        return obj -> g.apply((StartSessionsStatisticsAggregationRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo,
            CopyableBuilder<Builder, StartSessionsStatisticsAggregationRequest> {
        /**
         * <p>
         * The identifier of the farm that contains queues or fleets to return statistics for.
         * </p>
         * 
         * @param farmId
         *        The identifier of the farm that contains queues or fleets to return statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * A list of fleet IDs or queue IDs to gather statistics for.
         * </p>
         * 
         * @param resourceIds
         *        A list of fleet IDs or queue IDs to gather statistics for.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceIds(SessionsStatisticsResources resourceIds);

        /**
         * <p>
         * A list of fleet IDs or queue IDs to gather statistics for.
         * </p>
         * This is a convenience method that creates an instance of the {@link SessionsStatisticsResources.Builder}
         * avoiding the need to create one manually via {@link SessionsStatisticsResources#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link SessionsStatisticsResources.Builder#build()} is called
         * immediately and its result is passed to {@link #resourceIds(SessionsStatisticsResources)}.
         * 
         * @param resourceIds
         *        a consumer that will call methods on {@link SessionsStatisticsResources.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #resourceIds(SessionsStatisticsResources)
         */
        default Builder resourceIds(Consumer<SessionsStatisticsResources.Builder> resourceIds) {
            return resourceIds(SessionsStatisticsResources.builder().applyMutation(resourceIds).build());
        }

        /**
         * <p>
         * The Linux timestamp of the date and time that the statistics start.
         * </p>
         * 
         * @param startTime
         *        The Linux timestamp of the date and time that the statistics start.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder startTime(Instant startTime);

        /**
         * <p>
         * The Linux timestamp of the date and time that the statistics end.
         * </p>
         * 
         * @param endTime
         *        The Linux timestamp of the date and time that the statistics end.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder endTime(Instant endTime);

        /**
         * <p>
         * The timezone to use for the statistics. Use UTC notation such as "UTC+8."
         * </p>
         * 
         * @param timezone
         *        The timezone to use for the statistics. Use UTC notation such as "UTC+8."
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder timezone(String timezone);

        /**
         * <p>
         * The period to aggregate the statistics.
         * </p>
         * 
         * @param period
         *        The period to aggregate the statistics.
         * @see Period
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Period
         */
        Builder period(String period);

        /**
         * <p>
         * The period to aggregate the statistics.
         * </p>
         * 
         * @param period
         *        The period to aggregate the statistics.
         * @see Period
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see Period
         */
        Builder period(Period period);

        /**
         * <p>
         * The field to use to group the statistics.
         * </p>
         * 
         * @param groupBy
         *        The field to use to group the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(Collection<String> groupBy);

        /**
         * <p>
         * The field to use to group the statistics.
         * </p>
         * 
         * @param groupBy
         *        The field to use to group the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupByWithStrings(String... groupBy);

        /**
         * <p>
         * The field to use to group the statistics.
         * </p>
         * 
         * @param groupBy
         *        The field to use to group the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(Collection<UsageGroupByField> groupBy);

        /**
         * <p>
         * The field to use to group the statistics.
         * </p>
         * 
         * @param groupBy
         *        The field to use to group the statistics.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder groupBy(UsageGroupByField... groupBy);

        /**
         * <p>
         * One to four statistics to return.
         * </p>
         * 
         * @param statistics
         *        One to four statistics to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(Collection<String> statistics);

        /**
         * <p>
         * One to four statistics to return.
         * </p>
         * 
         * @param statistics
         *        One to four statistics to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statisticsWithStrings(String... statistics);

        /**
         * <p>
         * One to four statistics to return.
         * </p>
         * 
         * @param statistics
         *        One to four statistics to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(Collection<UsageStatistic> statistics);

        /**
         * <p>
         * One to four statistics to return.
         * </p>
         * 
         * @param statistics
         *        One to four statistics to return.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder statistics(UsageStatistic... statistics);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private SessionsStatisticsResources resourceIds;

        private Instant startTime;

        private Instant endTime;

        private String timezone;

        private String period;

        private List<String> groupBy = DefaultSdkAutoConstructList.getInstance();

        private List<String> statistics = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StartSessionsStatisticsAggregationRequest model) {
            super(model);
            farmId(model.farmId);
            resourceIds(model.resourceIds);
            startTime(model.startTime);
            endTime(model.endTime);
            timezone(model.timezone);
            period(model.period);
            groupByWithStrings(model.groupBy);
            statisticsWithStrings(model.statistics);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final SessionsStatisticsResources.Builder getResourceIds() {
            return resourceIds != null ? resourceIds.toBuilder() : null;
        }

        public final void setResourceIds(SessionsStatisticsResources.BuilderImpl resourceIds) {
            this.resourceIds = resourceIds != null ? resourceIds.build() : null;
        }

        @Override
        public final Builder resourceIds(SessionsStatisticsResources resourceIds) {
            this.resourceIds = resourceIds;
            return this;
        }

        public final Instant getStartTime() {
            return startTime;
        }

        public final void setStartTime(Instant startTime) {
            this.startTime = startTime;
        }

        @Override
        public final Builder startTime(Instant startTime) {
            this.startTime = startTime;
            return this;
        }

        public final Instant getEndTime() {
            return endTime;
        }

        public final void setEndTime(Instant endTime) {
            this.endTime = endTime;
        }

        @Override
        public final Builder endTime(Instant endTime) {
            this.endTime = endTime;
            return this;
        }

        public final String getTimezone() {
            return timezone;
        }

        public final void setTimezone(String timezone) {
            this.timezone = timezone;
        }

        @Override
        public final Builder timezone(String timezone) {
            this.timezone = timezone;
            return this;
        }

        public final String getPeriod() {
            return period;
        }

        public final void setPeriod(String period) {
            this.period = period;
        }

        @Override
        public final Builder period(String period) {
            this.period = period;
            return this;
        }

        @Override
        public final Builder period(Period period) {
            this.period(period == null ? null : period.toString());
            return this;
        }

        public final Collection<String> getGroupBy() {
            if (groupBy instanceof SdkAutoConstructList) {
                return null;
            }
            return groupBy;
        }

        public final void setGroupBy(Collection<String> groupBy) {
            this.groupBy = UsageGroupByCopier.copy(groupBy);
        }

        @Override
        public final Builder groupByWithStrings(Collection<String> groupBy) {
            this.groupBy = UsageGroupByCopier.copy(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupByWithStrings(String... groupBy) {
            groupByWithStrings(Arrays.asList(groupBy));
            return this;
        }

        @Override
        public final Builder groupBy(Collection<UsageGroupByField> groupBy) {
            this.groupBy = UsageGroupByCopier.copyEnumToString(groupBy);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder groupBy(UsageGroupByField... groupBy) {
            groupBy(Arrays.asList(groupBy));
            return this;
        }

        public final Collection<String> getStatistics() {
            if (statistics instanceof SdkAutoConstructList) {
                return null;
            }
            return statistics;
        }

        public final void setStatistics(Collection<String> statistics) {
            this.statistics = UsageStatisticsCopier.copy(statistics);
        }

        @Override
        public final Builder statisticsWithStrings(Collection<String> statistics) {
            this.statistics = UsageStatisticsCopier.copy(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statisticsWithStrings(String... statistics) {
            statisticsWithStrings(Arrays.asList(statistics));
            return this;
        }

        @Override
        public final Builder statistics(Collection<UsageStatistic> statistics) {
            this.statistics = UsageStatisticsCopier.copyEnumToString(statistics);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder statistics(UsageStatistic... statistics) {
            statistics(Arrays.asList(statistics));
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public StartSessionsStatisticsAggregationRequest build() {
            return new StartSessionsStatisticsAggregationRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
