/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.document.Document;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a step entity.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepDetailsEntity implements SdkPojo, Serializable,
        ToCopyableBuilder<StepDetailsEntity.Builder, StepDetailsEntity> {
    private static final SdkField<String> JOB_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("jobId")
            .getter(getter(StepDetailsEntity::jobId)).setter(setter(Builder::jobId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("jobId").build()).build();

    private static final SdkField<String> STEP_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("stepId")
            .getter(getter(StepDetailsEntity::stepId)).setter(setter(Builder::stepId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("stepId").build()).build();

    private static final SdkField<String> SCHEMA_VERSION_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("schemaVersion").getter(getter(StepDetailsEntity::schemaVersion)).setter(setter(Builder::schemaVersion))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("schemaVersion").build()).build();

    private static final SdkField<Document> TEMPLATE_FIELD = SdkField.<Document> builder(MarshallingType.DOCUMENT)
            .memberName("template").getter(getter(StepDetailsEntity::template)).setter(setter(Builder::template))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("template").build()).build();

    private static final SdkField<List<String>> DEPENDENCIES_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("dependencies")
            .getter(getter(StepDetailsEntity::dependencies))
            .setter(setter(Builder::dependencies))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("dependencies").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(JOB_ID_FIELD, STEP_ID_FIELD,
            SCHEMA_VERSION_FIELD, TEMPLATE_FIELD, DEPENDENCIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String jobId;

    private final String stepId;

    private final String schemaVersion;

    private final Document template;

    private final List<String> dependencies;

    private StepDetailsEntity(BuilderImpl builder) {
        this.jobId = builder.jobId;
        this.stepId = builder.stepId;
        this.schemaVersion = builder.schemaVersion;
        this.template = builder.template;
        this.dependencies = builder.dependencies;
    }

    /**
     * <p>
     * The job ID.
     * </p>
     * 
     * @return The job ID.
     */
    public final String jobId() {
        return jobId;
    }

    /**
     * <p>
     * The step ID.
     * </p>
     * 
     * @return The step ID.
     */
    public final String stepId() {
        return stepId;
    }

    /**
     * <p>
     * The schema version for a step template.
     * </p>
     * 
     * @return The schema version for a step template.
     */
    public final String schemaVersion() {
        return schemaVersion;
    }

    /**
     * <p>
     * The template for a step.
     * </p>
     * 
     * @return The template for a step.
     */
    public final Document template() {
        return template;
    }

    /**
     * For responses, this returns true if the service returned a value for the Dependencies property. This DOES NOT
     * check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property).
     * This is useful because the SDK will never return a null collection or map, but you may need to differentiate
     * between the service returning nothing (or null) and the service returning an empty collection or map. For
     * requests, this returns true if a value for the property was specified in the request builder, and false if a
     * value was not specified.
     */
    public final boolean hasDependencies() {
        return dependencies != null && !(dependencies instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The dependencies for a step.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasDependencies} method.
     * </p>
     * 
     * @return The dependencies for a step.
     */
    public final List<String> dependencies() {
        return dependencies;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(jobId());
        hashCode = 31 * hashCode + Objects.hashCode(stepId());
        hashCode = 31 * hashCode + Objects.hashCode(schemaVersion());
        hashCode = 31 * hashCode + Objects.hashCode(template());
        hashCode = 31 * hashCode + Objects.hashCode(hasDependencies() ? dependencies() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepDetailsEntity)) {
            return false;
        }
        StepDetailsEntity other = (StepDetailsEntity) obj;
        return Objects.equals(jobId(), other.jobId()) && Objects.equals(stepId(), other.stepId())
                && Objects.equals(schemaVersion(), other.schemaVersion()) && Objects.equals(template(), other.template())
                && hasDependencies() == other.hasDependencies() && Objects.equals(dependencies(), other.dependencies());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepDetailsEntity").add("JobId", jobId()).add("StepId", stepId())
                .add("SchemaVersion", schemaVersion())
                .add("Template", template() == null ? null : "*** Sensitive Data Redacted ***")
                .add("Dependencies", hasDependencies() ? dependencies() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "jobId":
            return Optional.ofNullable(clazz.cast(jobId()));
        case "stepId":
            return Optional.ofNullable(clazz.cast(stepId()));
        case "schemaVersion":
            return Optional.ofNullable(clazz.cast(schemaVersion()));
        case "template":
            return Optional.ofNullable(clazz.cast(template()));
        case "dependencies":
            return Optional.ofNullable(clazz.cast(dependencies()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("jobId", JOB_ID_FIELD);
        map.put("stepId", STEP_ID_FIELD);
        map.put("schemaVersion", SCHEMA_VERSION_FIELD);
        map.put("template", TEMPLATE_FIELD);
        map.put("dependencies", DEPENDENCIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepDetailsEntity, T> g) {
        return obj -> g.apply((StepDetailsEntity) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepDetailsEntity> {
        /**
         * <p>
         * The job ID.
         * </p>
         * 
         * @param jobId
         *        The job ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder jobId(String jobId);

        /**
         * <p>
         * The step ID.
         * </p>
         * 
         * @param stepId
         *        The step ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder stepId(String stepId);

        /**
         * <p>
         * The schema version for a step template.
         * </p>
         * 
         * @param schemaVersion
         *        The schema version for a step template.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder schemaVersion(String schemaVersion);

        /**
         * <p>
         * The template for a step.
         * </p>
         * 
         * @param template
         *        The template for a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder template(Document template);

        /**
         * <p>
         * The dependencies for a step.
         * </p>
         * 
         * @param dependencies
         *        The dependencies for a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(Collection<String> dependencies);

        /**
         * <p>
         * The dependencies for a step.
         * </p>
         * 
         * @param dependencies
         *        The dependencies for a step.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder dependencies(String... dependencies);
    }

    static final class BuilderImpl implements Builder {
        private String jobId;

        private String stepId;

        private String schemaVersion;

        private Document template;

        private List<String> dependencies = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StepDetailsEntity model) {
            jobId(model.jobId);
            stepId(model.stepId);
            schemaVersion(model.schemaVersion);
            template(model.template);
            dependencies(model.dependencies);
        }

        public final String getJobId() {
            return jobId;
        }

        public final void setJobId(String jobId) {
            this.jobId = jobId;
        }

        @Override
        public final Builder jobId(String jobId) {
            this.jobId = jobId;
            return this;
        }

        public final String getStepId() {
            return stepId;
        }

        public final void setStepId(String stepId) {
            this.stepId = stepId;
        }

        @Override
        public final Builder stepId(String stepId) {
            this.stepId = stepId;
            return this;
        }

        public final String getSchemaVersion() {
            return schemaVersion;
        }

        public final void setSchemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
        }

        @Override
        public final Builder schemaVersion(String schemaVersion) {
            this.schemaVersion = schemaVersion;
            return this;
        }

        public final Document getTemplate() {
            return template;
        }

        public final void setTemplate(Document template) {
            this.template = template;
        }

        @Override
        public final Builder template(Document template) {
            this.template = template;
            return this;
        }

        public final Collection<String> getDependencies() {
            if (dependencies instanceof SdkAutoConstructList) {
                return null;
            }
            return dependencies;
        }

        public final void setDependencies(Collection<String> dependencies) {
            this.dependencies = DependenciesListCopier.copy(dependencies);
        }

        @Override
        public final Builder dependencies(Collection<String> dependencies) {
            this.dependencies = DependenciesListCopier.copy(dependencies);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder dependencies(String... dependencies) {
            dependencies(Arrays.asList(dependencies));
            return this;
        }

        @Override
        public StepDetailsEntity build() {
            return new StepDetailsEntity(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
