/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of required step capabilities.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StepRequiredCapabilities implements SdkPojo, Serializable,
        ToCopyableBuilder<StepRequiredCapabilities.Builder, StepRequiredCapabilities> {
    private static final SdkField<List<StepAttributeCapability>> ATTRIBUTES_FIELD = SdkField
            .<List<StepAttributeCapability>> builder(MarshallingType.LIST)
            .memberName("attributes")
            .getter(getter(StepRequiredCapabilities::attributes))
            .setter(setter(Builder::attributes))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("attributes").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepAttributeCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepAttributeCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final SdkField<List<StepAmountCapability>> AMOUNTS_FIELD = SdkField
            .<List<StepAmountCapability>> builder(MarshallingType.LIST)
            .memberName("amounts")
            .getter(getter(StepRequiredCapabilities::amounts))
            .setter(setter(Builder::amounts))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("amounts").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<StepAmountCapability> builder(MarshallingType.SDK_POJO)
                                            .constructor(StepAmountCapability::builder)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(ATTRIBUTES_FIELD,
            AMOUNTS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<StepAttributeCapability> attributes;

    private final List<StepAmountCapability> amounts;

    private StepRequiredCapabilities(BuilderImpl builder) {
        this.attributes = builder.attributes;
        this.amounts = builder.amounts;
    }

    /**
     * For responses, this returns true if the service returned a value for the Attributes property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAttributes() {
        return attributes != null && !(attributes instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capability attributes that the step requires.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAttributes} method.
     * </p>
     * 
     * @return The capability attributes that the step requires.
     */
    public final List<StepAttributeCapability> attributes() {
        return attributes;
    }

    /**
     * For responses, this returns true if the service returned a value for the Amounts property. This DOES NOT check
     * that the value is non-empty (for which, you should check the {@code isEmpty()} method on the property). This is
     * useful because the SDK will never return a null collection or map, but you may need to differentiate between the
     * service returning nothing (or null) and the service returning an empty collection or map. For requests, this
     * returns true if a value for the property was specified in the request builder, and false if a value was not
     * specified.
     */
    public final boolean hasAmounts() {
        return amounts != null && !(amounts instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The capability amounts that the step requires.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasAmounts} method.
     * </p>
     * 
     * @return The capability amounts that the step requires.
     */
    public final List<StepAmountCapability> amounts() {
        return amounts;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasAttributes() ? attributes() : null);
        hashCode = 31 * hashCode + Objects.hashCode(hasAmounts() ? amounts() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StepRequiredCapabilities)) {
            return false;
        }
        StepRequiredCapabilities other = (StepRequiredCapabilities) obj;
        return hasAttributes() == other.hasAttributes() && Objects.equals(attributes(), other.attributes())
                && hasAmounts() == other.hasAmounts() && Objects.equals(amounts(), other.amounts());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StepRequiredCapabilities").add("Attributes", hasAttributes() ? attributes() : null)
                .add("Amounts", hasAmounts() ? amounts() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "attributes":
            return Optional.ofNullable(clazz.cast(attributes()));
        case "amounts":
            return Optional.ofNullable(clazz.cast(amounts()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("attributes", ATTRIBUTES_FIELD);
        map.put("amounts", AMOUNTS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StepRequiredCapabilities, T> g) {
        return obj -> g.apply((StepRequiredCapabilities) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StepRequiredCapabilities> {
        /**
         * <p>
         * The capability attributes that the step requires.
         * </p>
         * 
         * @param attributes
         *        The capability attributes that the step requires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(Collection<StepAttributeCapability> attributes);

        /**
         * <p>
         * The capability attributes that the step requires.
         * </p>
         * 
         * @param attributes
         *        The capability attributes that the step requires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder attributes(StepAttributeCapability... attributes);

        /**
         * <p>
         * The capability attributes that the step requires.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.StepAttributeCapability.Builder} avoiding the need to
         * create one manually via
         * {@link software.amazon.awssdk.services.deadline.model.StepAttributeCapability#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.StepAttributeCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #attributes(List<StepAttributeCapability>)}.
         * 
         * @param attributes
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.StepAttributeCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #attributes(java.util.Collection<StepAttributeCapability>)
         */
        Builder attributes(Consumer<StepAttributeCapability.Builder>... attributes);

        /**
         * <p>
         * The capability amounts that the step requires.
         * </p>
         * 
         * @param amounts
         *        The capability amounts that the step requires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(Collection<StepAmountCapability> amounts);

        /**
         * <p>
         * The capability amounts that the step requires.
         * </p>
         * 
         * @param amounts
         *        The capability amounts that the step requires.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder amounts(StepAmountCapability... amounts);

        /**
         * <p>
         * The capability amounts that the step requires.
         * </p>
         * This is a convenience method that creates an instance of the
         * {@link software.amazon.awssdk.services.deadline.model.StepAmountCapability.Builder} avoiding the need to
         * create one manually via {@link software.amazon.awssdk.services.deadline.model.StepAmountCapability#builder()}
         * .
         *
         * <p>
         * When the {@link Consumer} completes,
         * {@link software.amazon.awssdk.services.deadline.model.StepAmountCapability.Builder#build()} is called
         * immediately and its result is passed to {@link #amounts(List<StepAmountCapability>)}.
         * 
         * @param amounts
         *        a consumer that will call methods on
         *        {@link software.amazon.awssdk.services.deadline.model.StepAmountCapability.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #amounts(java.util.Collection<StepAmountCapability>)
         */
        Builder amounts(Consumer<StepAmountCapability.Builder>... amounts);
    }

    static final class BuilderImpl implements Builder {
        private List<StepAttributeCapability> attributes = DefaultSdkAutoConstructList.getInstance();

        private List<StepAmountCapability> amounts = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(StepRequiredCapabilities model) {
            attributes(model.attributes);
            amounts(model.amounts);
        }

        public final List<StepAttributeCapability.Builder> getAttributes() {
            List<StepAttributeCapability.Builder> result = StepAttributeCapabilitiesCopier.copyToBuilder(this.attributes);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAttributes(Collection<StepAttributeCapability.BuilderImpl> attributes) {
            this.attributes = StepAttributeCapabilitiesCopier.copyFromBuilder(attributes);
        }

        @Override
        public final Builder attributes(Collection<StepAttributeCapability> attributes) {
            this.attributes = StepAttributeCapabilitiesCopier.copy(attributes);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(StepAttributeCapability... attributes) {
            attributes(Arrays.asList(attributes));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder attributes(Consumer<StepAttributeCapability.Builder>... attributes) {
            attributes(Stream.of(attributes).map(c -> StepAttributeCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        public final List<StepAmountCapability.Builder> getAmounts() {
            List<StepAmountCapability.Builder> result = StepAmountCapabilitiesCopier.copyToBuilder(this.amounts);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setAmounts(Collection<StepAmountCapability.BuilderImpl> amounts) {
            this.amounts = StepAmountCapabilitiesCopier.copyFromBuilder(amounts);
        }

        @Override
        public final Builder amounts(Collection<StepAmountCapability> amounts) {
            this.amounts = StepAmountCapabilitiesCopier.copy(amounts);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(StepAmountCapability... amounts) {
            amounts(Arrays.asList(amounts));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder amounts(Consumer<StepAmountCapability.Builder>... amounts) {
            amounts(Stream.of(amounts).map(c -> StepAmountCapability.builder().applyMutation(c).build())
                    .collect(Collectors.toList()));
            return this;
        }

        @Override
        public StepRequiredCapabilities build() {
            return new StepRequiredCapabilities(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
