/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The details of a storage profile.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class StorageProfileSummary implements SdkPojo, Serializable,
        ToCopyableBuilder<StorageProfileSummary.Builder, StorageProfileSummary> {
    private static final SdkField<String> STORAGE_PROFILE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("storageProfileId").getter(getter(StorageProfileSummary::storageProfileId))
            .setter(setter(Builder::storageProfileId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("storageProfileId").build()).build();

    private static final SdkField<String> DISPLAY_NAME_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("displayName").getter(getter(StorageProfileSummary::displayName)).setter(setter(Builder::displayName))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("displayName").build()).build();

    private static final SdkField<String> OS_FAMILY_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("osFamily").getter(getter(StorageProfileSummary::osFamilyAsString)).setter(setter(Builder::osFamily))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("osFamily").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(STORAGE_PROFILE_ID_FIELD,
            DISPLAY_NAME_FIELD, OS_FAMILY_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String storageProfileId;

    private final String displayName;

    private final String osFamily;

    private StorageProfileSummary(BuilderImpl builder) {
        this.storageProfileId = builder.storageProfileId;
        this.displayName = builder.displayName;
        this.osFamily = builder.osFamily;
    }

    /**
     * <p>
     * The storage profile ID.
     * </p>
     * 
     * @return The storage profile ID.
     */
    public final String storageProfileId() {
        return storageProfileId;
    }

    /**
     * <p>
     * The display name of the storage profile summary to update.
     * </p>
     * <important>
     * <p>
     * This field can store any content. Escape or encode this content before displaying it on a webpage or any other
     * system that might interpret the content of this field.
     * </p>
     * </important>
     * 
     * @return The display name of the storage profile summary to update.</p> <important>
     *         <p>
     *         This field can store any content. Escape or encode this content before displaying it on a webpage or any
     *         other system that might interpret the content of this field.
     *         </p>
     */
    public final String displayName() {
        return displayName;
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see StorageProfileOperatingSystemFamily
     */
    public final StorageProfileOperatingSystemFamily osFamily() {
        return StorageProfileOperatingSystemFamily.fromValue(osFamily);
    }

    /**
     * <p>
     * The operating system (OS) family.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #osFamily} will
     * return {@link StorageProfileOperatingSystemFamily#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service
     * is available from {@link #osFamilyAsString}.
     * </p>
     * 
     * @return The operating system (OS) family.
     * @see StorageProfileOperatingSystemFamily
     */
    public final String osFamilyAsString() {
        return osFamily;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(storageProfileId());
        hashCode = 31 * hashCode + Objects.hashCode(displayName());
        hashCode = 31 * hashCode + Objects.hashCode(osFamilyAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof StorageProfileSummary)) {
            return false;
        }
        StorageProfileSummary other = (StorageProfileSummary) obj;
        return Objects.equals(storageProfileId(), other.storageProfileId()) && Objects.equals(displayName(), other.displayName())
                && Objects.equals(osFamilyAsString(), other.osFamilyAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("StorageProfileSummary").add("StorageProfileId", storageProfileId())
                .add("DisplayName", displayName()).add("OsFamily", osFamilyAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "storageProfileId":
            return Optional.ofNullable(clazz.cast(storageProfileId()));
        case "displayName":
            return Optional.ofNullable(clazz.cast(displayName()));
        case "osFamily":
            return Optional.ofNullable(clazz.cast(osFamilyAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("storageProfileId", STORAGE_PROFILE_ID_FIELD);
        map.put("displayName", DISPLAY_NAME_FIELD);
        map.put("osFamily", OS_FAMILY_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<StorageProfileSummary, T> g) {
        return obj -> g.apply((StorageProfileSummary) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, StorageProfileSummary> {
        /**
         * <p>
         * The storage profile ID.
         * </p>
         * 
         * @param storageProfileId
         *        The storage profile ID.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder storageProfileId(String storageProfileId);

        /**
         * <p>
         * The display name of the storage profile summary to update.
         * </p>
         * <important>
         * <p>
         * This field can store any content. Escape or encode this content before displaying it on a webpage or any
         * other system that might interpret the content of this field.
         * </p>
         * </important>
         * 
         * @param displayName
         *        The display name of the storage profile summary to update.</p> <important>
         *        <p>
         *        This field can store any content. Escape or encode this content before displaying it on a webpage or
         *        any other system that might interpret the content of this field.
         *        </p>
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder displayName(String displayName);

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(String osFamily);

        /**
         * <p>
         * The operating system (OS) family.
         * </p>
         * 
         * @param osFamily
         *        The operating system (OS) family.
         * @see StorageProfileOperatingSystemFamily
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see StorageProfileOperatingSystemFamily
         */
        Builder osFamily(StorageProfileOperatingSystemFamily osFamily);
    }

    static final class BuilderImpl implements Builder {
        private String storageProfileId;

        private String displayName;

        private String osFamily;

        private BuilderImpl() {
        }

        private BuilderImpl(StorageProfileSummary model) {
            storageProfileId(model.storageProfileId);
            displayName(model.displayName);
            osFamily(model.osFamily);
        }

        public final String getStorageProfileId() {
            return storageProfileId;
        }

        public final void setStorageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
        }

        @Override
        public final Builder storageProfileId(String storageProfileId) {
            this.storageProfileId = storageProfileId;
            return this;
        }

        public final String getDisplayName() {
            return displayName;
        }

        public final void setDisplayName(String displayName) {
            this.displayName = displayName;
        }

        @Override
        public final Builder displayName(String displayName) {
            this.displayName = displayName;
            return this;
        }

        public final String getOsFamily() {
            return osFamily;
        }

        public final void setOsFamily(String osFamily) {
            this.osFamily = osFamily;
        }

        @Override
        public final Builder osFamily(String osFamily) {
            this.osFamily = osFamily;
            return this;
        }

        @Override
        public final Builder osFamily(StorageProfileOperatingSystemFamily osFamily) {
            this.osFamily(osFamily == null ? null : osFamily.toString());
            return this;
        }

        @Override
        public StorageProfileSummary build() {
            return new StorageProfileSummary(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
