/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The manifest properties for a task run, corresponding to the manifest properties in the job.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class TaskRunManifestPropertiesResponse implements SdkPojo, Serializable,
        ToCopyableBuilder<TaskRunManifestPropertiesResponse.Builder, TaskRunManifestPropertiesResponse> {
    private static final SdkField<String> OUTPUT_MANIFEST_PATH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputManifestPath").getter(getter(TaskRunManifestPropertiesResponse::outputManifestPath))
            .setter(setter(Builder::outputManifestPath))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputManifestPath").build())
            .build();

    private static final SdkField<String> OUTPUT_MANIFEST_HASH_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("outputManifestHash").getter(getter(TaskRunManifestPropertiesResponse::outputManifestHash))
            .setter(setter(Builder::outputManifestHash))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("outputManifestHash").build())
            .build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(OUTPUT_MANIFEST_PATH_FIELD,
            OUTPUT_MANIFEST_HASH_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String outputManifestPath;

    private final String outputManifestHash;

    private TaskRunManifestPropertiesResponse(BuilderImpl builder) {
        this.outputManifestPath = builder.outputManifestPath;
        this.outputManifestHash = builder.outputManifestHash;
    }

    /**
     * <p>
     * The manifest file path.
     * </p>
     * 
     * @return The manifest file path.
     */
    public final String outputManifestPath() {
        return outputManifestPath;
    }

    /**
     * <p>
     * The hash value of the file.
     * </p>
     * 
     * @return The hash value of the file.
     */
    public final String outputManifestHash() {
        return outputManifestHash;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(outputManifestPath());
        hashCode = 31 * hashCode + Objects.hashCode(outputManifestHash());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TaskRunManifestPropertiesResponse)) {
            return false;
        }
        TaskRunManifestPropertiesResponse other = (TaskRunManifestPropertiesResponse) obj;
        return Objects.equals(outputManifestPath(), other.outputManifestPath())
                && Objects.equals(outputManifestHash(), other.outputManifestHash());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("TaskRunManifestPropertiesResponse").add("OutputManifestPath", outputManifestPath())
                .add("OutputManifestHash", outputManifestHash()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "outputManifestPath":
            return Optional.ofNullable(clazz.cast(outputManifestPath()));
        case "outputManifestHash":
            return Optional.ofNullable(clazz.cast(outputManifestHash()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("outputManifestPath", OUTPUT_MANIFEST_PATH_FIELD);
        map.put("outputManifestHash", OUTPUT_MANIFEST_HASH_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TaskRunManifestPropertiesResponse, T> g) {
        return obj -> g.apply((TaskRunManifestPropertiesResponse) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, TaskRunManifestPropertiesResponse> {
        /**
         * <p>
         * The manifest file path.
         * </p>
         * 
         * @param outputManifestPath
         *        The manifest file path.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputManifestPath(String outputManifestPath);

        /**
         * <p>
         * The hash value of the file.
         * </p>
         * 
         * @param outputManifestHash
         *        The hash value of the file.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder outputManifestHash(String outputManifestHash);
    }

    static final class BuilderImpl implements Builder {
        private String outputManifestPath;

        private String outputManifestHash;

        private BuilderImpl() {
        }

        private BuilderImpl(TaskRunManifestPropertiesResponse model) {
            outputManifestPath(model.outputManifestPath);
            outputManifestHash(model.outputManifestHash);
        }

        public final String getOutputManifestPath() {
            return outputManifestPath;
        }

        public final void setOutputManifestPath(String outputManifestPath) {
            this.outputManifestPath = outputManifestPath;
        }

        @Override
        public final Builder outputManifestPath(String outputManifestPath) {
            this.outputManifestPath = outputManifestPath;
            return this;
        }

        public final String getOutputManifestHash() {
            return outputManifestHash;
        }

        public final void setOutputManifestHash(String outputManifestHash) {
            this.outputManifestHash = outputManifestHash;
        }

        @Override
        public final Builder outputManifestHash(String outputManifestHash) {
            this.outputManifestHash = outputManifestHash;
            return this;
        }

        @Override
        public TaskRunManifestPropertiesResponse build() {
            return new TaskRunManifestPropertiesResponse(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
