/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class UpdateWorkerRequest extends DeadlineRequest implements
        ToCopyableBuilder<UpdateWorkerRequest.Builder, UpdateWorkerRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(UpdateWorkerRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> FLEET_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("fleetId").getter(getter(UpdateWorkerRequest::fleetId)).setter(setter(Builder::fleetId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("fleetId").build()).build();

    private static final SdkField<String> WORKER_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("workerId").getter(getter(UpdateWorkerRequest::workerId)).setter(setter(Builder::workerId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("workerId").build()).build();

    private static final SdkField<String> STATUS_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("status")
            .getter(getter(UpdateWorkerRequest::statusAsString)).setter(setter(Builder::status))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("status").build()).build();

    private static final SdkField<WorkerCapabilities> CAPABILITIES_FIELD = SdkField
            .<WorkerCapabilities> builder(MarshallingType.SDK_POJO).memberName("capabilities")
            .getter(getter(UpdateWorkerRequest::capabilities)).setter(setter(Builder::capabilities))
            .constructor(WorkerCapabilities::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("capabilities").build()).build();

    private static final SdkField<HostPropertiesRequest> HOST_PROPERTIES_FIELD = SdkField
            .<HostPropertiesRequest> builder(MarshallingType.SDK_POJO).memberName("hostProperties")
            .getter(getter(UpdateWorkerRequest::hostProperties)).setter(setter(Builder::hostProperties))
            .constructor(HostPropertiesRequest::builder)
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("hostProperties").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, FLEET_ID_FIELD,
            WORKER_ID_FIELD, STATUS_FIELD, CAPABILITIES_FIELD, HOST_PROPERTIES_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final String fleetId;

    private final String workerId;

    private final String status;

    private final WorkerCapabilities capabilities;

    private final HostPropertiesRequest hostProperties;

    private UpdateWorkerRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.fleetId = builder.fleetId;
        this.workerId = builder.workerId;
        this.status = builder.status;
        this.capabilities = builder.capabilities;
        this.hostProperties = builder.hostProperties;
    }

    /**
     * <p>
     * The farm ID to update.
     * </p>
     * 
     * @return The farm ID to update.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The fleet ID to update.
     * </p>
     * 
     * @return The fleet ID to update.
     */
    public final String fleetId() {
        return fleetId;
    }

    /**
     * <p>
     * The worker ID to update.
     * </p>
     * 
     * @return The worker ID to update.
     */
    public final String workerId() {
        return workerId;
    }

    /**
     * <p>
     * The worker status to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdatedWorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The worker status to update.
     * @see UpdatedWorkerStatus
     */
    public final UpdatedWorkerStatus status() {
        return UpdatedWorkerStatus.fromValue(status);
    }

    /**
     * <p>
     * The worker status to update.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #status} will
     * return {@link UpdatedWorkerStatus#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #statusAsString}.
     * </p>
     * 
     * @return The worker status to update.
     * @see UpdatedWorkerStatus
     */
    public final String statusAsString() {
        return status;
    }

    /**
     * <p>
     * The worker capabilities to update.
     * </p>
     * 
     * @return The worker capabilities to update.
     */
    public final WorkerCapabilities capabilities() {
        return capabilities;
    }

    /**
     * <p>
     * The host properties to update.
     * </p>
     * 
     * @return The host properties to update.
     */
    public final HostPropertiesRequest hostProperties() {
        return hostProperties;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(fleetId());
        hashCode = 31 * hashCode + Objects.hashCode(workerId());
        hashCode = 31 * hashCode + Objects.hashCode(statusAsString());
        hashCode = 31 * hashCode + Objects.hashCode(capabilities());
        hashCode = 31 * hashCode + Objects.hashCode(hostProperties());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof UpdateWorkerRequest)) {
            return false;
        }
        UpdateWorkerRequest other = (UpdateWorkerRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(fleetId(), other.fleetId())
                && Objects.equals(workerId(), other.workerId()) && Objects.equals(statusAsString(), other.statusAsString())
                && Objects.equals(capabilities(), other.capabilities())
                && Objects.equals(hostProperties(), other.hostProperties());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("UpdateWorkerRequest").add("FarmId", farmId()).add("FleetId", fleetId())
                .add("WorkerId", workerId()).add("Status", statusAsString()).add("Capabilities", capabilities())
                .add("HostProperties", hostProperties()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "fleetId":
            return Optional.ofNullable(clazz.cast(fleetId()));
        case "workerId":
            return Optional.ofNullable(clazz.cast(workerId()));
        case "status":
            return Optional.ofNullable(clazz.cast(statusAsString()));
        case "capabilities":
            return Optional.ofNullable(clazz.cast(capabilities()));
        case "hostProperties":
            return Optional.ofNullable(clazz.cast(hostProperties()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("fleetId", FLEET_ID_FIELD);
        map.put("workerId", WORKER_ID_FIELD);
        map.put("status", STATUS_FIELD);
        map.put("capabilities", CAPABILITIES_FIELD);
        map.put("hostProperties", HOST_PROPERTIES_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<UpdateWorkerRequest, T> g) {
        return obj -> g.apply((UpdateWorkerRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, UpdateWorkerRequest> {
        /**
         * <p>
         * The farm ID to update.
         * </p>
         * 
         * @param farmId
         *        The farm ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The fleet ID to update.
         * </p>
         * 
         * @param fleetId
         *        The fleet ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder fleetId(String fleetId);

        /**
         * <p>
         * The worker ID to update.
         * </p>
         * 
         * @param workerId
         *        The worker ID to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder workerId(String workerId);

        /**
         * <p>
         * The worker status to update.
         * </p>
         * 
         * @param status
         *        The worker status to update.
         * @see UpdatedWorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatedWorkerStatus
         */
        Builder status(String status);

        /**
         * <p>
         * The worker status to update.
         * </p>
         * 
         * @param status
         *        The worker status to update.
         * @see UpdatedWorkerStatus
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see UpdatedWorkerStatus
         */
        Builder status(UpdatedWorkerStatus status);

        /**
         * <p>
         * The worker capabilities to update.
         * </p>
         * 
         * @param capabilities
         *        The worker capabilities to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder capabilities(WorkerCapabilities capabilities);

        /**
         * <p>
         * The worker capabilities to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link WorkerCapabilities.Builder} avoiding the
         * need to create one manually via {@link WorkerCapabilities#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link WorkerCapabilities.Builder#build()} is called immediately and its
         * result is passed to {@link #capabilities(WorkerCapabilities)}.
         * 
         * @param capabilities
         *        a consumer that will call methods on {@link WorkerCapabilities.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #capabilities(WorkerCapabilities)
         */
        default Builder capabilities(Consumer<WorkerCapabilities.Builder> capabilities) {
            return capabilities(WorkerCapabilities.builder().applyMutation(capabilities).build());
        }

        /**
         * <p>
         * The host properties to update.
         * </p>
         * 
         * @param hostProperties
         *        The host properties to update.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder hostProperties(HostPropertiesRequest hostProperties);

        /**
         * <p>
         * The host properties to update.
         * </p>
         * This is a convenience method that creates an instance of the {@link HostPropertiesRequest.Builder} avoiding
         * the need to create one manually via {@link HostPropertiesRequest#builder()}.
         *
         * <p>
         * When the {@link Consumer} completes, {@link HostPropertiesRequest.Builder#build()} is called immediately and
         * its result is passed to {@link #hostProperties(HostPropertiesRequest)}.
         * 
         * @param hostProperties
         *        a consumer that will call methods on {@link HostPropertiesRequest.Builder}
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see #hostProperties(HostPropertiesRequest)
         */
        default Builder hostProperties(Consumer<HostPropertiesRequest.Builder> hostProperties) {
            return hostProperties(HostPropertiesRequest.builder().applyMutation(hostProperties).build());
        }

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private String fleetId;

        private String workerId;

        private String status;

        private WorkerCapabilities capabilities;

        private HostPropertiesRequest hostProperties;

        private BuilderImpl() {
        }

        private BuilderImpl(UpdateWorkerRequest model) {
            super(model);
            farmId(model.farmId);
            fleetId(model.fleetId);
            workerId(model.workerId);
            status(model.status);
            capabilities(model.capabilities);
            hostProperties(model.hostProperties);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getFleetId() {
            return fleetId;
        }

        public final void setFleetId(String fleetId) {
            this.fleetId = fleetId;
        }

        @Override
        public final Builder fleetId(String fleetId) {
            this.fleetId = fleetId;
            return this;
        }

        public final String getWorkerId() {
            return workerId;
        }

        public final void setWorkerId(String workerId) {
            this.workerId = workerId;
        }

        @Override
        public final Builder workerId(String workerId) {
            this.workerId = workerId;
            return this;
        }

        public final String getStatus() {
            return status;
        }

        public final void setStatus(String status) {
            this.status = status;
        }

        @Override
        public final Builder status(String status) {
            this.status = status;
            return this;
        }

        @Override
        public final Builder status(UpdatedWorkerStatus status) {
            this.status(status == null ? null : status.toString());
            return this;
        }

        public final WorkerCapabilities.Builder getCapabilities() {
            return capabilities != null ? capabilities.toBuilder() : null;
        }

        public final void setCapabilities(WorkerCapabilities.BuilderImpl capabilities) {
            this.capabilities = capabilities != null ? capabilities.build() : null;
        }

        @Override
        public final Builder capabilities(WorkerCapabilities capabilities) {
            this.capabilities = capabilities;
            return this;
        }

        public final HostPropertiesRequest.Builder getHostProperties() {
            return hostProperties != null ? hostProperties.toBuilder() : null;
        }

        public final void setHostProperties(HostPropertiesRequest.BuilderImpl hostProperties) {
            this.hostProperties = hostProperties != null ? hostProperties.build() : null;
        }

        @Override
        public final Builder hostProperties(HostPropertiesRequest hostProperties) {
            this.hostProperties = hostProperties;
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public UpdateWorkerRequest build() {
            return new UpdateWorkerRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
