/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * The configuration options for a service managed fleet's VPC.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class VpcConfiguration implements SdkPojo, Serializable,
        ToCopyableBuilder<VpcConfiguration.Builder, VpcConfiguration> {
    private static final SdkField<List<String>> RESOURCE_CONFIGURATION_ARNS_FIELD = SdkField
            .<List<String>> builder(MarshallingType.LIST)
            .memberName("resourceConfigurationArns")
            .getter(getter(VpcConfiguration::resourceConfigurationArns))
            .setter(setter(Builder::resourceConfigurationArns))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("resourceConfigurationArns").build(),
                    ListTrait
                            .builder()
                            .memberLocationName(null)
                            .memberFieldInfo(
                                    SdkField.<String> builder(MarshallingType.STRING)
                                            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD)
                                                    .locationName("member").build()).build()).build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays
            .asList(RESOURCE_CONFIGURATION_ARNS_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final List<String> resourceConfigurationArns;

    private VpcConfiguration(BuilderImpl builder) {
        this.resourceConfigurationArns = builder.resourceConfigurationArns;
    }

    /**
     * For responses, this returns true if the service returned a value for the ResourceConfigurationArns property. This
     * DOES NOT check that the value is non-empty (for which, you should check the {@code isEmpty()} method on the
     * property). This is useful because the SDK will never return a null collection or map, but you may need to
     * differentiate between the service returning nothing (or null) and the service returning an empty collection or
     * map. For requests, this returns true if a value for the property was specified in the request builder, and false
     * if a value was not specified.
     */
    public final boolean hasResourceConfigurationArns() {
        return resourceConfigurationArns != null && !(resourceConfigurationArns instanceof SdkAutoConstructList);
    }

    /**
     * <p>
     * The ARNs of the VPC Lattice resource configurations attached to the fleet.
     * </p>
     * <p>
     * Attempts to modify the collection returned by this method will result in an UnsupportedOperationException.
     * </p>
     * <p>
     * This method will never return null. If you would like to know whether the service returned this field (so that
     * you can differentiate between null and empty), you can use the {@link #hasResourceConfigurationArns} method.
     * </p>
     * 
     * @return The ARNs of the VPC Lattice resource configurations attached to the fleet.
     */
    public final List<String> resourceConfigurationArns() {
        return resourceConfigurationArns;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(hasResourceConfigurationArns() ? resourceConfigurationArns() : null);
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof VpcConfiguration)) {
            return false;
        }
        VpcConfiguration other = (VpcConfiguration) obj;
        return hasResourceConfigurationArns() == other.hasResourceConfigurationArns()
                && Objects.equals(resourceConfigurationArns(), other.resourceConfigurationArns());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("VpcConfiguration")
                .add("ResourceConfigurationArns", hasResourceConfigurationArns() ? resourceConfigurationArns() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "resourceConfigurationArns":
            return Optional.ofNullable(clazz.cast(resourceConfigurationArns()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("resourceConfigurationArns", RESOURCE_CONFIGURATION_ARNS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<VpcConfiguration, T> g) {
        return obj -> g.apply((VpcConfiguration) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, VpcConfiguration> {
        /**
         * <p>
         * The ARNs of the VPC Lattice resource configurations attached to the fleet.
         * </p>
         * 
         * @param resourceConfigurationArns
         *        The ARNs of the VPC Lattice resource configurations attached to the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArns(Collection<String> resourceConfigurationArns);

        /**
         * <p>
         * The ARNs of the VPC Lattice resource configurations attached to the fleet.
         * </p>
         * 
         * @param resourceConfigurationArns
         *        The ARNs of the VPC Lattice resource configurations attached to the fleet.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder resourceConfigurationArns(String... resourceConfigurationArns);
    }

    static final class BuilderImpl implements Builder {
        private List<String> resourceConfigurationArns = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(VpcConfiguration model) {
            resourceConfigurationArns(model.resourceConfigurationArns);
        }

        public final Collection<String> getResourceConfigurationArns() {
            if (resourceConfigurationArns instanceof SdkAutoConstructList) {
                return null;
            }
            return resourceConfigurationArns;
        }

        public final void setResourceConfigurationArns(Collection<String> resourceConfigurationArns) {
            this.resourceConfigurationArns = VpcResourceConfigurationArnsCopier.copy(resourceConfigurationArns);
        }

        @Override
        public final Builder resourceConfigurationArns(Collection<String> resourceConfigurationArns) {
            this.resourceConfigurationArns = VpcResourceConfigurationArnsCopier.copy(resourceConfigurationArns);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder resourceConfigurationArns(String... resourceConfigurationArns) {
            resourceConfigurationArns(Arrays.asList(resourceConfigurationArns));
            return this;
        }

        @Override
        public VpcConfiguration build() {
            return new VpcConfiguration(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
