/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.deadline.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.function.Function;
import software.amazon.awssdk.core.pagination.sync.PaginatedItemsIterable;
import software.amazon.awssdk.core.pagination.sync.PaginatedResponsesIterator;
import software.amazon.awssdk.core.pagination.sync.SdkIterable;
import software.amazon.awssdk.core.pagination.sync.SyncPageFetcher;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.deadline.DeadlineClient;
import software.amazon.awssdk.services.deadline.internal.UserAgentUtils;
import software.amazon.awssdk.services.deadline.model.LimitSummary;
import software.amazon.awssdk.services.deadline.model.ListLimitsRequest;
import software.amazon.awssdk.services.deadline.model.ListLimitsResponse;

public class ListLimitsIterable
implements SdkIterable<ListLimitsResponse> {
    private final DeadlineClient client;
    private final ListLimitsRequest firstRequest;
    private final SyncPageFetcher nextPageFetcher;

    public ListLimitsIterable(DeadlineClient client, ListLimitsRequest firstRequest) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.nextPageFetcher = new ListLimitsResponseFetcher();
    }

    public Iterator<ListLimitsResponse> iterator() {
        return PaginatedResponsesIterator.builder().nextPageFetcher(this.nextPageFetcher).build();
    }

    public final SdkIterable<LimitSummary> limits() {
        Function<ListLimitsResponse, Iterator> getIterator = response -> {
            if (response != null && response.limits() != null) {
                return response.limits().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsIterable.builder().pagesIterable((SdkIterable)this).itemIteratorFunction(getIterator).build();
    }

    private class ListLimitsResponseFetcher
    implements SyncPageFetcher<ListLimitsResponse> {
        private ListLimitsResponseFetcher() {
        }

        public boolean hasNextPage(ListLimitsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public ListLimitsResponse nextPage(ListLimitsResponse previousPage) {
            if (previousPage == null) {
                return ListLimitsIterable.this.client.listLimits(ListLimitsIterable.this.firstRequest);
            }
            return ListLimitsIterable.this.client.listLimits((ListLimitsRequest)((Object)ListLimitsIterable.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

