/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 * <p>
 * Provides information about the number of resources used.
 * </p>
 */
@Generated("software.amazon.awssdk:codegen")
public final class AcquiredLimit implements SdkPojo, Serializable, ToCopyableBuilder<AcquiredLimit.Builder, AcquiredLimit> {
    private static final SdkField<String> LIMIT_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("limitId").getter(getter(AcquiredLimit::limitId)).setter(setter(Builder::limitId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("limitId").build()).build();

    private static final SdkField<Integer> COUNT_FIELD = SdkField.<Integer> builder(MarshallingType.INTEGER).memberName("count")
            .getter(getter(AcquiredLimit::count)).setter(setter(Builder::count))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("count").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(LIMIT_ID_FIELD, COUNT_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private static final long serialVersionUID = 1L;

    private final String limitId;

    private final Integer count;

    private AcquiredLimit(BuilderImpl builder) {
        this.limitId = builder.limitId;
        this.count = builder.count;
    }

    /**
     * <p>
     * The unique identifier of the limit.
     * </p>
     * 
     * @return The unique identifier of the limit.
     */
    public final String limitId() {
        return limitId;
    }

    /**
     * <p>
     * The number of limit resources used.
     * </p>
     * 
     * @return The number of limit resources used.
     */
    public final Integer count() {
        return count;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(limitId());
        hashCode = 31 * hashCode + Objects.hashCode(count());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AcquiredLimit)) {
            return false;
        }
        AcquiredLimit other = (AcquiredLimit) obj;
        return Objects.equals(limitId(), other.limitId()) && Objects.equals(count(), other.count());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AcquiredLimit").add("LimitId", limitId()).add("Count", count()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "limitId":
            return Optional.ofNullable(clazz.cast(limitId()));
        case "count":
            return Optional.ofNullable(clazz.cast(count()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("limitId", LIMIT_ID_FIELD);
        map.put("count", COUNT_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AcquiredLimit, T> g) {
        return obj -> g.apply((AcquiredLimit) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends SdkPojo, CopyableBuilder<Builder, AcquiredLimit> {
        /**
         * <p>
         * The unique identifier of the limit.
         * </p>
         * 
         * @param limitId
         *        The unique identifier of the limit.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder limitId(String limitId);

        /**
         * <p>
         * The number of limit resources used.
         * </p>
         * 
         * @param count
         *        The number of limit resources used.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder count(Integer count);
    }

    static final class BuilderImpl implements Builder {
        private String limitId;

        private Integer count;

        private BuilderImpl() {
        }

        private BuilderImpl(AcquiredLimit model) {
            limitId(model.limitId);
            count(model.count);
        }

        public final String getLimitId() {
            return limitId;
        }

        public final void setLimitId(String limitId) {
            this.limitId = limitId;
        }

        @Override
        public final Builder limitId(String limitId) {
            this.limitId = limitId;
            return this;
        }

        public final Integer getCount() {
            return count;
        }

        public final void setCount(Integer count) {
            this.count = count;
        }

        @Override
        public final Builder count(Integer count) {
            this.count = count;
            return this;
        }

        @Override
        public AcquiredLimit build() {
            return new AcquiredLimit(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
