/*
 * Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
 * 
 * Licensed under the Apache License, Version 2.0 (the "License"). You may not use this file except in compliance with
 * the License. A copy of the License is located at
 * 
 * http://aws.amazon.com/apache2.0
 * 
 * or in the "license" file accompanying this file. This file is distributed on an "AS IS" BASIS, WITHOUT WARRANTIES OR
 * CONDITIONS OF ANY KIND, either express or implied. See the License for the specific language governing permissions
 * and limitations under the License.
 */

package software.amazon.awssdk.services.deadline.model;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import software.amazon.awssdk.annotations.Generated;
import software.amazon.awssdk.annotations.Mutable;
import software.amazon.awssdk.annotations.NotThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

/**
 */
@Generated("software.amazon.awssdk:codegen")
public final class AssociateMemberToQueueRequest extends DeadlineRequest implements
        ToCopyableBuilder<AssociateMemberToQueueRequest.Builder, AssociateMemberToQueueRequest> {
    private static final SdkField<String> FARM_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING).memberName("farmId")
            .getter(getter(AssociateMemberToQueueRequest::farmId)).setter(setter(Builder::farmId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("farmId").build()).build();

    private static final SdkField<String> QUEUE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("queueId").getter(getter(AssociateMemberToQueueRequest::queueId)).setter(setter(Builder::queueId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("queueId").build()).build();

    private static final SdkField<String> PRINCIPAL_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalId").getter(getter(AssociateMemberToQueueRequest::principalId))
            .setter(setter(Builder::principalId))
            .traits(LocationTrait.builder().location(MarshallLocation.PATH).locationName("principalId").build()).build();

    private static final SdkField<String> PRINCIPAL_TYPE_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("principalType").getter(getter(AssociateMemberToQueueRequest::principalTypeAsString))
            .setter(setter(Builder::principalType))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("principalType").build()).build();

    private static final SdkField<String> IDENTITY_STORE_ID_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("identityStoreId").getter(getter(AssociateMemberToQueueRequest::identityStoreId))
            .setter(setter(Builder::identityStoreId))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("identityStoreId").build()).build();

    private static final SdkField<String> MEMBERSHIP_LEVEL_FIELD = SdkField.<String> builder(MarshallingType.STRING)
            .memberName("membershipLevel").getter(getter(AssociateMemberToQueueRequest::membershipLevelAsString))
            .setter(setter(Builder::membershipLevel))
            .traits(LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("membershipLevel").build()).build();

    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(FARM_ID_FIELD, QUEUE_ID_FIELD,
            PRINCIPAL_ID_FIELD, PRINCIPAL_TYPE_FIELD, IDENTITY_STORE_ID_FIELD, MEMBERSHIP_LEVEL_FIELD));

    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = memberNameToFieldInitializer();

    private final String farmId;

    private final String queueId;

    private final String principalId;

    private final String principalType;

    private final String identityStoreId;

    private final String membershipLevel;

    private AssociateMemberToQueueRequest(BuilderImpl builder) {
        super(builder);
        this.farmId = builder.farmId;
        this.queueId = builder.queueId;
        this.principalId = builder.principalId;
        this.principalType = builder.principalType;
        this.identityStoreId = builder.identityStoreId;
        this.membershipLevel = builder.membershipLevel;
    }

    /**
     * <p>
     * The farm ID of the queue to associate with the member.
     * </p>
     * 
     * @return The farm ID of the queue to associate with the member.
     */
    public final String farmId() {
        return farmId;
    }

    /**
     * <p>
     * The ID of the queue to associate to the member.
     * </p>
     * 
     * @return The ID of the queue to associate to the member.
     */
    public final String queueId() {
        return queueId;
    }

    /**
     * <p>
     * The member's principal ID to associate with the queue.
     * </p>
     * 
     * @return The member's principal ID to associate with the queue.
     */
    public final String principalId() {
        return principalId;
    }

    /**
     * <p>
     * The member's principal type to associate with the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The member's principal type to associate with the queue.
     * @see PrincipalType
     */
    public final PrincipalType principalType() {
        return PrincipalType.fromValue(principalType);
    }

    /**
     * <p>
     * The member's principal type to associate with the queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #principalType}
     * will return {@link PrincipalType#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available from
     * {@link #principalTypeAsString}.
     * </p>
     * 
     * @return The member's principal type to associate with the queue.
     * @see PrincipalType
     */
    public final String principalTypeAsString() {
        return principalType;
    }

    /**
     * <p>
     * The member's identity store ID to associate with the queue.
     * </p>
     * 
     * @return The member's identity store ID to associate with the queue.
     */
    public final String identityStoreId() {
        return identityStoreId;
    }

    /**
     * <p>
     * The principal's membership level for the associated queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipLevel}
     * will return {@link MembershipLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipLevelAsString}.
     * </p>
     * 
     * @return The principal's membership level for the associated queue.
     * @see MembershipLevel
     */
    public final MembershipLevel membershipLevel() {
        return MembershipLevel.fromValue(membershipLevel);
    }

    /**
     * <p>
     * The principal's membership level for the associated queue.
     * </p>
     * <p>
     * If the service returns an enum value that is not available in the current SDK version, {@link #membershipLevel}
     * will return {@link MembershipLevel#UNKNOWN_TO_SDK_VERSION}. The raw value returned by the service is available
     * from {@link #membershipLevelAsString}.
     * </p>
     * 
     * @return The principal's membership level for the associated queue.
     * @see MembershipLevel
     */
    public final String membershipLevelAsString() {
        return membershipLevel;
    }

    @Override
    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    @Override
    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(farmId());
        hashCode = 31 * hashCode + Objects.hashCode(queueId());
        hashCode = 31 * hashCode + Objects.hashCode(principalId());
        hashCode = 31 * hashCode + Objects.hashCode(principalTypeAsString());
        hashCode = 31 * hashCode + Objects.hashCode(identityStoreId());
        hashCode = 31 * hashCode + Objects.hashCode(membershipLevelAsString());
        return hashCode;
    }

    @Override
    public final boolean equals(Object obj) {
        return super.equals(obj) && equalsBySdkFields(obj);
    }

    @Override
    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AssociateMemberToQueueRequest)) {
            return false;
        }
        AssociateMemberToQueueRequest other = (AssociateMemberToQueueRequest) obj;
        return Objects.equals(farmId(), other.farmId()) && Objects.equals(queueId(), other.queueId())
                && Objects.equals(principalId(), other.principalId())
                && Objects.equals(principalTypeAsString(), other.principalTypeAsString())
                && Objects.equals(identityStoreId(), other.identityStoreId())
                && Objects.equals(membershipLevelAsString(), other.membershipLevelAsString());
    }

    /**
     * Returns a string representation of this object. This is useful for testing and debugging. Sensitive data will be
     * redacted from this string using a placeholder value.
     */
    @Override
    public final String toString() {
        return ToString.builder("AssociateMemberToQueueRequest").add("FarmId", farmId()).add("QueueId", queueId())
                .add("PrincipalId", principalId()).add("PrincipalType", principalTypeAsString())
                .add("IdentityStoreId", identityStoreId()).add("MembershipLevel", membershipLevelAsString()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
        case "farmId":
            return Optional.ofNullable(clazz.cast(farmId()));
        case "queueId":
            return Optional.ofNullable(clazz.cast(queueId()));
        case "principalId":
            return Optional.ofNullable(clazz.cast(principalId()));
        case "principalType":
            return Optional.ofNullable(clazz.cast(principalTypeAsString()));
        case "identityStoreId":
            return Optional.ofNullable(clazz.cast(identityStoreId()));
        case "membershipLevel":
            return Optional.ofNullable(clazz.cast(membershipLevelAsString()));
        default:
            return Optional.empty();
        }
    }

    @Override
    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    @Override
    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        Map<String, SdkField<?>> map = new HashMap<>();
        map.put("farmId", FARM_ID_FIELD);
        map.put("queueId", QUEUE_ID_FIELD);
        map.put("principalId", PRINCIPAL_ID_FIELD);
        map.put("principalType", PRINCIPAL_TYPE_FIELD);
        map.put("identityStoreId", IDENTITY_STORE_ID_FIELD);
        map.put("membershipLevel", MEMBERSHIP_LEVEL_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<AssociateMemberToQueueRequest, T> g) {
        return obj -> g.apply((AssociateMemberToQueueRequest) obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder) obj, val);
    }

    @Mutable
    @NotThreadSafe
    public interface Builder extends DeadlineRequest.Builder, SdkPojo, CopyableBuilder<Builder, AssociateMemberToQueueRequest> {
        /**
         * <p>
         * The farm ID of the queue to associate with the member.
         * </p>
         * 
         * @param farmId
         *        The farm ID of the queue to associate with the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder farmId(String farmId);

        /**
         * <p>
         * The ID of the queue to associate to the member.
         * </p>
         * 
         * @param queueId
         *        The ID of the queue to associate to the member.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder queueId(String queueId);

        /**
         * <p>
         * The member's principal ID to associate with the queue.
         * </p>
         * 
         * @param principalId
         *        The member's principal ID to associate with the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder principalId(String principalId);

        /**
         * <p>
         * The member's principal type to associate with the queue.
         * </p>
         * 
         * @param principalType
         *        The member's principal type to associate with the queue.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(String principalType);

        /**
         * <p>
         * The member's principal type to associate with the queue.
         * </p>
         * 
         * @param principalType
         *        The member's principal type to associate with the queue.
         * @see PrincipalType
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see PrincipalType
         */
        Builder principalType(PrincipalType principalType);

        /**
         * <p>
         * The member's identity store ID to associate with the queue.
         * </p>
         * 
         * @param identityStoreId
         *        The member's identity store ID to associate with the queue.
         * @return Returns a reference to this object so that method calls can be chained together.
         */
        Builder identityStoreId(String identityStoreId);

        /**
         * <p>
         * The principal's membership level for the associated queue.
         * </p>
         * 
         * @param membershipLevel
         *        The principal's membership level for the associated queue.
         * @see MembershipLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipLevel
         */
        Builder membershipLevel(String membershipLevel);

        /**
         * <p>
         * The principal's membership level for the associated queue.
         * </p>
         * 
         * @param membershipLevel
         *        The principal's membership level for the associated queue.
         * @see MembershipLevel
         * @return Returns a reference to this object so that method calls can be chained together.
         * @see MembershipLevel
         */
        Builder membershipLevel(MembershipLevel membershipLevel);

        @Override
        Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration);

        @Override
        Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer);
    }

    static final class BuilderImpl extends DeadlineRequest.BuilderImpl implements Builder {
        private String farmId;

        private String queueId;

        private String principalId;

        private String principalType;

        private String identityStoreId;

        private String membershipLevel;

        private BuilderImpl() {
        }

        private BuilderImpl(AssociateMemberToQueueRequest model) {
            super(model);
            farmId(model.farmId);
            queueId(model.queueId);
            principalId(model.principalId);
            principalType(model.principalType);
            identityStoreId(model.identityStoreId);
            membershipLevel(model.membershipLevel);
        }

        public final String getFarmId() {
            return farmId;
        }

        public final void setFarmId(String farmId) {
            this.farmId = farmId;
        }

        @Override
        public final Builder farmId(String farmId) {
            this.farmId = farmId;
            return this;
        }

        public final String getQueueId() {
            return queueId;
        }

        public final void setQueueId(String queueId) {
            this.queueId = queueId;
        }

        @Override
        public final Builder queueId(String queueId) {
            this.queueId = queueId;
            return this;
        }

        public final String getPrincipalId() {
            return principalId;
        }

        public final void setPrincipalId(String principalId) {
            this.principalId = principalId;
        }

        @Override
        public final Builder principalId(String principalId) {
            this.principalId = principalId;
            return this;
        }

        public final String getPrincipalType() {
            return principalType;
        }

        public final void setPrincipalType(String principalType) {
            this.principalType = principalType;
        }

        @Override
        public final Builder principalType(String principalType) {
            this.principalType = principalType;
            return this;
        }

        @Override
        public final Builder principalType(PrincipalType principalType) {
            this.principalType(principalType == null ? null : principalType.toString());
            return this;
        }

        public final String getIdentityStoreId() {
            return identityStoreId;
        }

        public final void setIdentityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
        }

        @Override
        public final Builder identityStoreId(String identityStoreId) {
            this.identityStoreId = identityStoreId;
            return this;
        }

        public final String getMembershipLevel() {
            return membershipLevel;
        }

        public final void setMembershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
        }

        @Override
        public final Builder membershipLevel(String membershipLevel) {
            this.membershipLevel = membershipLevel;
            return this;
        }

        @Override
        public final Builder membershipLevel(MembershipLevel membershipLevel) {
            this.membershipLevel(membershipLevel == null ? null : membershipLevel.toString());
            return this;
        }

        @Override
        public Builder overrideConfiguration(AwsRequestOverrideConfiguration overrideConfiguration) {
            super.overrideConfiguration(overrideConfiguration);
            return this;
        }

        @Override
        public Builder overrideConfiguration(Consumer<AwsRequestOverrideConfiguration.Builder> builderConsumer) {
            super.overrideConfiguration(builderConsumer);
            return this;
        }

        @Override
        public AssociateMemberToQueueRequest build() {
            return new AssociateMemberToQueueRequest(this);
        }

        @Override
        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        @Override
        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }
}
